uniform vec3 camera;
uniform float fog_distance;
uniform int animationStep;
uniform float daylight;

attribute vec4 position;
attribute vec3 uv;
attribute float sunLight;

varying vec2 fragment_uv;
varying float fragment_light;
varying float fog_factor;
varying float fog_height;

const float pi = 3.14159265;

void main() {
    gl_Position = CC_MVPMatrix * position;
    
    fragment_uv = uv.xy + vec2(float(animationStep)/16.0, 0.0);
    //fragment_light = clamp(uv.z + daylight * 0.9, 0.0, 1.0); // previous shader
    fragment_light = clamp(0.1 + uv.z + daylight * (sunLight + 0.3), 0.0, 1.0);
    
    float camera_distance = distance(camera, vec3(position));
    fog_factor = pow(clamp(camera_distance / fog_distance, 0.0, 1.0), 4.0);
    float dy = position.y - camera.y;
    float dx = distance(position.xz, camera.xz);
    fog_height = (atan(dy, dx) + pi / 2.0) / pi;
}
