precision mediump float;
precision highp int;

uniform sampler2D sampler;
uniform sampler2D sky_sampler;
uniform float timer;

varying vec2 fragment_uv;
varying float fragment_light;
varying float fog_factor;
varying float fog_height;

varying float intensity;
varying float freq;

void main() {
    
    vec3 color1 = vec3(texture2D(sampler, fragment_uv));
    vec3 color2 = vec3(texture2D(sampler, fragment_uv + vec2(0.5,0.0) / 16.0 - vec2(0.0,0.5) / 32.0));
    
    float freqres = freq;
    freqres = min(mod(freqres * 2.0, 2.0), 2.0 - mod(freqres * 2.0, 2.0));
    
    vec3 color = color1 * (freqres) + color2 * (1.0 - freqres) + vec3(intensity, intensity, intensity);
    
    vec3 dark = vec3(0.28 + fragment_light * 0.72,
                     0.23 + fragment_light * 0.77,
                     0.38 + fragment_light * 0.62); // original version
    
    color = color * dark;
    
    
    vec3 sky_color = vec3(texture2D(sky_sampler, vec2(timer, 1.0 - fog_height)));
    
    color = mix(color, sky_color, fog_factor);
    
    gl_FragColor = vec4(color, 0.8);
}
