uniform vec3 camera;
uniform float fog_distance;
uniform float animationWave;
uniform float daylight;

attribute vec4 position;
attribute vec3 uv;
attribute float sunLight;

varying vec2 fragment_uv;
varying float fragment_light;
varying float fog_factor;
varying float fog_height;

varying float intensity;
varying float freq;

const float pi = 3.14159265;
const float displacement = 0.015625; //  = 1/64

void main() {
    float phase1 = (position.x + position.z * 0.5 + animationWave * 1.0);
    float phase2 = (position.x - position.z * 0.5 - animationWave * 0.5);
    float y = (sin(phase1 * 0.25) + sin(phase2));
    
    gl_Position = CC_MVPMatrix * (position + vec4(0, y * 0.075, 0, 0));
    
    freq = animationWave * 0.25;
    
    intensity = ((y + 2.0) * 0.04);
    
    fragment_uv = vec2(uv.x, displacement + uv.y);
    
    //fragment_light = clamp(uv.z + daylight * 0.9, 0.0, 1.0); // original version
    fragment_light = clamp(uv.z + sunLight * daylight, 0.0, 1.0);
    
    float camera_distance = distance(camera, vec3(position));
    fog_factor = pow(clamp(camera_distance / fog_distance, 0.0, 1.0), 4.0);
    
    float dy = position.y - camera.y;
    float dx = distance(position.xz, camera.xz);
    
    fog_height = (atan(dy, dx) + pi / 2.0) / pi;
}
