/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.Entry;
import java.util.List;

public class LineBuffer
extends AbstractBuffer<Entry> {
    public LineBuffer(int size) {
        super(size < 4 ? 4 : size);
    }

    public void moveTo(float x, float y) {
        if (this.index != 0) {
            return;
        }
        this.buffer[this.index++] = x;
        this.buffer[this.index++] = y;
        this.buffer[this.index] = x;
        this.buffer[this.index + 1] = y;
    }

    public void lineTo(float x, float y) {
        if (this.index == 2) {
            this.buffer[this.index++] = x;
            this.buffer[this.index++] = y;
        } else {
            float prevX = this.buffer[this.index - 2];
            float prevY = this.buffer[this.index - 1];
            this.buffer[this.index++] = prevX;
            this.buffer[this.index++] = prevY;
            this.buffer[this.index++] = x;
            this.buffer[this.index++] = y;
        }
    }

    @Override
    public void feed(List<Entry> entries) {
        int from;
        this.moveTo(entries.get(this.mFrom).getXIndex(), entries.get(this.mFrom).getVal() * this.phaseY);
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        int i = from = this.mFrom + 1;
        while (i < size) {
            Entry e = entries.get(i);
            this.lineTo(e.getXIndex(), e.getVal() * this.phaseY);
            ++i;
        }
        this.reset();
    }
}

