/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarLineScatterCandleData;
import com.github.mikephil.charting.data.BarLineScatterCandleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.data.filter.Approximator;
import com.github.mikephil.charting.interfaces.BarLineScatterCandleDataProvider;
import com.github.mikephil.charting.jobs.MoveViewJob;
import com.github.mikephil.charting.listener.BarLineChartTouchListener;
import com.github.mikephil.charting.listener.OnDrawListener;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.FillFormatter;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"RtlHardcoded"})
public abstract class BarLineChartBase<T extends BarLineScatterCandleData<? extends BarLineScatterCandleDataSet<? extends Entry>>>
extends Chart<T>
implements BarLineScatterCandleDataProvider {
    protected int mMaxVisibleCount = 100;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDoubleTapToZoomEnabled = true;
    protected boolean mHighlightPerDragEnabled = true;
    protected boolean mHighLightIndicatorEnabled = true;
    private boolean mDragEnabled = true;
    private boolean mScaleXEnabled = true;
    private boolean mScaleYEnabled = true;
    protected boolean mFilterData = false;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected boolean mDrawGridBackground = true;
    protected boolean mDrawBorders = false;
    protected OnDrawListener mDrawListener;
    protected YAxis mAxisLeft;
    protected YAxis mAxisRight;
    protected XAxis mXAxis;
    protected YAxisRenderer mAxisRendererLeft;
    protected YAxisRenderer mAxisRendererRight;
    protected Transformer mLeftAxisTransformer;
    protected Transformer mRightAxisTransformer;
    protected XAxisRenderer mXAxisRenderer;
    private long totalTime = 0L;
    private long drawCycles = 0L;
    protected View.OnTouchListener mListener;
    private boolean mCustomViewPortEnabled = false;

    public BarLineChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BarLineChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mAxisLeft = new YAxis(YAxis.AxisDependency.LEFT);
        this.mAxisRight = new YAxis(YAxis.AxisDependency.RIGHT);
        this.mXAxis = new XAxis();
        this.mLeftAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mRightAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mAxisRendererLeft = new YAxisRenderer(this.mViewPortHandler, this.mAxisLeft, this.mLeftAxisTransformer);
        this.mAxisRendererRight = new YAxisRenderer(this.mViewPortHandler, this.mAxisRight, this.mRightAxisTransformer);
        this.mXAxisRenderer = new XAxisRenderer(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer);
        this.mListener = new BarLineChartTouchListener<BarLineChartBase>(this, this.mViewPortHandler.getMatrixTouch());
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(Color.rgb((int)240, (int)240, (int)240));
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.calcModulus();
        this.mXAxisRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.mRenderer.calcXBounds(this, this.mXAxis.mAxisLabelModulus);
        this.drawGridBackground(canvas);
        if (this.mAxisLeft.isEnabled()) {
            this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        }
        if (this.mAxisRight.isEnabled()) {
            this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        }
        this.mXAxisRenderer.renderAxisLine(canvas);
        this.mAxisRendererLeft.renderAxisLine(canvas);
        this.mAxisRendererRight.renderAxisLine(canvas);
        int clipRestoreCount = canvas.save();
        canvas.clipRect(this.mViewPortHandler.getContentRect());
        this.mXAxisRenderer.renderGridLines(canvas);
        this.mAxisRendererLeft.renderGridLines(canvas);
        this.mAxisRendererRight.renderGridLines(canvas);
        if (this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        this.mRenderer.drawData(canvas);
        if (!this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (!this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (!this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        if (this.mHighlightEnabled && this.mHighLightIndicatorEnabled && this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHightlight);
        }
        canvas.restoreToCount(clipRestoreCount);
        this.mRenderer.drawExtras(canvas);
        this.mXAxisRenderer.renderAxisLabels(canvas);
        this.mAxisRendererLeft.renderAxisLabels(canvas);
        this.mAxisRendererRight.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawMarkers(canvas);
        this.drawDescription(canvas);
        if (this.mLogEnabled) {
            long drawtime = System.currentTimeMillis() - starttime;
            this.totalTime += drawtime;
            ++this.drawCycles;
            long average = this.totalTime / this.drawCycles;
            Log.i((String)"MPAndroidChart", (String)("Drawtime: " + drawtime + " ms, average: " + average + " ms, cycles: " + this.drawCycles));
        }
    }

    public void resetTracking() {
        this.totalTime = 0L;
        this.drawCycles = 0L;
    }

    protected void prepareValuePxMatrix() {
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("Preparing Value-Px Matrix, xmin: " + this.mXChartMin + ", xmax: " + this.mXChartMax + ", xdelta: " + this.mDeltaX));
        }
        this.mRightAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisRight.mAxisRange, this.mAxisRight.mAxisMinimum);
        this.mLeftAxisTransformer.prepareMatrixValuePx(this.mXChartMin, this.mDeltaX, this.mAxisLeft.mAxisRange, this.mAxisLeft.mAxisMinimum);
    }

    protected void prepareOffsetMatrix() {
        this.mRightAxisTransformer.prepareMatrixOffset(this.mAxisRight.isInverted());
        this.mLeftAxisTransformer.prepareMatrixOffset(this.mAxisLeft.isInverted());
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mDataNotSet) {
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)"Preparing... DATA NOT SET.");
            }
            return;
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)"Preparing...");
        }
        if (this.mRenderer != null) {
            this.mRenderer.initBuffers();
        }
        this.calcMinMax();
        if (this.mAxisLeft.needsDefaultFormatter()) {
            this.mAxisLeft.setValueFormatter(this.mDefaultFormatter);
        }
        if (this.mAxisRight.needsDefaultFormatter()) {
            this.mAxisRight.setValueFormatter(this.mDefaultFormatter);
        }
        this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum);
        this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum);
        this.mXAxisRenderer.computeAxis(((BarLineScatterCandleData)this.mData).getXValAverageLength(), ((BarLineScatterCandleData)this.mData).getXVals());
        this.mLegendRenderer.computeLegend(this.mData);
        this.calculateOffsets();
    }

    @Override
    protected void calcMinMax() {
        float minLeft = ((BarLineScatterCandleData)this.mData).getYMin(YAxis.AxisDependency.LEFT);
        float maxLeft = ((BarLineScatterCandleData)this.mData).getYMax(YAxis.AxisDependency.LEFT);
        float minRight = ((BarLineScatterCandleData)this.mData).getYMin(YAxis.AxisDependency.RIGHT);
        float maxRight = ((BarLineScatterCandleData)this.mData).getYMax(YAxis.AxisDependency.RIGHT);
        float leftRange = Math.abs(maxLeft - (this.mAxisLeft.isStartAtZeroEnabled() ? 0.0f : minLeft));
        float rightRange = Math.abs(maxRight - (this.mAxisRight.isStartAtZeroEnabled() ? 0.0f : minRight));
        if (leftRange == 0.0f) {
            maxLeft += 1.0f;
            if (!this.mAxisLeft.isStartAtZeroEnabled()) {
                minLeft -= 1.0f;
            }
        }
        if (rightRange == 0.0f) {
            maxRight += 1.0f;
            if (!this.mAxisRight.isStartAtZeroEnabled()) {
                minRight -= 1.0f;
            }
        }
        float topSpaceLeft = leftRange / 100.0f * this.mAxisLeft.getSpaceTop();
        float topSpaceRight = rightRange / 100.0f * this.mAxisRight.getSpaceTop();
        float bottomSpaceLeft = leftRange / 100.0f * this.mAxisLeft.getSpaceBottom();
        float bottomSpaceRight = rightRange / 100.0f * this.mAxisRight.getSpaceBottom();
        this.mXChartMax = ((BarLineScatterCandleData)this.mData).getXVals().size() - 1;
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        this.mAxisLeft.mAxisMaximum = !Float.isNaN(this.mAxisLeft.getAxisMaxValue()) ? this.mAxisLeft.getAxisMaxValue() : maxLeft + topSpaceLeft;
        this.mAxisRight.mAxisMaximum = !Float.isNaN(this.mAxisRight.getAxisMaxValue()) ? this.mAxisRight.getAxisMaxValue() : maxRight + topSpaceRight;
        this.mAxisLeft.mAxisMinimum = !Float.isNaN(this.mAxisLeft.getAxisMinValue()) ? this.mAxisLeft.getAxisMinValue() : minLeft - bottomSpaceLeft;
        float f = this.mAxisRight.mAxisMinimum = !Float.isNaN(this.mAxisRight.getAxisMinValue()) ? this.mAxisRight.getAxisMinValue() : minRight - bottomSpaceRight;
        if (this.mAxisLeft.isStartAtZeroEnabled()) {
            this.mAxisLeft.mAxisMinimum = 0.0f;
        }
        if (this.mAxisRight.isStartAtZeroEnabled()) {
            this.mAxisRight.mAxisMinimum = 0.0f;
        }
        this.mAxisLeft.mAxisRange = Math.abs(this.mAxisLeft.mAxisMaximum - this.mAxisLeft.mAxisMinimum);
        this.mAxisRight.mAxisRange = Math.abs(this.mAxisRight.mAxisMaximum - this.mAxisRight.mAxisMinimum);
    }

    @Override
    protected void calculateOffsets() {
        if (!this.mCustomViewPortEnabled) {
            float offsetLeft = 0.0f;
            float offsetRight = 0.0f;
            float offsetTop = 0.0f;
            float offsetBottom = 0.0f;
            if (this.mLegend != null && this.mLegend.isEnabled()) {
                if (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER) {
                    offsetRight += this.mLegend.mTextWidthMax + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER) {
                    offsetLeft += this.mLegend.mTextWidthMax + this.mLegend.getXOffset() * 2.0f;
                } else if (this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_LEFT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_RIGHT || this.mLegend.getPosition() == Legend.LegendPosition.BELOW_CHART_CENTER) {
                    offsetBottom += this.mLegend.mTextHeightMax * 3.0f;
                }
            }
            if (this.mAxisLeft.needsOffset()) {
                offsetLeft += this.mAxisLeft.getRequiredWidthSpace(this.mAxisRendererLeft.getPaintAxisLabels());
            }
            if (this.mAxisRight.needsOffset()) {
                offsetRight += this.mAxisRight.getRequiredWidthSpace(this.mAxisRendererRight.getPaintAxisLabels());
            }
            float xlabelheight = (float)this.mXAxis.mLabelHeight * 2.0f;
            if (this.mXAxis.isEnabled()) {
                if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                    offsetBottom += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                    offsetTop += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                    offsetBottom += xlabelheight;
                    offsetTop += xlabelheight;
                }
            }
            float min = Utils.convertDpToPixel(10.0f);
            this.mViewPortHandler.restrainViewPort(Math.max(min, offsetLeft), Math.max(min, offsetTop), Math.max(min, offsetRight), Math.max(min, offsetBottom));
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom));
                Log.i((String)"MPAndroidChart", (String)("Content: " + this.mViewPortHandler.getContentRect().toString()));
            }
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    protected void calcModulus() {
        if (this.mXAxis == null || !this.mXAxis.isEnabled()) {
            return;
        }
        if (!this.mXAxis.isAxisModulusCustom()) {
            float[] values = new float[9];
            this.mViewPortHandler.getMatrixTouch().getValues(values);
            this.mXAxis.mAxisLabelModulus = (int)Math.ceil((float)(((BarLineScatterCandleData)this.mData).getXValCount() * this.mXAxis.mLabelWidth) / (this.mViewPortHandler.contentWidth() * values[0]));
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("X-Axis modulus: " + this.mXAxis.mAxisLabelModulus + ", x-axis label width: " + this.mXAxis.mLabelWidth + ", content width: " + this.mViewPortHandler.contentWidth()));
        }
        if (this.mXAxis.mAxisLabelModulus < 1) {
            this.mXAxis.mAxisLabelModulus = 1;
        }
    }

    @Override
    protected float[] getMarkerPosition(Entry e, int dataSetIndex) {
        float xPos = e.getXIndex();
        if (this instanceof BarChart) {
            BarData bd = (BarData)this.mData;
            float space = bd.getGroupSpace();
            float j = ((BarLineScatterCandleDataSet)((BarLineScatterCandleData)this.mData).getDataSetByIndex(dataSetIndex)).getEntryPosition(e);
            float x = j * (float)(((BarLineScatterCandleData)this.mData).getDataSetCount() - 1) + (float)dataSetIndex + space * j + space / 2.0f;
            xPos += x;
        }
        float[] pts = new float[]{xPos, e.getVal() * this.mAnimator.getPhaseY()};
        this.getTransformer(((BarLineScatterCandleDataSet)((BarLineScatterCandleData)this.mData).getDataSetByIndex(dataSetIndex)).getAxisDependency()).pointValuesToPixel(pts);
        return pts;
    }

    protected void drawGridBackground(Canvas c) {
        if (this.mDrawGridBackground) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mGridBackgroundPaint);
        }
        if (this.mDrawBorders) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mBorderPaint);
        }
    }

    @Override
    public Transformer getTransformer(YAxis.AxisDependency which) {
        if (which == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisTransformer;
        }
        return this.mRightAxisTransformer;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mListener == null || this.mDataNotSet) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mListener.onTouch((View)this, event);
    }

    public void computeScroll() {
        if (this.mListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mListener).computeScroll();
        }
    }

    public void zoomIn() {
        Matrix save = this.mViewPortHandler.zoomIn((float)this.getWidth() / 2.0f, -((float)this.getHeight() / 2.0f));
        this.mViewPortHandler.refresh(save, (View)this, true);
    }

    public void zoomOut() {
        Matrix save = this.mViewPortHandler.zoomOut((float)this.getWidth() / 2.0f, -((float)this.getHeight() / 2.0f));
        this.mViewPortHandler.refresh(save, (View)this, true);
    }

    public void zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = this.mViewPortHandler.zoom(scaleX, scaleY, x, -y);
        this.mViewPortHandler.refresh(save, (View)this, true);
    }

    public void fitScreen() {
        Matrix save = this.mViewPortHandler.fitScreen();
        this.mViewPortHandler.refresh(save, (View)this, true);
    }

    public void setScaleMinima(float scaleX, float scaleY) {
        this.mViewPortHandler.setMinimumScaleX(scaleX);
        this.mViewPortHandler.setMinimumScaleY(scaleY);
    }

    public void setVisibleXRange(float xRange) {
        float xScale = this.mDeltaX / xRange;
        this.mViewPortHandler.setMinimumScaleX(xScale);
    }

    public void setVisibleYRange(float yRange, YAxis.AxisDependency axis) {
        float yScale = this.getDeltaY(axis) / yRange;
        this.mViewPortHandler.setMinimumScaleY(yScale);
    }

    public void moveViewToX(float xIndex) {
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, xIndex, 0.0f, this.getTransformer(YAxis.AxisDependency.LEFT), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void moveViewToY(float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, 0.0f, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void moveViewTo(float xIndex, float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, xIndex, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void centerViewTo(int xIndex, float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        float xsInView = (float)this.getXAxis().getValues().size() / this.mViewPortHandler.getScaleX();
        MoveViewJob job = new MoveViewJob(this.mViewPortHandler, (float)xIndex - xsInView / 2.0f, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public void setViewPortOffsets(final float left, final float top, final float right, final float bottom) {
        this.mCustomViewPortEnabled = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                BarLineChartBase.this.mViewPortHandler.restrainViewPort(left, top, right, bottom);
                BarLineChartBase.this.prepareOffsetMatrix();
                BarLineChartBase.this.prepareValuePxMatrix();
            }
        });
    }

    public void resetViewPortOffsets() {
        this.mCustomViewPortEnabled = false;
        this.calculateOffsets();
    }

    public float getDeltaY(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft.mAxisRange;
        }
        return this.mAxisRight.mAxisRange;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mListener = l;
    }

    public void setOnDrawListener(OnDrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public PointF getPosition(Entry e, YAxis.AxisDependency axis) {
        if (e == null) {
            return null;
        }
        float[] vals = new float[]{e.getXIndex(), e.getVal()};
        this.getTransformer(axis).pointValuesToPixel(vals);
        return new PointF(vals[0], vals[1]);
    }

    public void setMaxVisibleValueCount(int count) {
        this.mMaxVisibleCount = count;
    }

    @Override
    public int getMaxVisibleCount() {
        return this.mMaxVisibleCount;
    }

    public void setHighlightIndicatorEnabled(boolean enabled) {
        this.mHighLightIndicatorEnabled = enabled;
    }

    public void setHighlightPerDragEnabled(boolean enabled) {
        this.mHighlightPerDragEnabled = enabled;
    }

    public boolean isHighlightPerDragEnabled() {
        return this.mHighlightPerDragEnabled;
    }

    public void setGridBackgroundColor(int color) {
        this.mGridBackgroundPaint.setColor(color);
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setScaleEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
        this.mScaleYEnabled = enabled;
    }

    public void setScaleXEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
    }

    public void setScaleYEnabled(boolean enabled) {
        this.mScaleYEnabled = enabled;
    }

    public boolean isScaleXEnabled() {
        return this.mScaleXEnabled;
    }

    public boolean isScaleYEnabled() {
        return this.mScaleYEnabled;
    }

    public void setDoubleTapToZoomEnabled(boolean enabled) {
        this.mDoubleTapToZoomEnabled = enabled;
    }

    public boolean isDoubleTapToZoomEnabled() {
        return this.mDoubleTapToZoomEnabled;
    }

    public void setDrawGridBackground(boolean enabled) {
        this.mDrawGridBackground = enabled;
    }

    public void setDrawBorders(boolean enabled) {
        this.mDrawBorders = enabled;
    }

    public void setBorderWidth(float width) {
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(width));
    }

    public void setBorderColor(int color) {
        this.mBorderPaint.setColor(color);
    }

    public Highlight getHighlightByTouchPoint(float x, float y) {
        YAxis.AxisDependency axis;
        int dataSetIndex;
        if (this.mDataNotSet || this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        float[] pts = new float[2];
        pts[0] = x;
        this.mLeftAxisTransformer.pixelsToValue(pts);
        double xTouchVal = pts[0];
        double base = Math.floor(xTouchVal);
        double touchOffset = (double)this.mDeltaX * 0.025;
        if (xTouchVal < -touchOffset || xTouchVal > (double)this.mDeltaX + touchOffset) {
            return null;
        }
        if (base < 0.0) {
            base = 0.0;
        }
        if (base >= (double)this.mDeltaX) {
            base = this.mDeltaX - 1.0f;
        }
        int xIndex = (int)base;
        if (xTouchVal - base > 0.5) {
            xIndex = (int)base + 1;
        }
        List<SelInfo> valsAtIndex = this.getYValsAtIndex(xIndex);
        float leftdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.LEFT);
        float rightdist = Utils.getMinimumDistance(valsAtIndex, y, YAxis.AxisDependency.RIGHT);
        if (((BarLineScatterCandleData)this.mData).getFirstRight() == null) {
            rightdist = Float.MAX_VALUE;
        }
        if (((BarLineScatterCandleData)this.mData).getFirstLeft() == null) {
            leftdist = Float.MAX_VALUE;
        }
        if ((dataSetIndex = Utils.getClosestDataSetIndex(valsAtIndex, y, axis = leftdist < rightdist ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT)) == -1) {
            return null;
        }
        return new Highlight(xIndex, dataSetIndex);
    }

    public List<SelInfo> getYValsAtIndex(int xIndex) {
        ArrayList<SelInfo> vals = new ArrayList<SelInfo>();
        float[] pts = new float[2];
        int i = 0;
        while (i < ((BarLineScatterCandleData)this.mData).getDataSetCount()) {
            float yVal;
            Object dataSet = ((BarLineScatterCandleData)this.mData).getDataSetByIndex(i);
            pts[1] = yVal = ((DataSet)dataSet).getYValForXIndex(xIndex);
            this.getTransformer(((DataSet)dataSet).getAxisDependency()).pointValuesToPixel(pts);
            if (!Float.isNaN(pts[1])) {
                vals.add(new SelInfo(pts[1], i, (DataSet<?>)dataSet));
            }
            ++i;
        }
        return vals;
    }

    public PointD getValuesByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        float[] pts = new float[]{x, y};
        this.getTransformer(axis).pixelsToValue(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        return new PointD(xTouchVal, yTouchVal);
    }

    public PointD getPixelsForValues(float x, float y, YAxis.AxisDependency axis) {
        float[] pts = new float[]{x, y};
        this.getTransformer(axis).pointValuesToPixel(pts);
        return new PointD(pts[0], pts[1]);
    }

    public float getYValueByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        return (float)this.getValuesByTouchPoint((float)x, (float)y, (YAxis.AxisDependency)axis).y;
    }

    public Entry getEntryByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return ((BarLineScatterCandleData)this.mData).getEntryForHighlight(h);
        }
        return null;
    }

    public BarLineScatterCandleDataSet<? extends Entry> getDataSetByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return (BarLineScatterCandleDataSet)((BarLineScatterCandleData)this.mData).getDataSetByIndex(h.getDataSetIndex());
        }
        return null;
    }

    @Override
    public int getLowestVisibleXIndex() {
        float[] pts = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return pts[0] <= 0.0f ? 0 : (int)(pts[0] + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float[] pts = new float[]{this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        return pts[0] >= (float)((BarLineScatterCandleData)this.mData).getXValCount() ? ((BarLineScatterCandleData)this.mData).getXValCount() - 1 : (int)pts[0];
    }

    public float getScaleX() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleX();
    }

    public float getScaleY() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleY();
    }

    public boolean isFullyZoomedOut() {
        return this.mViewPortHandler.isFullyZoomedOut();
    }

    public YAxis getAxisLeft() {
        return this.mAxisLeft;
    }

    public YAxis getAxisRight() {
        return this.mAxisRight;
    }

    public YAxis getAxis(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft;
        }
        return this.mAxisRight;
    }

    @Override
    public boolean isInverted(YAxis.AxisDependency axis) {
        return this.getAxis(axis).isInverted();
    }

    public XAxis getXAxis() {
        return this.mXAxis;
    }

    public void enableFiltering(Approximator a) {
        this.mFilterData = true;
    }

    public void disableFiltering() {
        this.mFilterData = false;
    }

    public boolean isFilteringEnabled() {
        return this.mFilterData;
    }

    public void setPinchZoom(boolean enabled) {
        this.mPinchZoomEnabled = enabled;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    public void setDragOffsetX(float offset) {
        this.mViewPortHandler.setDragOffsetX(offset);
    }

    public void setDragOffsetY(float offset) {
        this.mViewPortHandler.setDragOffsetY(offset);
    }

    public boolean hasNoDragOffset() {
        return this.mViewPortHandler.hasNoDragOffset();
    }

    public XAxisRenderer getRendererXAxis() {
        return this.mXAxisRenderer;
    }

    public YAxisRenderer getRendererLeftYAxis() {
        return this.mAxisRendererLeft;
    }

    public YAxisRenderer getRendererRightYAxis() {
        return this.mAxisRendererRight;
    }

    @Override
    public float getYChartMax() {
        return Math.max(this.mAxisLeft.mAxisMaximum, this.mAxisRight.mAxisMaximum);
    }

    @Override
    public float getYChartMin() {
        return Math.min(this.mAxisLeft.mAxisMinimum, this.mAxisRight.mAxisMinimum);
    }

    public boolean isAnyAxisInverted() {
        if (this.mAxisLeft.isInverted()) {
            return true;
        }
        return this.mAxisRight.isInverted();
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 4: {
                this.mGridBackgroundPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 4: {
                return this.mGridBackgroundPaint;
            }
        }
        return null;
    }

    protected class DefaultFillFormatter
    implements FillFormatter {
        protected DefaultFillFormatter() {
        }

        @Override
        public float getFillLinePosition(LineDataSet dataSet, LineData data, float chartMaxY, float chartMinY) {
            float fillMin = 0.0f;
            if (dataSet.getYMax() > 0.0f && dataSet.getYMin() < 0.0f) {
                fillMin = 0.0f;
            } else if (!BarLineChartBase.this.getAxis(dataSet.getAxisDependency()).isStartAtZeroEnabled()) {
                float max = data.getYMax() > 0.0f ? 0.0f : chartMaxY;
                float min = data.getYMin() < 0.0f ? 0.0f : chartMinY;
                fillMin = dataSet.getYMin() >= 0.0f ? min : max;
            } else {
                fillMin = 0.0f;
            }
            return fillMin;
        }
    }
}

