/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.interfaces.LineDataProvider;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.utils.FillFormatter;

public class LineChart
extends BarLineChartBase<LineData>
implements LineDataProvider {
    protected float mHighlightWidth = 3.0f;
    private FillFormatter mFillFormatter;

    public LineChart(Context context) {
        super(context);
    }

    public LineChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LineChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new LineChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mFillFormatter = new BarLineChartBase.DefaultFillFormatter();
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        if (this.mDeltaX == 0.0f && ((LineData)this.mData).getYValCount() > 0) {
            this.mDeltaX = 1.0f;
        }
    }

    public void setHighlightLineWidth(float width) {
        this.mHighlightWidth = width;
    }

    public float getHighlightLineWidth() {
        return this.mHighlightWidth;
    }

    @Override
    public void setFillFormatter(FillFormatter formatter) {
        if (formatter == null) {
            formatter = new BarLineChartBase.DefaultFillFormatter();
        } else {
            this.mFillFormatter = formatter;
        }
    }

    @Override
    public FillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }

    @Override
    public LineData getLineData() {
        return (LineData)this.mData;
    }
}

