/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.renderer.PieChartRenderer;
import com.github.mikephil.charting.utils.Utils;
import java.util.List;

public class PieChart
extends PieRadarChartBase<PieData> {
    private RectF mCircleBox = new RectF();
    private boolean mDrawXLabels = true;
    private float[] mDrawAngles;
    private float[] mAbsoluteAngles;
    private boolean mDrawHole = true;
    private boolean mUsePercentValues = false;
    private String mCenterText = "";
    private float mHoleRadiusPercent = 50.0f;
    private float mTransparentCircleRadiusPercent = 55.0f;
    private boolean mDrawCenterText = true;

    public PieChart(Context context) {
        super(context);
    }

    public PieChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PieChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new PieChartRenderer(this, this.mAnimator, this.mViewPortHandler);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDataNotSet) {
            return;
        }
        this.mRenderer.drawData(canvas);
        if (this.mHighlightEnabled && this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHightlight);
        }
        this.mRenderer.drawExtras(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawDescription(canvas);
    }

    @Override
    protected void calculateOffsets() {
        super.calculateOffsets();
        if (this.mDataNotSet) {
            return;
        }
        float diameter = this.getDiameter();
        float boxSize = diameter / 2.0f;
        PointF c = this.getCenterOffsets();
        this.mCircleBox.set(c.x - boxSize, c.y - boxSize, c.x + boxSize, c.y + boxSize);
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        this.calcAngles();
    }

    @Override
    protected float[] getMarkerPosition(Entry e, int dataSetIndex) {
        return new float[0];
    }

    private void calcAngles() {
        this.mDrawAngles = new float[((PieData)this.mData).getYValCount()];
        this.mAbsoluteAngles = new float[((PieData)this.mData).getYValCount()];
        List dataSets = ((PieData)this.mData).getDataSets();
        int cnt = 0;
        int i = 0;
        while (i < ((PieData)this.mData).getDataSetCount()) {
            PieDataSet set = (PieDataSet)dataSets.get(i);
            List entries = set.getYVals();
            int j = 0;
            while (j < entries.size()) {
                this.mDrawAngles[cnt] = this.calcAngle(Math.abs(((Entry)entries.get(j)).getVal()));
                this.mAbsoluteAngles[cnt] = cnt == 0 ? this.mDrawAngles[cnt] : this.mAbsoluteAngles[cnt - 1] + this.mDrawAngles[cnt];
                ++cnt;
                ++j;
            }
            ++i;
        }
    }

    public boolean needsHighlight(int xIndex, int dataSetIndex) {
        if (!this.valuesToHighlight() || dataSetIndex < 0) {
            return false;
        }
        int i = 0;
        while (i < this.mIndicesToHightlight.length) {
            if (this.mIndicesToHightlight[i].getXIndex() == xIndex && this.mIndicesToHightlight[i].getDataSetIndex() == dataSetIndex) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private float calcAngle(float value) {
        return value / ((PieData)this.mData).getYValueSum() * 360.0f;
    }

    @Override
    public int getIndexForAngle(float angle) {
        float a = Utils.getNormalizedAngle(angle - this.getRotationAngle());
        int i = 0;
        while (i < this.mAbsoluteAngles.length) {
            if (this.mAbsoluteAngles[i] > a) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDataSetIndexForIndex(int xIndex) {
        List dataSets = ((PieData)this.mData).getDataSets();
        int i = 0;
        while (i < dataSets.size()) {
            if (((DataSet)dataSets.get(i)).getEntryForXIndex(xIndex) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public float[] getDrawAngles() {
        return this.mDrawAngles;
    }

    public float[] getAbsoluteAngles() {
        return this.mAbsoluteAngles;
    }

    public void setHoleColor(int color) {
        ((PieChartRenderer)this.mRenderer).getPaintHole().setXfermode(null);
        ((PieChartRenderer)this.mRenderer).getPaintHole().setColor(color);
    }

    public void setHoleColorTransparent(boolean enable) {
        if (enable) {
            ((PieChartRenderer)this.mRenderer).getPaintHole().setColor(-1);
            ((PieChartRenderer)this.mRenderer).getPaintHole().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        } else {
            ((PieChartRenderer)this.mRenderer).getPaintHole().setXfermode(null);
        }
    }

    public boolean isHoleTransparent() {
        return ((PieChartRenderer)this.mRenderer).getPaintHole().getXfermode() != null;
    }

    public void setDrawHoleEnabled(boolean enabled) {
        this.mDrawHole = enabled;
    }

    public boolean isDrawHoleEnabled() {
        return this.mDrawHole;
    }

    public void setCenterText(String text) {
        this.mCenterText = text;
    }

    public String getCenterText() {
        return this.mCenterText;
    }

    public void setDrawCenterText(boolean enabled) {
        this.mDrawCenterText = enabled;
    }

    public boolean isDrawCenterTextEnabled() {
        return this.mDrawCenterText;
    }

    @Override
    protected float getRequiredBottomOffset() {
        return this.mLegendRenderer.getLabelPaint().getTextSize() * 4.0f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return 0.0f;
    }

    @Override
    public float getRadius() {
        if (this.mCircleBox == null) {
            return 0.0f;
        }
        return Math.min(this.mCircleBox.width() / 2.0f, this.mCircleBox.height() / 2.0f);
    }

    public RectF getCircleBox() {
        return this.mCircleBox;
    }

    public PointF getCenterCircleBox() {
        return new PointF(this.mCircleBox.centerX(), this.mCircleBox.centerY());
    }

    public void setCenterTextTypeface(Typeface t) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTypeface(t);
    }

    public void setCenterTextSize(float sizeDp) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTextSize(Utils.convertDpToPixel(sizeDp));
    }

    public void setCenterTextSizePixels(float sizePixels) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTextSize(sizePixels);
    }

    public void setCenterTextColor(int color) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setColor(color);
    }

    public void setHoleRadius(float percent) {
        this.mHoleRadiusPercent = percent;
    }

    public float getHoleRadius() {
        return this.mHoleRadiusPercent;
    }

    public void setTransparentCircleColor(int color) {
        ((PieChartRenderer)this.mRenderer).getPaintTransparentCircle().setColor(color);
    }

    public void setTransparentCircleRadius(float percent) {
        this.mTransparentCircleRadiusPercent = percent;
    }

    public float getTransparentCircleRadius() {
        return this.mTransparentCircleRadiusPercent;
    }

    public void setDrawSliceText(boolean enabled) {
        this.mDrawXLabels = enabled;
    }

    public boolean isDrawSliceTextEnabled() {
        return this.mDrawXLabels;
    }

    public void setUsePercentValues(boolean enabled) {
        this.mUsePercentValues = enabled;
    }

    public boolean isUsePercentValuesEnabled() {
        return this.mUsePercentValues;
    }
}

