/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.Entry;

public class BarEntry
extends Entry {
    private float[] mVals;

    public BarEntry(float[] vals, int xIndex) {
        super(BarEntry.calcSum(vals), xIndex);
        this.mVals = vals;
    }

    public BarEntry(float val, int xIndex) {
        super(val, xIndex);
    }

    public BarEntry(float[] vals, int xIndex, String label) {
        super(BarEntry.calcSum(vals), xIndex, label);
        this.mVals = vals;
    }

    public BarEntry(float val, int xIndex, Object data) {
        super(val, xIndex, data);
    }

    @Override
    public BarEntry copy() {
        BarEntry copied = new BarEntry(this.getVal(), this.getXIndex(), this.getData());
        copied.mVals = this.mVals;
        return copied;
    }

    public float[] getVals() {
        return this.mVals;
    }

    public void setVals(float[] vals) {
        this.mVals = vals;
    }

    public int getClosestIndexAbove(float val) {
        if (this.mVals == null) {
            return 0;
        }
        int index = this.mVals.length - 1;
        float remainder = 0.0f;
        while (index > 0 && val > this.mVals[index] + remainder) {
            remainder += this.mVals[index];
            --index;
        }
        return index;
    }

    public float getBelowSum(int stackIndex) {
        if (this.mVals == null) {
            return 0.0f;
        }
        float remainder = 0.0f;
        int index = this.mVals.length - 1;
        while (index > stackIndex && index >= 0) {
            remainder += this.mVals[index];
            --index;
        }
        return remainder;
    }

    private static float calcSum(float[] vals) {
        float sum = 0.0f;
        float[] fArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            sum += f;
            ++n2;
        }
        return sum;
    }
}

