/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Paint;
import com.github.mikephil.charting.data.BarLineScatterCandleDataSet;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class CandleDataSet
extends BarLineScatterCandleDataSet<CandleEntry> {
    private float mShadowWidth = 3.0f;
    private float mBodySpace = 0.1f;
    protected Paint.Style mIncreasingPaintStyle = Paint.Style.FILL;
    protected Paint.Style mDecreasingPaintStyle = Paint.Style.STROKE;
    protected int mIncreasingColor = -1;
    protected int mDecreasingColor = -1;
    protected int mShadowColor = -1;

    public CandleDataSet(List<CandleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<CandleEntry> copy() {
        ArrayList<CandleEntry> yVals = new ArrayList<CandleEntry>();
        int i = 0;
        while (i < this.mYVals.size()) {
            yVals.add(((CandleEntry)this.mYVals.get(i)).copy());
            ++i;
        }
        CandleDataSet copied = new CandleDataSet((List<CandleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mShadowWidth = this.mShadowWidth;
        copied.mBodySpace = this.mBodySpace;
        copied.mHighLightColor = this.mHighLightColor;
        copied.mIncreasingPaintStyle = this.mIncreasingPaintStyle;
        copied.mDecreasingPaintStyle = this.mDecreasingPaintStyle;
        copied.mShadowColor = this.mShadowColor;
        return copied;
    }

    @Override
    protected void calcMinMax() {
        if (this.mYVals.size() == 0) {
            return;
        }
        List entries = this.mYVals;
        this.mYMin = ((CandleEntry)entries.get(0)).getLow();
        this.mYMax = ((CandleEntry)entries.get(0)).getHigh();
        int i = 0;
        while (i < entries.size()) {
            CandleEntry e = (CandleEntry)entries.get(i);
            if (e.getLow() < this.mYMin) {
                this.mYMin = e.getLow();
            }
            if (e.getHigh() > this.mYMax) {
                this.mYMax = e.getHigh();
            }
            ++i;
        }
    }

    public void setBodySpace(float space) {
        if (space < 0.0f) {
            space = 0.0f;
        }
        if (space > 0.45f) {
            space = 0.45f;
        }
        this.mBodySpace = space;
    }

    public float getBodySpace() {
        return this.mBodySpace;
    }

    public void setShadowWidth(float width) {
        this.mShadowWidth = Utils.convertDpToPixel(width);
    }

    public float getShadowWidth() {
        return this.mShadowWidth;
    }

    public void setDecreasingColor(int color) {
        this.mDecreasingColor = color;
    }

    public int getDecreasingColor() {
        return this.mDecreasingColor;
    }

    public void setIncreasingColor(int color) {
        this.mIncreasingColor = color;
    }

    public int getIncreasingColor() {
        return this.mIncreasingColor;
    }

    public Paint.Style getDecreasingPaintStyle() {
        return this.mDecreasingPaintStyle;
    }

    public void setDecreasingPaintStyle(Paint.Style decreasingPaintStyle) {
        this.mDecreasingPaintStyle = decreasingPaintStyle;
    }

    public Paint.Style getIncreasingPaintStyle() {
        return this.mIncreasingPaintStyle;
    }

    public void setIncreasingPaintStyle(Paint.Style paintStyle) {
        this.mIncreasingPaintStyle = paintStyle;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
    }
}

