/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.SelInfo;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class PieRadarChartTouchListener
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final int NONE = 0;
    private static final int ROTATE = 1;
    private PointF mTouchStartPoint = new PointF();
    private PieRadarChartBase<?> mChart;
    private float mStartAngle = 0.0f;
    private int mTouchMode = 0;
    private GestureDetector mGestureDetector;
    private ArrayList<AngularVelocitySample> _velocitySamples = new ArrayList();
    private long mDecelerationLastTime = 0L;
    private float mDecelerationAngularVelocity = 0.0f;
    private Highlight mLastHighlight = null;

    public PieRadarChartTouchListener(PieRadarChartBase<?> ctx) {
        this.mChart = ctx;
        this.mGestureDetector = new GestureDetector(ctx.getContext(), (GestureDetector.OnGestureListener)this);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (this.mChart.isRotationEnabled()) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.stopDeceleration();
                    this.resetVelocity();
                    if (this.mChart.isDragDecelerationEnabled()) {
                        this.sampleVelocity(x, y);
                    }
                    this.setGestureStartAngle(x, y);
                    this.mTouchStartPoint.x = x;
                    this.mTouchStartPoint.y = y;
                    break;
                }
                case 2: {
                    if (this.mChart.isDragDecelerationEnabled()) {
                        this.sampleVelocity(x, y);
                    }
                    if (this.mTouchMode == 0 && PieRadarChartTouchListener.distance(x, this.mTouchStartPoint.x, y, this.mTouchStartPoint.y) > Utils.convertDpToPixel(8.0f)) {
                        this.mTouchMode = 1;
                        this.mChart.disableScroll();
                        break;
                    }
                    if (this.mTouchMode != 1) break;
                    this.updateGestureRotation(x, y);
                    this.mChart.invalidate();
                    break;
                }
                case 1: {
                    if (this.mChart.isDragDecelerationEnabled()) {
                        this.stopDeceleration();
                        this.sampleVelocity(x, y);
                        this.mDecelerationAngularVelocity = this.calculateVelocity();
                        if (this.mDecelerationAngularVelocity != 0.0f) {
                            this.mDecelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                            Utils.postInvalidateOnAnimation(this.mChart);
                        }
                    }
                    this.mChart.enableScroll();
                    this.mTouchMode = 0;
                }
            }
        }
        return true;
    }

    public void onLongPress(MotionEvent me) {
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartLongPressed(me);
        }
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        float distance;
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartSingleTapped(e);
        }
        if ((distance = this.mChart.distanceToCenter(e.getX(), e.getY())) > this.mChart.getRadius()) {
            this.mChart.highlightValues(null);
            this.mLastHighlight = null;
        } else {
            int index;
            float angle = this.mChart.getAngleForPoint(e.getX(), e.getY());
            if (this.mChart instanceof PieChart) {
                angle /= this.mChart.getAnimator().getPhaseY();
            }
            if ((index = this.mChart.getIndexForAngle(angle)) < 0) {
                this.mChart.highlightValues(null);
                this.mLastHighlight = null;
            } else {
                Highlight h;
                List<SelInfo> valsAtIndex = this.mChart.getYValsAtIndex(index);
                int dataSetIndex = 0;
                if (this.mChart instanceof RadarChart) {
                    dataSetIndex = Utils.getClosestDataSetIndex(valsAtIndex, distance / ((RadarChart)this.mChart).getFactor(), null);
                }
                if ((h = new Highlight(index, dataSetIndex)).equalTo(this.mLastHighlight)) {
                    this.mChart.highlightTouch(null);
                    this.mLastHighlight = null;
                } else {
                    this.mChart.highlightTouch(h);
                    this.mLastHighlight = h;
                }
            }
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        OnChartGestureListener l = this.mChart.getOnChartGestureListener();
        if (l != null) {
            l.onChartDoubleTapped(e);
        }
        return super.onDoubleTap(e);
    }

    private void resetVelocity() {
        this._velocitySamples.clear();
    }

    private void sampleVelocity(float touchLocationX, float touchLocationY) {
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this._velocitySamples.add(new AngularVelocitySample(currentTime, this.mChart.getAngleForPoint(touchLocationX, touchLocationY)));
        int i = 0;
        int count = this._velocitySamples.size();
        while (i < count - 2) {
            if (currentTime - this._velocitySamples.get((int)i).time <= 1000L) break;
            this._velocitySamples.remove(0);
            --i;
            --count;
            ++i;
        }
    }

    private float calculateVelocity() {
        boolean clockwise;
        if (this._velocitySamples.isEmpty()) {
            return 0.0f;
        }
        AngularVelocitySample firstSample = this._velocitySamples.get(0);
        AngularVelocitySample lastSample = this._velocitySamples.get(this._velocitySamples.size() - 1);
        AngularVelocitySample beforeLastSample = firstSample;
        int i = this._velocitySamples.size() - 1;
        while (i >= 0) {
            beforeLastSample = this._velocitySamples.get(i);
            if (beforeLastSample.angle != lastSample.angle) break;
            --i;
        }
        float timeDelta = (float)(lastSample.time - firstSample.time) / 1000.0f;
        if (timeDelta == 0.0f) {
            timeDelta = 0.1f;
        }
        boolean bl = clockwise = lastSample.angle >= beforeLastSample.angle;
        if ((double)Math.abs(lastSample.angle - beforeLastSample.angle) > 270.0) {
            boolean bl2 = clockwise = !clockwise;
        }
        if ((double)(lastSample.angle - firstSample.angle) > 180.0) {
            firstSample.angle = (float)((double)firstSample.angle + 360.0);
        } else if ((double)(firstSample.angle - lastSample.angle) > 180.0) {
            lastSample.angle = (float)((double)lastSample.angle + 360.0);
        }
        float velocity = Math.abs((lastSample.angle - firstSample.angle) / timeDelta);
        if (!clockwise) {
            velocity = -velocity;
        }
        return velocity;
    }

    public void setGestureStartAngle(float x, float y) {
        this.mStartAngle = this.mChart.getAngleForPoint(x, y) - this.mChart.getRawRotationAngle();
    }

    public void updateGestureRotation(float x, float y) {
        this.mChart.setRotationAngle(this.mChart.getAngleForPoint(x, y) - this.mStartAngle);
    }

    private static float distance(float eventX, float startX, float eventY, float startY) {
        float dx = eventX - startX;
        float dy = eventY - startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public void stopDeceleration() {
        this.mDecelerationAngularVelocity = 0.0f;
    }

    public void computeScroll() {
        if (this.mDecelerationAngularVelocity == 0.0f) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDecelerationAngularVelocity *= this.mChart.getDragDecelerationFrictionCoef();
        float timeInterval = (float)(currentTime - this.mDecelerationLastTime) / 1000.0f;
        this.mChart.setRotationAngle(this.mChart.getRotationAngle() + this.mDecelerationAngularVelocity * timeInterval);
        this.mDecelerationLastTime = currentTime;
        if ((double)Math.abs(this.mDecelerationAngularVelocity) >= 0.001) {
            Utils.postInvalidateOnAnimation(this.mChart);
        } else {
            this.stopDeceleration();
        }
    }

    private class AngularVelocitySample {
        public long time;
        public float angle;

        public AngularVelocitySample(long time, float angle) {
            this.time = time;
            this.angle = angle;
        }
    }
}

