/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.ScatterBuffer;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.data.ScatterDataSet;
import com.github.mikephil.charting.interfaces.ScatterDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends DataRenderer {
    protected ScatterDataProvider mChart;
    protected ScatterBuffer[] mScatterBuffers;

    public ScatterChartRenderer(ScatterDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mRenderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
    }

    @Override
    public void initBuffers() {
        ScatterData scatterData = this.mChart.getScatterData();
        this.mScatterBuffers = new ScatterBuffer[scatterData.getDataSetCount()];
        int i = 0;
        while (i < this.mScatterBuffers.length) {
            ScatterDataSet set = (ScatterDataSet)scatterData.getDataSetByIndex(i);
            this.mScatterBuffers[i] = new ScatterBuffer(set.getEntryCount() * 2);
            ++i;
        }
    }

    @Override
    public void drawData(Canvas c) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (ScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, ScatterDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List<Entry> entries = dataSet.getYVals();
        float shapeHalf = dataSet.getScatterShapeSize() / 2.0f;
        ScatterChart.ScatterShape shape = dataSet.getScatterShape();
        ScatterBuffer buffer = this.mScatterBuffers[this.mChart.getScatterData().getIndexOfDataSet(dataSet)];
        buffer.setPhases(phaseX, phaseY);
        buffer.feed(entries);
        trans.pointValuesToPixel(buffer.buffer);
        block0 : switch (shape) {
            case SQUARE: {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                int i = 0;
                while (i < buffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[i])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) && this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) {
                        this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                        c.drawRect(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                    }
                    i += 2;
                }
                break;
            }
            case CIRCLE: {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                int i = 0;
                while (i < buffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[i])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) && this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) {
                        this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                        c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHalf, this.mRenderPaint);
                    }
                    i += 2;
                }
                break;
            }
            case TRIANGLE: {
                this.mRenderPaint.setStyle(Paint.Style.FILL);
                Path tri = new Path();
                int i = 0;
                while (i < buffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[i])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) && this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) {
                        this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                        tri.moveTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf);
                        tri.lineTo(buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf);
                        tri.lineTo(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] + shapeHalf);
                        tri.close();
                        c.drawPath(tri, this.mRenderPaint);
                        tri.reset();
                    }
                    i += 2;
                }
                break;
            }
            case CROSS: {
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                int i = 0;
                while (i < buffer.size()) {
                    if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[i])) break block0;
                    if (this.mViewPortHandler.isInBoundsLeft(buffer.buffer[i]) && this.mViewPortHandler.isInBoundsY(buffer.buffer[i + 1])) {
                        this.mRenderPaint.setColor(dataSet.getColor(i / 2));
                        c.drawLine(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1], buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1], this.mRenderPaint);
                        c.drawLine(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf, buffer.buffer[i], buffer.buffer[i + 1] + shapeHalf, this.mRenderPaint);
                    }
                    i += 2;
                }
                break;
            }
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getScatterData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List dataSets = this.mChart.getScatterData().getDataSets();
            int i = 0;
            while (i < this.mChart.getScatterData().getDataSetCount()) {
                ScatterDataSet dataSet = (ScatterDataSet)dataSets.get(i);
                if (dataSet.isDrawValuesEnabled()) {
                    this.applyValueTextStyle(dataSet);
                    List entries = dataSet.getYVals();
                    float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesScatter(entries, this.mAnimator.getPhaseY());
                    float shapeSize = dataSet.getScatterShapeSize();
                    int j = 0;
                    while ((float)j < (float)positions.length * this.mAnimator.getPhaseX()) {
                        if (!this.mViewPortHandler.isInBoundsRight(positions[j])) break;
                        if (this.mViewPortHandler.isInBoundsLeft(positions[j]) && this.mViewPortHandler.isInBoundsY(positions[j + 1])) {
                            float val = ((Entry)entries.get(j / 2)).getVal();
                            c.drawText(dataSet.getValueFormatter().getFormattedValue(val), positions[j], positions[j + 1] - shapeSize, this.mValuePaint);
                        }
                        j += 2;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        int i = 0;
        while (i < indices.length) {
            ScatterDataSet set = (ScatterDataSet)this.mChart.getScatterData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set != null) {
                this.mHighlightPaint.setColor(set.getHighLightColor());
                int xIndex = indices[i].getXIndex();
                if (!((float)xIndex > this.mChart.getXChartMax() * this.mAnimator.getPhaseX())) {
                    float y = set.getYValForXIndex(xIndex) * this.mAnimator.getPhaseY();
                    float[] pts = new float[]{xIndex, this.mChart.getYChartMax(), xIndex, this.mChart.getYChartMin(), 0.0f, y, this.mChart.getXChartMax(), y};
                    this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
                    c.drawLines(pts, this.mHighlightPaint);
                }
            }
            ++i;
        }
    }
}

