/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class XAxisRenderer
extends AxisRenderer {
    protected XAxis mXAxis;

    public XAxisRenderer(ViewPortHandler viewPortHandler, XAxis xAxis, Transformer trans) {
        super(viewPortHandler, trans);
        this.mXAxis = xAxis;
        this.mAxisLabelPaint.setColor(-16777216);
        this.mAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mAxisLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
    }

    public void computeAxis(float xValAverageLength, List<String> xValues) {
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        StringBuffer a = new StringBuffer();
        int max = Math.round(xValAverageLength + (float)this.mXAxis.getSpaceBetweenLabels());
        int i = 0;
        while (i < max) {
            a.append("h");
            ++i;
        }
        this.mXAxis.mLabelWidth = Utils.calcTextWidth(this.mAxisLabelPaint, a.toString());
        this.mXAxis.mLabelHeight = Utils.calcTextHeight(this.mAxisLabelPaint, "Q");
        this.mXAxis.setValues(xValues);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mXAxis.isEnabled() || !this.mXAxis.isDrawLabelsEnabled()) {
            return;
        }
        float yoffset = Utils.convertDpToPixel(4.0f);
        this.mAxisLabelPaint.setTypeface(this.mXAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mXAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mXAxis.getTextColor());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() - yoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
            this.drawLabels(c, this.mViewPortHandler.contentBottom() + (float)this.mXAxis.mLabelHeight + yoffset * 1.5f);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE) {
            this.drawLabels(c, this.mViewPortHandler.contentBottom() - yoffset);
        } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE) {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() + yoffset + (float)this.mXAxis.mLabelHeight);
        } else {
            this.drawLabels(c, this.mViewPortHandler.offsetTop() - yoffset);
            this.drawLabels(c, this.mViewPortHandler.contentBottom() + (float)this.mXAxis.mLabelHeight + yoffset * 1.6f);
        }
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mXAxis.isDrawAxisLineEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mXAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mXAxis.getAxisLineWidth());
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP || this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mAxisLinePaint);
        }
        if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    protected void drawLabels(Canvas c, float pos) {
        float[] position = new float[]{0.0f, 0.0f};
        int i = this.mMinX;
        while (i <= this.mMaxX) {
            position[0] = i;
            this.mTrans.pointValuesToPixel(position);
            if (this.mViewPortHandler.isInBoundsX(position[0])) {
                String label = this.mXAxis.getValues().get(i);
                if (this.mXAxis.isAvoidFirstLastClippingEnabled()) {
                    float width;
                    if (i == this.mXAxis.getValues().size() - 1 && this.mXAxis.getValues().size() > 1) {
                        width = Utils.calcTextWidth(this.mAxisLabelPaint, label);
                        if (width > this.mViewPortHandler.offsetRight() * 2.0f && position[0] + width > this.mViewPortHandler.getChartWidth()) {
                            position[0] = position[0] - width / 2.0f;
                        }
                    } else if (i == 0) {
                        width = Utils.calcTextWidth(this.mAxisLabelPaint, label);
                        position[0] = position[0] + width / 2.0f;
                    }
                }
                c.drawText(label, position[0], pos, this.mAxisLabelPaint);
            }
            i += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mXAxis.isDrawGridLinesEnabled() || !this.mXAxis.isEnabled()) {
            return;
        }
        float[] position = new float[]{0.0f, 0.0f};
        this.mGridPaint.setColor(this.mXAxis.getGridColor());
        this.mGridPaint.setStrokeWidth(this.mXAxis.getGridLineWidth());
        this.mGridPaint.setPathEffect((PathEffect)this.mXAxis.getGridDashPathEffect());
        int i = this.mMinX;
        while (i <= this.mMaxX) {
            position[0] = i;
            this.mTrans.pointValuesToPixel(position);
            if (position[0] >= this.mViewPortHandler.offsetLeft() && position[0] <= this.mViewPortHandler.getChartWidth()) {
                c.drawLine(position[0], this.mViewPortHandler.offsetTop(), position[0], this.mViewPortHandler.contentBottom(), this.mGridPaint);
            }
            i += this.mXAxis.mAxisLabelModulus;
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mXAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = new float[4];
        Path limitLinePath = new Path();
        int i = 0;
        while (i < limitLines.size()) {
            LimitLine l = limitLines.get(i);
            pts[0] = l.getLimit();
            pts[2] = l.getLimit();
            this.mTrans.pointValuesToPixel(pts);
            pts[1] = this.mViewPortHandler.contentTop();
            pts[3] = this.mViewPortHandler.contentBottom();
            limitLinePath.moveTo(pts[0], pts[1]);
            limitLinePath.lineTo(pts[2], pts[3]);
            this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            c.drawPath(limitLinePath, this.mLimitLinePaint);
            limitLinePath.reset();
            String label = l.getLabel();
            if (label != null && !label.equals("")) {
                float xOffset = l.getLineWidth();
                float add = Utils.convertDpToPixel(4.0f);
                this.mLimitLinePaint.setStyle(l.getTextStyle());
                this.mLimitLinePaint.setPathEffect(null);
                this.mLimitLinePaint.setColor(l.getTextColor());
                this.mLimitLinePaint.setStrokeWidth(0.5f);
                this.mLimitLinePaint.setTextSize(l.getTextSize());
                float yOffset = (float)Utils.calcTextHeight(this.mLimitLinePaint, label) + add / 2.0f;
                if (l.getLabelPosition() == LimitLine.LimitLabelPosition.POS_RIGHT) {
                    c.drawText(label, pts[0] + xOffset, this.mViewPortHandler.contentBottom() - add, this.mLimitLinePaint);
                } else {
                    c.drawText(label, pts[0] + xOffset, this.mViewPortHandler.contentTop() + yOffset, this.mLimitLinePaint);
                }
            }
            ++i;
        }
    }
}

