/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import com.github.mikephil.charting.utils.ValueFormatter;
import java.text.DecimalFormat;

public class LargeValueFormatter
implements ValueFormatter {
    private static final String[] SUFFIX = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private DecimalFormat mFormat = new DecimalFormat("###E0");
    private String mText = "";

    public LargeValueFormatter() {
    }

    public LargeValueFormatter(String appendix) {
        this();
        this.mText = appendix;
    }

    @Override
    public String getFormattedValue(float value) {
        return String.valueOf(this.makePretty(value)) + this.mText;
    }

    private String makePretty(double number) {
        String r = this.mFormat.format(number);
        r = r.replaceAll("E[0-9]", SUFFIX[Character.getNumericValue(r.charAt(r.length() - 1)) / 3]);
        while (r.length() > 4 || r.matches("[0-9]+\\.[a-z]")) {
            r = String.valueOf(r.substring(0, r.length() - 2)) + r.substring(r.length() - 1);
        }
        return r;
    }
}

