/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.utils.PointD;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class Transformer {
    protected Matrix mMatrixValueToPx = new Matrix();
    protected Matrix mMatrixOffset = new Matrix();
    protected ViewPortHandler mViewPortHandler;

    public Transformer(ViewPortHandler viewPortHandler) {
        this.mViewPortHandler = viewPortHandler;
    }

    public void prepareMatrixValuePx(float xChartMin, float deltaX, float deltaY, float yChartMin) {
        float scaleX = this.mViewPortHandler.contentWidth() / deltaX;
        float scaleY = this.mViewPortHandler.contentHeight() / deltaY;
        this.mMatrixValueToPx.reset();
        this.mMatrixValueToPx.postTranslate(-xChartMin, -yChartMin);
        this.mMatrixValueToPx.postScale(scaleX, -scaleY);
    }

    public void prepareMatrixOffset(boolean inverted) {
        this.mMatrixOffset.reset();
        if (!inverted) {
            this.mMatrixOffset.postTranslate(this.mViewPortHandler.offsetLeft(), this.mViewPortHandler.getChartHeight() - this.mViewPortHandler.offsetBottom());
        } else {
            this.mMatrixOffset.setTranslate(this.mViewPortHandler.offsetLeft(), -this.mViewPortHandler.offsetTop());
            this.mMatrixOffset.postScale(1.0f, -1.0f);
        }
    }

    public float[] generateTransformedValuesScatter(List<? extends Entry> entries, float phaseY) {
        float[] valuePoints = new float[entries.size() * 2];
        int j = 0;
        while (j < valuePoints.length) {
            Entry e = entries.get(j / 2);
            if (e != null) {
                valuePoints[j] = e.getXIndex();
                valuePoints[j + 1] = e.getVal() * phaseY;
            }
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public float[] generateTransformedValuesBubble(List<? extends Entry> entries, float phaseX, float phaseY, int from, int to) {
        int count = (int)Math.ceil(to - from) * 2;
        float[] valuePoints = new float[count];
        int j = 0;
        while (j < count) {
            Entry e = entries.get(j / 2 + from);
            if (e != null) {
                valuePoints[j] = (float)(e.getXIndex() - from) * phaseX + (float)from;
                valuePoints[j + 1] = e.getVal() * phaseY;
            }
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public float[] generateTransformedValuesLine(List<? extends Entry> entries, float phaseX, float phaseY, int from, int to) {
        int count = (int)Math.ceil((float)(to - from) * phaseX) * 2;
        float[] valuePoints = new float[count];
        int j = 0;
        while (j < count) {
            Entry e = entries.get(j / 2 + from);
            if (e != null) {
                valuePoints[j] = e.getXIndex();
                valuePoints[j + 1] = e.getVal() * phaseY;
            }
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public float[] generateTransformedValuesCandle(List<CandleEntry> entries, float phaseX, float phaseY, int from, int to) {
        int count = (int)Math.ceil((float)(to - from) * phaseX) * 2;
        float[] valuePoints = new float[count];
        int j = 0;
        while (j < count) {
            CandleEntry e = entries.get(j / 2 + from);
            if (e != null) {
                valuePoints[j] = e.getXIndex();
                valuePoints[j + 1] = e.getHigh() * phaseY;
            }
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public float[] generateTransformedValuesBarChart(List<? extends Entry> entries, int dataSet, BarData bd, float phaseY) {
        float[] valuePoints = new float[entries.size() * 2];
        int setCount = bd.getDataSetCount();
        float space = bd.getGroupSpace();
        int j = 0;
        while (j < valuePoints.length) {
            Entry e = entries.get(j / 2);
            float x = (float)(e.getXIndex() + j / 2 * (setCount - 1) + dataSet) + space * (float)(j / 2) + space / 2.0f;
            float y = e.getVal();
            valuePoints[j] = x;
            valuePoints[j + 1] = y * phaseY;
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public float[] generateTransformedValuesHorizontalBarChart(List<? extends Entry> entries, int dataSet, BarData bd, float phaseY) {
        float[] valuePoints = new float[entries.size() * 2];
        int setCount = bd.getDataSetCount();
        float space = bd.getGroupSpace();
        int j = 0;
        while (j < valuePoints.length) {
            Entry e = entries.get(j / 2);
            float x = (float)(e.getXIndex() + j / 2 * (setCount - 1) + dataSet) + space * (float)(j / 2) + space / 2.0f;
            float y = e.getVal();
            valuePoints[j] = y * phaseY;
            valuePoints[j + 1] = x;
            j += 2;
        }
        this.pointValuesToPixel(valuePoints);
        return valuePoints;
    }

    public void pathValueToPixel(Path path) {
        path.transform(this.mMatrixValueToPx);
        path.transform(this.mViewPortHandler.getMatrixTouch());
        path.transform(this.mMatrixOffset);
    }

    public void pathValuesToPixel(List<Path> paths) {
        int i = 0;
        while (i < paths.size()) {
            this.pathValueToPixel(paths.get(i));
            ++i;
        }
    }

    public void pointValuesToPixel(float[] pts) {
        this.mMatrixValueToPx.mapPoints(pts);
        this.mViewPortHandler.getMatrixTouch().mapPoints(pts);
        this.mMatrixOffset.mapPoints(pts);
    }

    public void rectValueToPixel(RectF r) {
        this.mMatrixValueToPx.mapRect(r);
        this.mViewPortHandler.getMatrixTouch().mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    public void rectValueToPixel(RectF r, float phaseY) {
        if (r.top > 0.0f) {
            r.top *= phaseY;
        } else {
            r.bottom *= phaseY;
        }
        this.mMatrixValueToPx.mapRect(r);
        this.mViewPortHandler.getMatrixTouch().mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    public void rectValueToPixelHorizontal(RectF r, float phaseY) {
        if (r.left > 0.0f) {
            r.left *= phaseY;
        } else {
            r.right *= phaseY;
        }
        this.mMatrixValueToPx.mapRect(r);
        this.mViewPortHandler.getMatrixTouch().mapRect(r);
        this.mMatrixOffset.mapRect(r);
    }

    public void rectValuesToPixel(List<RectF> rects) {
        int i = 0;
        while (i < rects.size()) {
            this.rectValueToPixel(rects.get(i));
            ++i;
        }
    }

    public void pixelsToValue(float[] pixels) {
        Matrix tmp = new Matrix();
        this.mMatrixOffset.invert(tmp);
        tmp.mapPoints(pixels);
        this.mViewPortHandler.getMatrixTouch().invert(tmp);
        tmp.mapPoints(pixels);
        this.mMatrixValueToPx.invert(tmp);
        tmp.mapPoints(pixels);
    }

    public PointD getValuesByTouchPoint(float x, float y) {
        float[] pts = new float[]{x, y};
        this.pixelsToValue(pts);
        double xTouchVal = pts[0];
        double yTouchVal = pts[1];
        return new PointD(xTouchVal, yTouchVal);
    }

    public Matrix getValueMatrix() {
        return this.mMatrixValueToPx;
    }

    public Matrix getOffsetMatrix() {
        return this.mMatrixOffset;
    }
}

