/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.utils.SelInfo;
import java.text.DecimalFormat;
import java.util.List;

public abstract class Utils {
    private static DisplayMetrics mMetrics;
    private static int mMinimumFlingVelocity;
    private static int mMaximumFlingVelocity;
    private static final int[] POW_10;

    static {
        mMinimumFlingVelocity = 50;
        mMaximumFlingVelocity = 8000;
        POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    public static void init(Context context) {
        if (context == null) {
            mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
            mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
        } else {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
            mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
            mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }
        Resources res = context.getResources();
        mMetrics = res.getDisplayMetrics();
    }

    @Deprecated
    public static void init(Resources res) {
        mMetrics = res.getDisplayMetrics();
        mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
        mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
    }

    public static String formatDecimal(double number, int digits) {
        StringBuffer a = new StringBuffer();
        int i = 0;
        while (i < digits) {
            if (i == 0) {
                a.append(".");
            }
            a.append("0");
            ++i;
        }
        DecimalFormat nf = new DecimalFormat("###,###,###,##0" + a.toString());
        String formatted = nf.format(number);
        return formatted;
    }

    public static float convertDpToPixel(float dp) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertDpToPixel(...). Otherwise conversion does not take place.");
            return dp;
        }
        DisplayMetrics metrics = mMetrics;
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px) {
        if (mMetrics == null) {
            Log.e((String)"MPChartLib-Utils", (String)"Utils NOT INITIALIZED. You need to call Utils.init(...) at least once before calling Utils.convertPixelsToDp(...). Otherwise conversion does not take place.");
            return px;
        }
        DisplayMetrics metrics = mMetrics;
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static int calcTextWidth(Paint paint, String demoText) {
        return (int)paint.measureText(demoText);
    }

    public static int calcTextHeight(Paint paint, String demoText) {
        Rect r = new Rect();
        paint.getTextBounds(demoText, 0, demoText.length(), r);
        return r.height();
    }

    public static int getLegendFormatDigits(float step, int bonus) {
        if ((double)step < 9.9E-6) {
            return 6 + bonus;
        }
        if ((double)step < 9.9E-5) {
            return 5 + bonus;
        }
        if ((double)step < 9.9E-4) {
            return 4 + bonus;
        }
        if ((double)step < 0.0099) {
            return 3 + bonus;
        }
        if ((double)step < 0.099) {
            return 2 + bonus;
        }
        if ((double)step < 0.99) {
            return 1 + bonus;
        }
        return 0 + bonus;
    }

    public static String formatNumber(float number, int digitCount, boolean separateThousands) {
        char[] out = new char[35];
        boolean neg = false;
        if (number == 0.0f) {
            return "0";
        }
        boolean zero = false;
        if (number < 1.0f && number > -1.0f) {
            zero = true;
        }
        if (number < 0.0f) {
            neg = true;
            number = -number;
        }
        if (digitCount > POW_10.length) {
            digitCount = POW_10.length - 1;
        }
        long lval = Math.round(number *= (float)POW_10[digitCount]);
        int ind = out.length - 1;
        int charCount = 0;
        boolean decimalPointAdded = false;
        while (lval != 0L || charCount < digitCount + 1) {
            int digit = (int)(lval % 10L);
            lval /= 10L;
            out[ind--] = (char)(digit + 48);
            if (++charCount == digitCount) {
                out[ind--] = 44;
                ++charCount;
                decimalPointAdded = true;
                continue;
            }
            if (!separateThousands || lval == 0L || charCount <= digitCount) continue;
            if (decimalPointAdded) {
                if ((charCount - digitCount) % 4 != 0) continue;
                out[ind--] = 46;
                ++charCount;
                continue;
            }
            if ((charCount - digitCount) % 4 != 3) continue;
            out[ind--] = 46;
            ++charCount;
        }
        if (zero) {
            out[ind--] = 48;
            ++charCount;
        }
        if (neg) {
            out[ind--] = 45;
            ++charCount;
        }
        int start = out.length - charCount;
        return String.valueOf(out, start, out.length - start);
    }

    public static float roundToNextSignificant(double number) {
        float d = (float)Math.ceil((float)Math.log10(number < 0.0 ? -number : number));
        int pw = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, pw);
        long shifted = Math.round(number * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public static int getDecimals(float number) {
        float i = Utils.roundToNextSignificant(number);
        return (int)Math.ceil(-Math.log10(i)) + 2;
    }

    public static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = integers.get(i);
            ++i;
        }
        return ret;
    }

    public static String[] convertStrings(List<String> strings) {
        String[] ret = new String[strings.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = strings.get(i);
            ++i;
        }
        return ret;
    }

    public static double nextUp(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d += 0.0) + (d >= 0.0 ? 1L : -1L));
    }

    public static int getClosestDataSetIndex(List<SelInfo> valsAtIndex, float val, YAxis.AxisDependency axis) {
        int index = -1;
        float distance = Float.MAX_VALUE;
        int i = 0;
        while (i < valsAtIndex.size()) {
            float cdistance;
            SelInfo sel = valsAtIndex.get(i);
            if ((axis == null || sel.dataSet.getAxisDependency() == axis) && (cdistance = Math.abs(sel.val - val)) < distance) {
                index = valsAtIndex.get((int)i).dataSetIndex;
                distance = cdistance;
            }
            ++i;
        }
        return index;
    }

    public static float getMinimumDistance(List<SelInfo> valsAtIndex, float val, YAxis.AxisDependency axis) {
        float distance = Float.MAX_VALUE;
        int i = 0;
        while (i < valsAtIndex.size()) {
            float cdistance;
            SelInfo sel = valsAtIndex.get(i);
            if (sel.dataSet.getAxisDependency() == axis && (cdistance = Math.abs(sel.val - val)) < distance) {
                distance = cdistance;
            }
            ++i;
        }
        return distance;
    }

    public static PointF getPosition(PointF center, float dist, float angle) {
        PointF p = new PointF((float)((double)center.x + (double)dist * Math.cos(Math.toRadians(angle))), (float)((double)center.y + (double)dist * Math.sin(Math.toRadians(angle))));
        return p;
    }

    public static void velocityTrackerPointerUpCleanUpIfNecessary(MotionEvent ev, VelocityTracker tracker) {
        tracker.computeCurrentVelocity(1000, (float)mMaximumFlingVelocity);
        int upIndex = ev.getActionIndex();
        int id1 = ev.getPointerId(upIndex);
        float x1 = tracker.getXVelocity(id1);
        float y1 = tracker.getYVelocity(id1);
        int i = 0;
        int count = ev.getPointerCount();
        while (i < count) {
            float y;
            int id2;
            float x;
            float dot;
            if (i != upIndex && (dot = (x = x1 * tracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * tracker.getYVelocity(id2))) < 0.0f) {
                tracker.clear();
                break;
            }
            ++i;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void postInvalidateOnAnimation(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postInvalidateOnAnimation();
        } else {
            view.postInvalidateDelayed(10L);
        }
    }

    public static int getMinimumFlingVelocity() {
        return mMinimumFlingVelocity;
    }

    public static int getMaximumFlingVelocity() {
        return mMaximumFlingVelocity;
    }

    public static float getNormalizedAngle(float angle) {
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle % 360.0f;
    }
}

