// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).Format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
Date.prototype.Format = function(fmt) { //author: meizz
	var o = {
		"M+": this.getMonth() + 1, //月份
		"d+": this.getDate(), //日
		"h+": this.getHours(), //小时
		"m+": this.getMinutes(), //分
		"s+": this.getSeconds(), //秒
		"q+": Math.floor((this.getMonth() + 3) / 3), //季度
		"S": this.getMilliseconds() //毫秒
	};
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
		if (new RegExp("(" + k + ")").test(fmt))
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k])
				.length)));
	return fmt;
};
export default {
	// 时间格式化 2020-06-04T14:57:01 =>2020-06-04 14:57:01
	dateNormal: function(time) {
		if(!time || time.length == 0){
			return time
		}
		if(time.indexOf('T') == -1){
			return time
		}
		var d = time ? new Date(time) : new Date();
		var year = d.getFullYear();
		var month = d.getMonth() + 1;
		var day = d.getDate();
		var hours = d.getHours();
		var min = d.getMinutes();
		var seconds = d.getSeconds();
 
		if (month < 10) month = '0' + month;
		if (day < 10) day = '0' + day;
		if (hours < 10) hours = '0' + hours;
		if (min < 10) min = '0' + min;
		if (seconds < 10) seconds = '0' + seconds;
		return (year + '-' + month + '-' + day + ' ' + hours + ':' + min + ':' + seconds);

	},
	


	dateFormat: function(timeSpan, fmt) {
		if (/^\d+$/.test(timeSpan)) {
			// 是纯数字
			timeSpan = Number(timeSpan);
			return new Date(timeSpan).Format(fmt);
		} else {
			//timeSpan是待转换时间字符串，格式：'2018-9-12 9:11:23'
			let dateTmp = timeSpan.replace(/-/g, '/') //为了兼容IOS，需先将字符串转换为'2018/9/11 9:11:23'
			timeSpan = Date.parse(dateTmp) //返回时间戳
			return new Date(timeSpan).Format(fmt);

		}
	},

	// 时间格式转时间戳
	timeStampFromDateStr: function(dateStr) {
		return new Date(dateStr.replace(/-/g, '/')).getTime();
	},


	// 倒计时秒数转化为显示的分钟
	getEndTimeFormat: function(timeSpan, type = 0) {
		timeSpan = Number(timeSpan);
		if (timeSpan <= 0)
			return "已结束";

		timeSpan = parseInt(timeSpan / 1000);
		var hours = parseInt(timeSpan / 3600);
		var hoursStr = hours.toString();
		var minutes = parseInt(timeSpan / 60) % 60;
		var minStr = minutes.toString();
		var second = timeSpan % 60;
		var secStr = second.toString();
		var timeStr = "";
		switch (type) {
			case 0:
				if (hoursStr > 0) {
					timeStr += hoursStr + '时';
				}
				timeStr += minStr + '分' + secStr + '秒';
				break;
			case 1:
				if (minStr > 0) {
					timeStr += minStr + '′';
				}
				timeStr += secStr + '″';
				break;
			case 2:
				const t2 = [hours, minutes, second].map(this.formatNumber).join(':')
				timeStr += t2;
			default:
				break;
		}
		return timeStr;
	},
	// 时间统一函数
	getChatTimeFormat: function(argument) {
		argument = Number(argument);
		var times = new Date(argument);
		var timeS = new Date(argument).Format('yyyy/MM/dd hh:mm:ss');
		var todayT = '';
		var yestodayT = '';
		var timeCha = new Date().getTime() - new Date(times).getTime() - 1000; //有一秒的误差;
		timeS = timeS.slice(-8);
		todayT = new Date().getHours() * 60 * 60 * 1000 + new Date().getMinutes() * 60 * 1000 + new Date()
			.getSeconds() *
			1000;
		yestodayT = todayT + 24 * 60 * 60 * 1000;
		if (timeCha > yestodayT) {
			return new Date(argument).Format('yyyy年MM月dd日 hh:mm:ss');
		}
		if (timeCha > todayT && timeCha < yestodayT) {
			return timeS.slice(0, 2) > 12 ? '昨天 下午' + (timeS.slice(0, 2) == 12 ? 12 : timeS.slice(0, 2) - 12) +
				timeS.slice(2,
					5) : '昨天 上午' + timeS.slice(0, 5);
		}
		if (timeCha < todayT) {
			return timeS.slice(0, 2) >= 12 ? '下午' + (timeS.slice(0, 2) == 12 ? 12 : timeS.slice(0, 2) - 12) + timeS
				.slice(2, 5) :
				'上午' + timeS.slice(0, 5);
		}

	},
	//将一个时间戳转换成提示性时间字符串，如刚刚，1秒前
	convertTimeToFormat: function(timeStamp) {
		timeStamp = Number(timeStamp);
		var time = (new Date().getTime() - timeStamp) / 1000;

		if (time <= 60 ) {

			return "刚刚";
		} else if (time > 60 && time<3600) {
			return Math.floor(time / 60) + "分钟前";
		} else if (time >= 3600 && time < 3600 * 24) {
			return Math.floor(time / 3600) + "小时前";
		} else if (time >= 3600 * 24 && time <= 3600 * 24 * 7) {
			return Math.floor(time / (3600 * 24)) + "天前";
		} else {
			return (new Date(timeStamp)).Format('yyyy.MM.dd');
		}
	},

	formatNumber: function(n) {
		const str = n.toString()
		return str[1] ? str : `0${str}`
	},




}
