const eeui = app.requireModule("eeui");

export default {
  // key可选值，不传默认返回用户所有数据
  getUserInfo(key) {
    var kUserInfo = eeui.getVariate("kUserInfo", "");
    // 没有用户数据
    if (kUserInfo == "") {
      // 读取缓存
      kUserInfo = eeui.getCaches("kUserInfo", {});
      eeui.setVariate("kUserInfo", kUserInfo);
    }
    var userObj = kUserInfo;
    var type = typeof kUserInfo;

    if (type == "string") {
      //JSON.parse  安卓格式要转换
      userObj = JSON.parse(kUserInfo);
    } else if (type == "object") {
      userObj = kUserInfo;
    }

    if (key != undefined && key != null) {
      return userObj[key];
    }
    return userObj;
  },
  setUserInfo(data) {
    var info = this.getUserInfo();
    info = Object.assign(info, data);
    eeui.setCaches("kUserInfo", info, 0);
    eeui.setVariate("kUserInfo", info);
  },

  isLogin() {
    let info = this.getUserInfo();
    if (info && info["token"]) {
      return true;
    } else {
      return false;
    }
  },
};
