import timeHelper from 'utils/timeHelper.js';
export default {
	match :function (str, keywords) {
	  str = String(str)
	  var ks = ''
	  if (Array.isArray(keywords)) {
	    ks = keywords.map(k => '\\d+' + k).join('|') + '|'
	  } else if (typeof keywords === 'string') {
	    ks = `\\d+${keywords}|`
	  }
	  var checker = new RegExp(`${ks}\\d+|\\D+`, 'g')
	  return str.match(checker).sort((a, b) => !isNaN(a * 1) && isNaN(b * 1) ? 1 : -1)
	},
	// 图片链接处理
	spliceImageLink: function(url) {
		if(url.substr(0,5).toLowerCase() == "http:" || url.substr(0,6).toLowerCase() == "https:"){
		    url = url;
		}else{
			if(url.substr(0,2).toLowerCase() == "//"){
				url = "https:" + url;
			}else {
				url = "https://" + url;
			}
		}
		return url;
	},
	// 处理字符串 （去掉空格 - ）
	formatStr(str){
		return str.replace(/\s*/g, "").replace(/[-]+/g, "")
	},
	isMobile(str) {
		
		if(str.length != 11){
			return false
		}
	    return /^[0-9]*$/.test(str);
	},
	//分转元 保留两位小数
	toFixed(number) {
		//number  保留小数数
		var times = Math.pow(10, 2);
		var roundNum = Math.round(number / 100 * times) / times;
		return roundNum.toFixed(2);
	},
	getEnvironment(){
		if(WXEnvironment.platform == 'iOS'){
			return  hl.getEnvironment()
		}
		return ''
	},
	getAJTProduct(){
		
		if(WXEnvironment.platform == 'iOS'){
			var env = hl.getEnvironment()
			if(env && env.length > 0){
				if(env == 'debug'){
					return 'http://hd.66law.cn/anjiantong/product.aspx'
	
				}else if(env == 'test'){
					return 'http://hd.66law.cn/anjiantong/product.aspx'
	
				}else{
					return 'https://hd.66law.cn/anjiantong/product.aspx'
				}
			}
			return 'https://hd.66law.cn/anjiantong/product.aspx'
			
		}
		return "https://hd.66law.cn/anjiantong/product.aspx";
	},
	getCasemanagementGateway(){
		if(WXEnvironment.platform == 'iOS'){
			var env = hl.getEnvironment()
			if(env && env.length > 0){
				if(env == 'debug'){
					return 'http://appweb.66law.cn/lawyer/#/pagesCasemanagement'
	
				}else if(env == 'test'){
					console.log('test')	 
					return 'https://test-app.66law.cn/lawyer/#/pagesCasemanagement'
	
				}else{
					return 'https://app.66law.cn/lawyer/#/pagesCasemanagement'
				}
			}
			return 'https://app.66law.cn/lawyer/#/pagesCasemanagement'
			
		}
		return "https://app.66law.cn/lawyer/#/pagesCasemanagement";

		// return 'http://10.0.6.2:5173/lawyer#/pagesCasemanagement'
	}
	
}