--书本缓存
create table if not exists book_info(
    book_id text not null,
    is_read int,
    book_info text,
    PRIMARY KEY(book_id)
)
go

--书本的章节缓存
create table if not exists chapter_info(
    book_id text not null,
    chapter_id text not null,
    chapter_info text,
    chapter_index INT,
    PRIMARY key(book_id,chapter_id)
)
go

--书架信息缓存
create table if not exists shelf_info(
    shelf_id text not null,
    reader_id text not null,
    shelf_name text,
    shelf_index text,
    book_limit int,
    PRIMARY KEY(shelf_id,reader_id)
)
go

--书架里面的书缓存
--update_time最新更新时间
--update_chapter最新章节信息
--is_update貌似没用
create table if not exists shelf_book_info(
    _id INTEGER PRIMARY KEY AUTOINCREMENT,
    shelf_id text,
    book_id text not null,
    book_info text,
    is_buy int,
    mode_time text,
    is_update int,
    update_time datetime DEFAULT 0,
    update_chapter text,
	last_read_chapter_id text,
    last_read_chapter_update_time long,
    is_notify int,
	last_read_time_loc datetime ,
	last_read_title text ,
	last_read_pageindex int DEFAULT 0 ,
	set_top_time datetime DEFAULT 0
)
go



--历史搜索
create table if not exists history_search(
    word text not null,
    modify_time datetime not null,
    primary key(word)
)
go

--历史阅读缓存
create table if not exists read_history(
    reader_id text,
    book_id text,
    book_info text,
	chapter_title text,
	chapter_id text,
    primary key(reader_id, book_id)
)
go

--书签(改)
create table if not exists book_mark(
    book_id text,
    chapter_id text,
	chapter_title text,
    page_index,
    update_time text,
    book_info text,
    is_barrage int,
    firstParagraph,
    primary key(book_id,chapter_id,page_index,is_barrage)
)
go

--消息缓存
create table if not exists messages(
	reader_id text,
    message_id text,
    message_type text,
    message_content text,
    from_reader_info text,
    sendtime text,
    status text,
    primary key(message_id)
)
go

--自动购买记录表
--is_tips表示是否有提示过：0：没有、1：有
create table if not exists auto_buy(
    reader_id text,
	book_id text,
	is_tips int,
    primary key(reader_id,book_id)
)
go



--分卷信息缓存
create table if not exists division(
	_id INTEGER PRIMARY KEY AUTOINCREMENT,
	book_id text,
	division_index int,
	division_id text,
	last_update_time text,
	max_chapter_index text,
	division_name text,
	description text
)
go
--章节目录信息缓存
create table if not exists catalog1(
	_id INTEGER PRIMARY KEY AUTOINCREMENT,
	book_id text ,
	chapter_id text UNIQUE,
	division_index int,
	division_id text,
	chapter_index int,
	chapter_title text,
	word_count int,
	tsukkomi_amount int DEFAULT 0,
	is_valid int DEFAULT 0,
	is_vip int DEFAULT 0,
	is_update int DEFAULT 0,
	unit_hlb int,
	auth_access int,
	is_download int DEFAULT 0
)
go
--阅读时长
create table if not exists readTimes(
	_id INTEGER PRIMARY KEY AUTOINCREMENT,
    book_id text,
    readTimes text,
    getTime date
)
go
--信息使用次数
CREATE TABLE if NOT EXISTS useNum(
_id INTEGER PRIMARY KEY AUTOINCREMENT,
    type text,
    usetime long
)
GO
--上报数据
create table if not exists eventDatas(
_id INTEGER PRIMARY KEY AUTOINCREMENT,
    eventName text,
    eventData text,
    md5 text,
    channelName text,
     readerId text
)
go
