ALTER TABLE "shelf_book_info" RENAME TO "shelf_book_info_temp";
go
create table if not exists shelf_book_info(
    _id INTEGER PRIMARY KEY AUTOINCREMENT,
    shelf_id text,
    book_id text not null,
    book_info text,
    is_buy int,
    mode_time text,
    is_update int,
    update_time datetime DEFAULT 0,
    update_chapter text,
	last_read_chapter_id text,
    last_read_chapter_update_time long,
    is_notify int,
	last_read_time_loc datetime ,
	last_read_title text ,
	last_read_pageindex int DEFAULT 0 ,
	set_top_time datetime DEFAULT 0
)
go
delete from shelf_book_info_temp where rowid  not in(select max(rowid) from shelf_book_info_temp group by book_id)
go

INSERT INTO "shelf_book_info" ("shelf_id", "book_id","book_info","is_buy",
"mode_time","is_update","update_time","update_chapter","last_read_chapter_id","last_read_chapter_update_time",
"is_notify","last_read_time_loc","last_read_title","last_read_pageindex","set_top_time")
SELECT "shelf_id", "book_id","book_info","is_buy",
       "mode_time","is_update","update_time","update_chapter","last_read_chapter_id","last_read_chapter_update_time",
       "is_notify","last_read_time_loc","last_read_title","last_read_pageindex","set_top_time"
        FROM "shelf_book_info_temp"
go
DROP TABLE shelf_book_info_temp
go