 /**
 * LBS drawRing 
 * Date: 2015-04-24
 * ==================================
 * opts.parent 插入到哪里 一个JS元素对象
 * opts.width 宽度 = 2* (半径+弧宽)  
 * opts.radius 半径
 * opts.arc 弧宽
 * opts.perent 百分比 
 * opts.color 弧渲染颜色 [底色,进度色]
 * opts.textColor 文字渲染颜色
 * opts.textSize 文字渲染大小
 * opts.animated 是否以动画的方式绘制 默认false
 * opts.after 绘制完成时执行函数
 * ==================================
 **/
var bodyWidth=window.screen.width;
var nowwidth = bodyWidth * 4 / 15;
function drawRing(opts) {
    var _opts = {
        parent: document.body,
        width: 1*nowwidth,
        radius:0.45*nowwidth,
        arc: 0.05*nowwidth,
        perent: 100,
		score: score,
		total: total,
		insertDate: insertDate,
		appealDealDate: appealDealDate,
        color: ['#ccc', '#042b61'],
        textColor: '#000',
        textSize: 0.14*nowwidth+'px',
        animated: false,
        after: function() {}
    }, k;
    for (k in opts) _opts[k] = opts[k];
    
	
    var parent = _opts.parent,
        width = _opts.width,
        radius = _opts.radius,
        arc = _opts.arc,
        perent = parseFloat(_opts.perent),
		total = parseFloat(_opts.total),
		score = parseFloat(_opts.score),
		dengji = _opts.dengji,
		showStr = _opts.showStr,
		insertDate = _opts.insertDate,
		appealDealDate = _opts.appealDealDate,
        color = _opts.color,
        textSize = _opts.textSize,
        textColor = _opts.textColor,
        c = document.createElement('canvas'),
        ctx = null,
        x = 0,
        animated = _opts.animated,
        after = _opts.after,
		title = _opts.title,
		studentReportShowType = _opts.studentReportShowType;

    parent.appendChild(c);
    ctx = c.getContext("2d");
    ctx.canvas.width = width;
    ctx.canvas.height = width;

    function clearFill() {
        ctx.clearRect(0, 0, width, width);
    }

    function fillBG() {
        ctx.beginPath();
        ctx.lineWidth = arc;
        ctx.strokeStyle = color[0];
        ctx.arc(width / 2, width / 2, radius, 0, 2 * Math.PI);
        ctx.stroke();
    }

    function fillArc(perent) {
        ctx.beginPath();
        ctx.lineWidth = arc;
        ctx.strokeStyle = color[1];
        ctx.arc(width / 2, width / 2, radius, -90 * Math.PI / 180, (perent * 3.6 - 90) * Math.PI / 180,true);
		ctx.stroke();
    }

    function fillText(showStr,total,insertDate,appealDealDate,title,studentReportShowType) {
        ctx.font = 'bold '+textSize + ' sans-serif';
        ctx.fillStyle = textColor;
        ctx.textBaseline = "middle";
        ctx.textAlign = 'center';
		
		var zongfenStr = title;

		if(insertDate==null){
			zongfenStr += "（未发布）";
			showStr = '--';
			total = '--';
		}else if(appealDealDate!=null){
			var insertDateTime = new Date(insertDate);
			var appealDealDateTime = new Date(appealDealDate+":00:00");
			if(insertDateTime.getTime()<appealDealDateTime.getTime()){
				zongfenStr += '（预发布）';
			}
		}
		ctx.fillText(zongfenStr,width / 2, width / 2 - (1.1*nowwidth)/2);

		if($.containChinese(showStr)){
			ctx.font = 0.3*nowwidth + 'px sans-serif';
			ctx.fillText(showStr, width / 2 +10, width / 2);
		}else{
			ctx.font = 0.4*nowwidth + 'px sans-serif';
			ctx.fillText(showStr, width / 2 , width / 2);
		}
		
        
		if(studentReportShowType==0){
			//如果类型是得分就是显示满分
			//如果是得分率或者等级不显示满分
			ctx.font = 'bold '+textSize + ' sans-serif';
			if((showStr+'').indexOf('.')==-1){
				ctx.fillText('满分：'+total+'分', width / 2, width / 2+(0.9*nowwidth)/2);
			}else{
				ctx.fillText('满分：'+total+'分', width / 2, width / 2+(0.8*nowwidth)/2);
			}
		}
    }

    function fill(showStr,total,perent,insertDate,appealDealDate,title,studentReportShowType) {
        fillBG();
        fillArc(perent);
        fillText(showStr,total,insertDate,appealDealDate,title,studentReportShowType);
    }

    if (!animated) return fill(score,total,100,insertDate,appealDealDate);

    fill(showStr,total,100,insertDate,appealDealDate,title,studentReportShowType);
    !function animate() {
		if(!score||!total){
			return after;
		}
		if (++x > score*100/total) return after && after();
        setTimeout(animate, 10);
        clearFill();
        fill(showStr,total,x,insertDate,appealDealDate,title,studentReportShowType);
    }();
}