var knowledgeFn = {
	leftTopJson: {
		rows: [{
			cols: [{
				text: '序号',
				rowspan: 2,
				style: {
					height: '61px',
					'line-height': '61px'
				}
			}]
		}]
	},
	rightTopJson: {
		rows: [{
			cols: [{
					text: '知识点',
					rowspan: 2
				}, {
					text: '满分',
					rowspan: 2
				},
				{
					text: '得分率(%)',
					colspan: 2
				}, {
					text: '差距(%)',
					rowspan: 2,
					order: {
						orderField: 'orderDiff',
						orderType: 'asc',
						active: true
					}
				}, {
					text: '详情',
					rowspan: 2
				}
			]
		}, {
			cols: ['学生本人', '对比对象']
		}]
	},
	rightBottomFieldArray: [{
			text: '@find:knowName',
			style: {
				'max-width': $(window).width() * 0.3 + 'px',
				'height': 'auto',
				'white-space': 'normal',
				'word-wrap': 'break-word',
				'word-break': 'break-all',
				'font-size': '10px',
				'line-height': '12px'
			}

		}, 'fullScore', 'scoreRate', 'contrast_scoreRate', 'difference',
		{
			text: '>',
			ext: {
				'qType': "@find:qType",
				'examPaperNum': "@find:pexamPaperNum",
				'questionNum': "@find:id",
				'questionName': "@find:questionName",
				'knowName': "@find:knowName",
				'class': 'questionDetail',
			},
		}
	],
	//隐藏整卷详情
	hideDetail: function() {
		$('.fixed-table td[knowName="整卷"]').removeClass('questionDetail')
			.find('div').html('');
	},
	//查询
	getData: function(changeTab) {
		delete vm.params_selected.username;
		delete vm.params_selected.password;
		delete vm.params_selected.AccessToken;
		delete vm.params_selected.requestSource;
		plus.nativeUI.showWaiting('数据加载中，请稍后...');
		var that = this;
		var url = $.getUrl()+"/" + vm.url;
		// console.log(url+"--开始查询数据 ..." + JSON.stringify(vm.params_selected));
		$.newAjax({
			url: url,
			timeout: 10000,
			async: true,
			data: vm.params_selected,
			success: function(data) {
				// console.log(JSON.stringify(data)); 
				if (changeTab) {
					vm.leftTopJson = that.leftTopJson;
					vm.rightTopJson = that.rightTopJson;
				}
				vm.leftBottomJson = $.fixed_table.getTableJson(data, ['num']);
				vm.rightBottomJson = $.fixed_table.getTableJson(data, that.rightBottomFieldArray);
				initTable(!changeTab);
				that.hideDetail();
				initEchart(data);
				that.initOrder();
				that.initJqueryFn();
				plus.nativeUI.closeWaiting();
			},
			error: function(xhr, textStatus, errorThrown) {
				console.log("错误信息:" + xhr.statusText);
				plus.nativeUI.closeWaiting();
			},
			beforeSend: function() {
				plus.nativeUI.showWaiting('数据加载中，请稍后...');
			},
			complete: function(xhr, textStatus) {
				if (textStatus == 'timeout') { //超时,textStatus还有success,error等值的情况
					xhr.abort();
					mui.toast('响应超时，请重试 ...');
				}
				plus.nativeUI.closeWaiting();
			}
		});
	},
	initOrder: function() {

	},
	initJqueryFn: function() {
		$('.questionDetail').on('tap', function() {
			var url = $.getUrl()+"/appIndex!getConfiguration.action";
			var that = $(this);
			$.newAjax({
				url: url,
				async: true,
				dataType:'json',
				success: function(data) {
			
					var qType = that.attr('qType');
					var examPaperNum = that.attr('examPaperNum');
					var questionNum = that.attr('questionNum');
					var questionName = that.attr('questionName');
					var id = 'JiaoXueZhenDuanQuestionDetail';
					var url = 'JiaoXueZhenDuanQuestionDetail.html';
					mui.openWindow({
						id: id,
						url: url,
						show: {
							aniShow: 'pop-in'
						},
						extras: { //extras里面的就是参数了
							examPaperNum: examPaperNum,
							configuration:data,
							questionNum: questionNum,
							questionName: questionName
						},
						waiting: {
							autoShow: true, //自动显示等待框，默认为true
						}
					});
					
				},
				error: function(XMLHttpRequest, statusText, errorThrown) {
				}
			});
			
			
			
		})
	}
};
