;
(function($, window, document, undefined) {
	
	var mylayer;
	
	//定义Layer的构造函数
	var Layer = function(ele, opt) {
		this.$element = ele,
		this.defaults = {
			title:'提示',
			titleStyle:'margin-top:0.2rem;background-color: #41A863; color:#fff;border-radius: 0.5rem;postion:fixed;',
			contenter: '',
			contentStyle:'overflow:auto; width: 100%; min-height: 200px;max-height:70%;border-radius: 0.5rem;',
			buttons:[]
		},
		this.options = $.extend({}, this.defaults, opt)
	};

	//定义Layer的方法
	Layer.prototype = {
		init: function() {
			var options = this.options;
			var content = options.content;
			var title = [options.title];
			var buttons= options.buttons;
			var titleStyle = options.titleStyle;
			var contentStyle = options.contentStyle;
			if(titleStyle){
				title.push(titleStyle)
			}
			$(this.$element).children().on('click',function(e){
				var obj = {
					type:"1", 
					title: title,
					anim: 'up',
					content: content,
					style: contentStyle,
				};
				if(buttons.length>0){
					obj.btn = buttons;
				}
				layer.open(obj);
			});
		}
	};
	
	//在插件中使用Layer对象
	$.fn.mylayui = function(opt) {
		//创建Layer的实体
		mylayer = new Layer(this, opt);
		//调用其方法
		mylayer.init();
		return mylayer;
	};

})(jQuery, window, document);
