(function($) {

	$.fn.order = function(options) {
		var defaults = {
			activeClass: undefined,
			orderField: undefined,
			orderType: 'asc',
			callback: undefined
		};

		var options = $.extend(defaults, options);
		return this.each(function() {
			$(this).on("click", '.orderField', function(e) {
				var field = $(this).attr("orderField");
				if (options.orderField == undefined) {
					return;
				}
				var orderTarget = $(this).children(".mui-icon-arrowdown,.mui-icon-arrowup");
				
				//如果点击的排序字段是当前排序字段
				if (options.orderField == field) {
					if (options.orderType == 'desc') {
						options.orderType = 'asc'
						orderTarget.removeClass('mui-icon-arrowdown').addClass('mui-icon-arrowup');
					} else {
						options.orderType = 'desc'
						orderTarget.removeClass('mui-icon-arrowup').addClass('mui-icon-arrowdown');
					}
				} else {
					options.orderField = field;
					if (orderTarget.hasClass("mui-icon-arrowup")) {
						options.orderType = 'asc'
					} else {
						options.orderType = 'desc'
					}
					$('.' + options.activeClass).removeClass(options.activeClass);
					orderTarget.addClass(options.activeClass);
				}
				if (options.callback) {
					options.callback(options);
				}
			});
		});
	};
})(jQuery);
