;


function convertBase64ToUrl(edeiUrl, base64Data, share, examNum) {
	if (edeiUrl[edeiUrl.length - 1] === '/') {
		edeiUrl = edeiUrl.slice(0, -1); // 如果末尾有斜杠，则使用 slice() 方法截取除了最后一个字符的子字符串
	}
	const url = edeiUrl + "/imageAction!getBase64ImageURl.action";
	const xhr = new XMLHttpRequest();
	xhr.open("POST", url, false); // 设置为 true 表示异步请求

	// 构建请求数据对象
	const formData = new FormData();
	formData.append("base64", base64Data);
	formData.append("share", share||"");
	formData.append("examNum", examNum||"");
	// 发送 POST 请求
	xhr.send(formData);

	if (xhr.readyState === XMLHttpRequest.DONE) {
		if (xhr.status === 200) {
			const response = xhr.responseText;
			// 在这里处理服务器返回的响应数据
			return response;
		} else {
			console.error("Request failed:", xhr.status, xhr.statusText);
		}
	}
	return null;
};
function getProjectName() {
	// 获取当前页面的路径
	var pathName = window.document.location.pathname;
	// 将路径按斜杠分割
	var pathArray = pathName.split('/');
	// 第一个非空元素就是工程名（如果路径以斜杠开头，则数组第一个元素是空字符串，第二个元素才是工程名）
	if (pathArray.length  > 1) {
		return pathArray[1];
	}
	return ""; // 如果没有工程名，返回空字符串
};
function getShowRateOfStudentPaper() {
	var url = "/appIndex!getConfiguration.action";
	if(plus){
		var edeiUrl= $.getUrl();
		if (edeiUrl[edeiUrl.length - 1] === '/') {
			edeiUrl = edeiUrl.slice(0, -1); // 如果末尾有斜杠，则使用 slice() 方法截取除了最后一个字符的子字符串
		}
		url = edeiUrl + url;
	}else{
		url="/"+getProjectName()+url;
	}

	const xhr = new XMLHttpRequest();
	xhr.open("POST", url, false); // 设置为 true 表示异步请求

	// 构建请求数据对象
	const formData = new FormData();
	// 发送 POST 请求
	xhr.send(formData);

	if (xhr.readyState === XMLHttpRequest.DONE) {
		if (xhr.status === 200) {
			const response = xhr.responseText;
			// 在这里处理服务器返回的响应数据
			const conff = JSON.parse(response);
			for(var i=0;i<conff.length;i++){
				if(conff[i].confKey=='showRateOfStudentPaper'){
					return conff[i].confValue;
				}
			}
			return "1";
		} else {
			console.error("Request failed:", xhr.status, xhr.statusText);
		}
	}
	return null;
};

(function($, window, document, undefined) {
	// "use strict"
	var _global;
	/**
	 * 默认配置
	 */
	var defaults = {
		tupianType: 'dtk',
		ShowRateOfStudentPaper: undefined,
		logType: ""
	};

	var bAllRight =
		'data:image/png;base64,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';
	var bAllWrong =
		'data:image/png;base64,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';
	var bHalfOf =
		'data:image/png;base64,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';
	var lAllRight =
		'data:image/png;base64,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';
	var lAllWrong =
		'data:image/png;base64,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';
	var lHalfOf =
		'data:image/png;base64,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';

	var yueJuanRenInfoFontSize = 30;
	// 设置全局颜色
	fabric.Object.prototype.set({
		fill: '#FF0000', // 设置为红色，可以使用其他 CSS 颜色表示方式，比如 'red', 'rgba(255, 0, 0, 1)', 等
		stroke: '#000000', // 设置描边颜色，可以使用其他 CSS 颜色表示方式
		strokeWidth: 2, // 设置描边宽度，根据需要修改
	});

	/** 插件对象 DrawCombineImage
	 * @param {Object} options 配置参数 对应 defaults
	 */
	var DrawCombineImage = function(img, options) {
		this.img = img;
		this.opt = extend(defaults, options);
		if(!this.opt.ShowRateOfStudentPaper){
			this.opt.ShowRateOfStudentPaper=getShowRateOfStudentPaper();
		}
		const questionImagesUrl = img.getAttribute("questionImagesUrl");
		if (questionImagesUrl) {
			this.opt.questionImagesUrl = questionImagesUrl;
		}

		this.init();
	};

	function replace0(s) {
		if (s !== null && s.indexOf(".") > 0) {
			s = s.replace(/0+?$/, ""); // 去掉多余的0
			s = s.replace(/[.]$/, ""); // 如最后一位是.则去掉
		}
		return s;
	}

	function formatPercent(fenzi, fenmu, df, defaultVal) {
		// 1. 统一将分子和分母转换为 Number 类型
		// Number() 构造函数可以处理字符串数字，如果是非数字字符串则返回 NaN。
		// 注意：这里移除了对 BigInt 的直接支持，因为 ES5 不支持 BigInt。
		// 如果需要处理大数，需引入第三方库并在外部进行 BigInt 到字符串的转换。
		var numFenzi = Number(fenzi);
		var numFenmu = Number(fenmu);

		// 2. 检查转换后的数字是否有效 (NaN)
		if (isNaN(numFenzi) || isNaN(numFenmu)) {
			return defaultVal;
		}

		// 3. 检查分母是否为0
		if (numFenmu === 0) {
			return defaultVal;
		}

		// 4. 执行百分比计算
		var percentage = (numFenzi / numFenmu) * 100;

		// 5. 使用 Intl.NumberFormat 实例进行格式化，并添加百分号
		// 确保 df 是一个 Intl.NumberFormat 实例。
		// Intl 是 ES2015 (ES6) 引入的，但通常在支持 ES5 的现代浏览器中都可用。
		// 如果你的目标环境非常老旧且不支持 Intl，则需要提供一个自定义的格式化函数。
		return df.format(percentage) + "%";
	}
	var convertStringToInteger = function(str) {
		const parsedInt = parseInt(str, 10);
		return isNaN(parsedInt) ? 0 : parsedInt;
	}

	var extend = function(defaults, options) {
		var newOption = {};
		for (var key in defaults) {
			newOption[key] = defaults[key];
		}
		for (var key in options) {
			newOption[key] = options[key];
		}
		return newOption;
	};
	/**
	 * DrawCombineImage 属性
	 */
	DrawCombineImage.prototype = {

		/* 初始化插件 */
		init: function() {
			var node = window.getComputedStyle(this.img, null);
			var width = node.getPropertyValue("width").replace("px", "") * 1;
			// 创建一个 canvas 元素
			const canvasDom = document.createElement("canvas");
			this.element = canvasDom;
			canvasDom.style.display = "none"
			document.body.appendChild(canvasDom);
			const canvas = new fabric.StaticCanvas(canvasDom);

			this.canvas = canvas;
			var that = this;
			const imgWidth = this.img.naturalWidth;
			const imgHeight = this.img.naturalHeight;
			var height = imgHeight / imgWidth * width;
			canvasDom.style.width = width + "px";
			canvasDom.style.height = height + "px";
			canvas.height = imgHeight;
			canvas.width = imgWidth;
			canvasDom.setAttribute('width', imgWidth);
			canvasDom.setAttribute('height', imgHeight);

			if (that.isIOS()) {
				that.ajaxImageBase64(this.img.src, function(base64) {
					var image = fabric.Image.fromURL(base64, function(i) {
						i.width = imgWidth;
						i.height = imgHeight;
						canvas.setBackgroundImage(i);
						that.canvas.renderAll(that.canvas);
						that.loadQuestionList();
					});
				})
			} else {
				var image = fabric.Image.fromObject(this.img, function(i) {
					i.width = imgWidth;
					i.height = imgHeight;
					canvas.setBackgroundImage(i);
					that.canvas.renderAll(that.canvas);
					that.loadQuestionList();
				});
			}
		},
		isIOS: function() {
			const userAgent = window.navigator.userAgent.toLowerCase();
			return /iphone|ipad|ipod/.test(userAgent);
		},
		loadQuestionList: function() {
			var that = this;
			console.log(":::loadQuestionList:::")
			this.ajax(this.opt.questionImagesUrl, function(data) {
				that.addTextAndImage(data);
				setTimeout(function() {
					var cloneLoad = that.img.onload;
					that.img.onload = function() {
						that.img.onload = cloneLoad
					};
					that.img.src = that.toBase64();
				}, 100)
			})
		},
		toBase64: function() {
			return this.element.toDataURL();
		},
		biaoJiHeBingCaiQieTi:function (data) {
			if(!data || data.length == 0) {
				return data;
			}
			// 过滤出 questionType == 1 且 type == 'hbcq' 的题目
			const filteredQuestions = data.filter(
				(item) => item.questionType === "1" && item.type === "hbcq"
			);

			// 按 questionNum 分组
			const grouped = filteredQuestions.reduce((acc, item) => {
				// 如果分组中不存在该 questionNum，则创建一个新组
				if (!acc[item.questionNum]) {
					acc[item.questionNum] = [];
				}
				// 将题目加入对应分组
				acc[item.questionNum].push(item);
				return acc;
			}, {});

			// 对每个分组的最后一题设置 last 属性为 true
			Object.keys(grouped).forEach((questionNum) => {
				const group = grouped[questionNum];
				if (group.length > 0) {
					group[group.length - 1].last = true; // 设置最后一个题的 last 属性为 true
					group[group.length - 1].group = group;
				}
			});

			// 返回处理后的原始数据
			return data;
		},
		addTextAndImage: function(questionImageList) {
			var that = this;
			if (!questionImageList) {
				return;
			}
			questionImageList = that.biaoJiHeBingCaiQieTi(questionImageList);
			var oneHbcqW = 0;
			var oneHbcqH = 0;
			var pianyi = 20;
			var pid = "";
			var scoreString = "";
			var studentReportShowItem = "";
			var b = 50;
			var df2 = new Intl.NumberFormat('zh-CN', {
				minimumFractionDigits: 2,
				maximumFractionDigits: 2
			});
			for (var i = 0; i < questionImageList.length; i++) {
				var question = questionImageList[i];

				//计算类型
				var jisuanType = question.jisuanType;
				if (i == 0) {
					studentReportShowItem = null == question.studentReportShowItem ? "0" : question
						.studentReportShowItem;
					studentReportShowItem = "T" == this.opt.logType ? "0" : studentReportShowItem;
				}
				// 在学科总分不为空的情况下，在卷头打印总分，客观题总分，主观题总分
				if (question.ext3) {
					if (question.page * 1 == 1) {
						var a = "0" == question.ext2 ? 50 : 100;
						// g.setFont(f60);
						// if ("0" == jisuanType) { //选择题计算
						// 	if ("1" == studentReportShowItem) { //正确率
						// 		var str = "客观题正确率：" + formatPercent(question.oqts, question.fullScore, df2,
						// 			"--");
						// 		var text = new fabric.Text(str, {
						// 			left: a,
						// 			top: b += 70,
						// 			fontFamily: "微软雅黑",
						// 			fontSize: 40,
						// 			fontStyle: 'normal'
						// 		});
						// 		that.canvas.add(text);
						// 	} else {
						// 		var str = "客观题得分：" + replace0(question.oqts);
						// 		var text = new fabric.Text(str, {
						// 			left: a,
						// 			top: b += 70,
						// 			fontFamily: "微软雅黑",
						// 			fontSize: 40,
						// 			fontStyle: 'normal'
						// 		});
						// 		that.canvas.add(text);
						// 	}
						// } else {
						if ("2" == studentReportShowItem) { //等级
							var str = question.subjectName + "：" + (question.dengji || "--")
							var text = new fabric.Text(str, {
								left: a,
								top: b,
								fontFamily: "微软雅黑",
								fontSize: 60,
								fontStyle: 'normal'
							});
							that.canvas.add(text);
						} else if ("1" == studentReportShowItem) { //正确率
							var str = question.subjectName + "：" + formatPercent(question.ext3, question
								.fullScore, df2, "--");
							var text = new fabric.Text(str, {
								left: a,
								top: b,
								fontFamily: "微软雅黑",
								fontSize: 60,
								fontStyle: 'normal'
							});
							that.canvas.add(text);

							var str2 = "客观题正确率：" + formatPercent(question.oqts, question.fullScore, df2,
								"--");
							var text2 = new fabric.Text(str2, {
								left: a,
								top: b += 70,
								fontFamily: "微软雅黑",
								fontSize: 40,
								fontStyle: 'normal'
							});
							that.canvas.add(text2);

							if ("0" != jisuanType) {
								var str3 = "主观题正确率：" + formatPercent(question.sqts, question.fullScore, df2,
									"--");
								var text3 = new fabric.Text(str3, {
									left: a,
									top: b += 50,
									fontFamily: "微软雅黑",
									fontSize: 40,
									fontStyle: 'normal'
								});
								that.canvas.add(text3);
							}
						} else {
							var str = question.subjectName + "：" + replace0(question.ext3);
							var text = new fabric.Text(str, {
								left: a,
								top: b,
								fontFamily: "微软雅黑",
								fontSize: 60,
								fontStyle: 'normal',
							});
							that.canvas.add(text);

							var str2 = "客观题得分：" + replace0(question.oqts);
							var text2 = new fabric.Text(str2, {
								left: a,
								top: b += 70,
								fontFamily: "微软雅黑",
								fontSize: 40,
								fontStyle: 'normal',
							});
							that.canvas.add(text2);

							if ("0" != jisuanType) {
								var str3 = "主观题得分：" + replace0(question.sqts);
								var text3 = new fabric.Text(str3, {
									left: a,
									top: b += 50,
									fontFamily: "微软雅黑",
									fontSize: 40,
									fontStyle: 'normal',
								});
								that.canvas.add(text3);
							}
							if ("0" != jisuanType) {
								// var str3 = "阅卷人：" + replace0(question.sqts);
								// var text3 = new fabric.Text(str3, {
								// 	left: a,
								// 	top: b += 100,
								// 	fontFamily: "微软雅黑",
								// 	fontSize: 40,
								// 	fontStyle: 'normal',
								// });
								// that.canvas.add(text3);
							}

						}
						// }

						b += 80;
					}
					continue;
				}
				if (question.questionType) {
					var questionScore = question.questionScore;
					var fullScore = question.fullScore;

					// 按比例缩放
					if ("1" == question.questionType) { // 主观题直接打分数
						if ("0" == jisuanType) { //选择题计算
							continue;
						}
						var questionX = convertStringToInteger(question.questionX);
						var questionY = convertStringToInteger(question.questionY);
						var questionW = convertStringToInteger(question.questionW);
						var questionH = convertStringToInteger(question.questionH);

						//续题
						var qiList = [];
						if (question.tag) {
							qiList = JSON.parse(question.tag);
						}
						if ("F" == question.cross_page) { //非跨页的题
							if (qiList.length > 0) { //有续题
								//第一个续题
								var firstObj = qiList[0];
								//对比当前题块与第一个续题的宽度，如果当前题块宽度小于第一个续题宽的一半，往第一个续题的位置写分数
								if (questionW * 2 < firstObj.width) {
									if ("dtk" == that.opt.tupianType) { //答题卡位置，小题切图在初始位置就可以
										questionX = firstObj.x;
										questionY = firstObj.y;
									}
									questionW = firstObj.width;
									questionH = firstObj.height;
								}
							}

							var flagW = 55; // 图片缩放比列（图片的宽）
							if (questionW < 300) { // 题块宽度<300
								flagW = questionW * flagW / 300; // 按比例计算字体大小
							}
							if (questionH < 200) { // 题块高度<200
								flagW = questionH * flagW / 200; // 按比例计算字体大小
							}
							flagW = flagW < 8 ? 8 : flagW;
							var fontW = flagW; // 字体  50
							//
							// f = new Font("Arial", Font.BOLD, flagW);// 普通字体大小
							// g.setFont(f);

							var imageWidth = 92;
							var imageHeight = 75;

							var scoreImg = null;
							if (fullScore * 1 == questionScore * 1) { // 得分=满分  x轴向右偏移量
								scoreImg = bAllRight;
							} else if (questionScore * 1 == 0) { // 得分=0
								scoreImg = bAllWrong;
							} else { // 得分小于满分
								scoreImg = bHalfOf;
							}

							var imgW = flagW;
							var imgH = imageHeight * flagW / imageWidth;

							if ("hbcq" == question.type) { // 合并裁切题
								fontW = fontW * 4 / 5; // 合并裁切题的字体再缩小
								// f = new Font("Arial", Font.BOLD, fontW);
								// g.setFont(f);
								var quesStr = "T" + question.questionName + ": ";
								var scoreStr = "";
								if ("0" == studentReportShowItem || "3" == studentReportShowItem) { //得分
									scoreStr = " " + replace0(question.questionScore) + "/" +
										replace0(question.fullScore) + "  ";
								} else if ("1" == studentReportShowItem || "1" == that.opt
									.ShowRateOfStudentPaper) { //正确率或者  等级允许显示的情况下
									scoreStr = " " + formatPercent(question.questionScore, question
										.fullScore, df2, "--") + "  ";
								}

								var text1 = new fabric.Text(quesStr, {
									fontFamily: "Arial",
									fontSize: fontW,
									fontWeight: "bold",
									fontStyle: 'normal'
								})
								var quesStrW = text1.width;
								text1.text = scoreStr;
								var scoreStrW = text1.width;

								if (pid != question.questionNum) {
									pid = question.questionNum;
									oneHbcqW = pianyi;
									oneHbcqH = pianyi + imgH;
								} else {
									if ((oneHbcqH + imgH) <= questionH) { //在框内显示，显示不下的在最后一个显示上堆叠
										if ((oneHbcqW + quesStrW + imgW + scoreStrW) > questionW) { //换行
											oneHbcqW = pianyi;
											oneHbcqH += imgH;
										}
									}
								}

								that.canvas.add(new fabric.Text(quesStr, {
									left: questionX + oneHbcqW,
									top: questionY + oneHbcqH,
									fontFamily: "Arial",
									fontSize: fontW,
									fontWeight: "bold",
									fontStyle: 'normal'
								}));

								const x = questionX + quesStrW + oneHbcqW;
								const y = questionY + oneHbcqH;
								const w = imgW;
								const h = imgH;
								fabric.Image.fromURL(scoreImg, function(img) {
									img.set({
										left: x,
										top: y,
										scaleX: h / img.height,
										scaleY: h / img.height,
									});
									that.canvas.add(img);
									that.canvas.renderAll(that.canvas);
								});
								that.canvas.add(new fabric.Text(scoreStr, {
									left: questionX + quesStrW + imgW + oneHbcqW,
									top: questionY + oneHbcqH,
									fontFamily: "Arial",
									fontSize: fontW,
									fontWeight: "bold",
									fontStyle: 'normal'
								}));

								if ((oneHbcqH + imgH) <= questionH) { //在框内显示，显示不下的在最后一个显示上堆叠
									oneHbcqW += quesStrW + imgW + scoreStrW;
								}
								var yuejuanjiaoshiMapList = question.yuejuanjiaoshiMapList;
								var top = questionY + oneHbcqH * 2;
								if(question.last==true && yuejuanjiaoshiMapList) {
									for (var j = 0; j < yuejuanjiaoshiMapList.length; j++) {
										//双评显示： 学校 姓名 手机号 几评（1评 2评 3评 裁决） 得分
										var ping = yuejuanjiaoshiMapList[j];
										var scoreStr = question.group
											.map((item) => Number(item.questionScore).toString()).join(" ");
										var yuaJuanInfo;
										if(yuejuanjiaoshiMapList.length==1){
											yuaJuanInfo = `${ping.schoolName} ${ping.realname}`;
										}else{
											yuaJuanInfo = `${ping.schoolName} ${ping.realname} ${ping.userNumName} ${scoreStr}`;
										}

										var yuaJuanInfoText = new fabric.Text(yuaJuanInfo, {
											left: questionX + pianyi,
											top: top,
											fontFamily: "Arial",
											fontSize: yueJuanRenInfoFontSize,
											fontWeight: "bold",
											fontStyle: 'normal',
											fill:'blue'
										});
										if(yuaJuanInfoText.width>questionW){
											//变成两行
											var textStr = `${ping.schoolName} ${ping.realname} ${ping.userNumName}`;
											yuaJuanInfoText.set("text",textStr);
											top += oneHbcqH;
											var scoreText = new fabric.Text(scoreStr, {
												left: questionX + pianyi,
												top: top,
												fontFamily: "Arial",
												fontSize: yueJuanRenInfoFontSize,
												fontWeight: "bold",
												fontStyle: 'normal',
												fill:'blue'
											});
											that.canvas.add(scoreText);
										}
										that.canvas.add(yuaJuanInfoText);
									}
								}
							} else if ("0" == question.type) { //普通题
								if ("0" == studentReportShowItem || "3" == studentReportShowItem) { //得分
									scoreString = replace0(question.questionScore) + "/" +
										replace0(question.fullScore);
								} else if ("1" == studentReportShowItem || "1" == that.opt
									.ShowRateOfStudentPaper) { //正确率或者  等级允许显示的情况下
									scoreString = formatPercent(question.questionScore, question.fullScore,
										df2, "--");
								}
								var text = new fabric.Text(scoreString, {
									fontFamily: "Arial",
									fontSize: fontW,
									fontWeight: "bold",
									fontStyle: 'normal'
								})
								var strW = text.width;

								var cha = questionW - strW - pianyi;

								that.canvas.add(new fabric.Text(scoreString, {
									left: questionX + cha,
									top: questionY + imgH + pianyi,
									fontFamily: "Arial",
									fontSize: fontW,
									fontWeight: "bold",
									fontStyle: 'normal'
								}));
								var yuejuanjiaoshiMapList = question.yuejuanjiaoshiMapList;
								if(yuejuanjiaoshiMapList) {
									for (var j = 0; j < yuejuanjiaoshiMapList.length; j++) {
										//双评显示： 学校 姓名 手机号 几评（1评 2评 3评 裁决） 得分
										var ping = yuejuanjiaoshiMapList[j];
										var yuaJuanInfo;
										if(yuejuanjiaoshiMapList.length==1){
											yuaJuanInfo = `${ping.schoolName} ${ping.realname}`;
										}else{
											yuaJuanInfo = `${ping.schoolName} ${ping.realname} ${ping.userNumName} ${Number(ping.questionScore).toString()}`;
										}

										var yuaJuanInfoText = new fabric.Text(yuaJuanInfo, {
											left: questionX + cha,
											top: questionY + imgH*(j+2)+10 + pianyi,
											fontFamily: "Arial",
											fontSize: yueJuanRenInfoFontSize,
											fontWeight: "bold",
											fontStyle: 'normal',
											fill:'blue'
										})
										var cha2 = questionW - yuaJuanInfoText.width - pianyi;
										yuaJuanInfoText.left = questionX + cha2;
										that.canvas.add(yuaJuanInfoText);
									}
								}

								const x1 = questionX + pianyi;
								const y1 = questionY + +imgH + pianyi;

								// 写入图片
								fabric.Image.fromURL(scoreImg, function(img) {
									img.set({
										left: x1,
										top: y1,
										scaleX: imgH / img.height,
										scaleY: imgH / img.height,
									});
									// that.canvas.renderAll.bind(canvas)
									that.canvas.add(img);
									that.canvas.renderAll(that.canvas);
								});
							}
						}

						//上面写分数的时候可能会使用续题的值，所以下面需要重新获取参数
						questionX = convertStringToInteger(question.questionX);
						questionY = convertStringToInteger(question.questionY);
						questionW = convertStringToInteger(question.questionW);
						questionH = convertStringToInteger(question.questionH);

						var questionHCurrent = 0;
						var questionHSum = questionH;
						if ("qt" == that.opt.tupianType || "T" == question.cross_page) { //跨页的题
							questionHCurrent = question.questionHCurrent * 1;
							questionHSum = question.questionHSum * 1;
						}
						if ("1" != question.num && question.img) { //阅卷标记（双评题不显示标记，不准确）
							var biaoZhuinImage = question.img;

							questionH = "qt" == that.opt.tupianType ? questionHSum : questionH;
							// g.drawImage(biaoZhuinImage, questionX, questionY, (questionX + questionW), (questionY + questionH)
							//     , 0, questionHCurrent, questionW, (questionHCurrent + questionH)
							//     , null);
							const x2 = questionX;
							const y2 = questionY;
							const w2 = questionW;
							const h2 = questionH;
							const curY2 = questionHCurrent;
							if (biaoZhuinImage) {
								console.log(111111111111)
								// 写入图片
								fabric.Image.fromURL(biaoZhuinImage, function(img) {
									img.set({
										left: x2,
										top: y2-curY2,
										// width: w2,s
										// height: h2,
										// clipPath: new fabric.Rect({
										// 	left: 0,
										// 	top: curY2,
										// 	originY: 'center',
										// 	originX: 'center',
										// 	width: w2,
										// 	height: h2,
										// })
									});
									that.canvas.add(img);
									that.canvas.renderAll(that.canvas);
								});
							}

							if ("dtk" == that.opt.tupianType && question.tag) { //跨页
								for (var j = 0; j < qiList.length; j++) {
									var qi = qiList[j];
									questionHCurrent += questionH;
									const x3 = qi.x;
									const y3 = qi.y;
									const w3 = qi.width;
									const h3 = qi.height;
									const curY3 = questionHCurrent;
									console.log(qi)
									console.log(curY3)
									// console.log(question)
									// 写入图片
									fabric.Image.fromURL(biaoZhuinImage, function(img) {
										console.log(img.width)
										console.log(img.height)
										img.set({
											left: x3,
											top: y3-curY3,
											width: img.width,
											height: img.height
										});
										that.canvas.add(img);
										that.canvas.renderAll(that.canvas);
									});
								}
							}
						}
					} else { // 客观题的时候 分数转换为图标
						var answer = question.answer;
						var xx = question.ext1 * 1;
						var yy = question.ext2 * 1;
						if (fullScore * 1 == questionScore * 1) { // 得分=满分
							(function(xx1, yy1) {
								fabric.Image.fromURL(lAllRight, function(img) {
									img.set({
										left: xx1 + 4,
										top: yy1,
									});
									that.canvas.add(img);
									that.canvas.renderAll(that.canvas);
								});
							})(xx, yy);

						} else if (questionScore * 1 == 0) { // 得分=0
							if ("-1" == answer) { //小题
								(function(xx1, yy1) {
									fabric.Image.fromURL(lAllWrong, function(img) {
										img.set({
											left: xx1 + 4,
											top: yy1,
										});
										that.canvas.add(img);
										that.canvas.renderAll(that.canvas);
									});
								})(xx, yy);
							} else { //答题卡
								that.canvas.add(new fabric.Text(question.answer, {
									left: xx + 4,
									top: yy - 4,
									fontFamily: "Arial",
									fontSize: 30,
									fontWeight: "bold",
									fontStyle: 'normal'
								}));
							}

						} else { // 得分小于满分
							if ("-1" == answer) { //小题
								//显示半对
								(function(xx1, yy1) {
									fabric.Image.fromURL(lHalfOf, function(img) {
										img.set({
											left: xx1 + 4,
											top: yy1,
										});
										that.canvas.add(img);
										that.canvas.renderAll(that.canvas);
									});
								})(xx, yy);
							} else { //答题卡
								(function(xx1, yy1) {
									fabric.Image.fromURL(lHalfOf, function(img) {
										img.set({
											left: xx1 + 4,
											top: yy1,
										});
										that.canvas.add(img);
										that.canvas.renderAll(that.canvas);
									});
								})(xx, yy);

								that.canvas.add(new fabric.Text(question.answer || '', {
									left: xx + 4 + 26,
									top: yy - 4,
									fontFamily: "Arial",
									fontSize: 30,
									fontWeight: "bold",
									fontStyle: 'normal'
								}));
							}
						}
					}
				}
			}
		},
		ajax: function(url, callback) {
			const xhr = new XMLHttpRequest();
			xhr.open("GET", url, true);
			xhr.onload = function() {
				if (xhr.status >= 200 && xhr.status < 300) {
					const responseData = JSON.parse(xhr.responseText);
					callback(responseData);
				} else {
					console.error("请求失败，状态码：" + xhr.status);
				}
			};
			xhr.onerror = function() {
				console.error("请求发生错误");
			};
			xhr.send();
		},

		uuid: function() {
			return 'xxxxxxxxxxxx4xxxyxxxxxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
				var r = Math.random() * 16 | 0,
					v = c == 'x' ? r : (r & 0x3 | 0x8);
				return v.toString(16);
			});
		},
		ajaxImageBase64: function(url, callback) {
			// console.log(plus)
			var that = this;
			// 使用 plus.downloader.createDownload 下载网络图片到本地
			plus.downloader.createDownload(url, {
				filename: '_downloads/' + that.uuid() + 'image.jpg', // 下载到本地的路径
				timeout: 20, // 设置超时时间，单位为秒
			}, function(downloadTask, status) {
				if (status === 200) {
					// 下载成功，获取本地图片的 FileEntry 对象
					var localPath = downloadTask.filename;
					plus.io.resolveLocalFileSystemURL(localPath, function(entry) {
						entry.file(function(file) {
							var reader = new plus.io.FileReader();
							reader.onloadend = function(evt) {
								// 读取完成，获取图片的 Base64 编码
								var base64Data = evt.target.result;
								// console.log('Base64 data:', base64Data);
								callback(base64Data);
								// 删除下载的图片文件
								entry.remove(function() {
									console.log(
										'Downloaded image removed successfully.'
									);
								}, function(error) {
									console.error(
										'Failed to remove downloaded image:',
										error);
								});

							};
							reader.readAsDataURL(file); // 以 Data URL 格式读取图片文件
						});
					});
				} else {
					// 下载失败，处理错误
					console.error('Download failed. Status:', status);
				}
			}).start();
		}
	}
	//把DrawCombineImage对象暴露出去
	_global = (function() {
		return this || (0, eval)('this');
	}());
	!('DrawCombineImage' in _global) && (_global.DrawCombineImage = DrawCombineImage);
})(jQuery, window, document);
