
var vm = new Vue({
    el: '#cepingjiemian',
    data: {
		examNum:'',
		subjectNum:'',
		gradeNum:'',
		examPaperNum:'',
		stageId:'',
		startTime:'',
		overTime:'',
		tijiaoCount:'',
		tijiaoStatus:'',
        cepingName:'',
		//题信息
		tiList:[],
		//当前选的题的下标
		defQuestionIndex:'',
		//当前选择的题
		defQuestion:{},
		//最大上传张数
		maxFiles:3,
		selectedFiles: [], // 已选择的文件数组
		uploading: false, // 主观题上传状态
		uploadResult: null, // 上传结果
		showModal: false, // 是否显示大图预览
		uploading2:false,
		//当前题的选择的选项
		myanswer:'',
		//主观题是否作答
		disabled:true,
		rotations: {}, // 存储每张图片的旋转角度 {uid: degrees}
		screenState:'S',//当前是横屏还是竖屏 H:横屏 S:竖屏
		expanded: true,//题干展开收起
		expanded2:true,//知识点答案解析展开收起
		//裁切模态框是否展示
		showCropper:false,
		//当前裁切的图片数组
		fileList:[],
		//当前裁切的图片
		currentImage:'',
		//当前裁切的图片下标
		currentFileIndex:0,
		copper:null,
		//当前裁切的是否是第一张
		isFirst:true,
		//当前裁切的是否是最后一张
		isEnd:false,
		picUrl:'',
		justRotated:false,


		isCropMode:true,
		
		//刻度尺式
		scales: [],
		currentValue: 0,
		wrapperTranslateX: 0,
		rulerWidth: 0,
		scaleWidth: 12, // 每个刻度之间的宽度
		startX: 0,
		isDragging: false

    },
	created(){
		// 生成-45到45的刻度
		for (let i = -45; i <= 45; i++) {
			this.scales.push(i);
		}
	},
    watch: {
		tijiaoStatus:function(){
			this.disabled=vm.tijiaoStatus=='0'?false:true;
			//首先判断当前时间是否大于测评起始时间
			var now = new Date();
			
			// 获取年、月、日、时、分、秒
			var year = now.getFullYear();
			var month = String(now.getMonth() + 1).padStart(2, '0'); // 月份补零
			var day = String(now.getDate()).padStart(2, '0'); // 日期补零
			var hours = String(now.getHours()).padStart(2, '0');
			var minutes = String(now.getMinutes()).padStart(2, '0');


			var date=year+"-"+month+"-"+day;
			var time=hours+":"+minutes;
			if(date+" "+time>vm.overTime){//当前时间大于终止时间，测评时间结束
				this.disabled=true;
			}
		},
		
		currentValue:function(newVal,oldVal){
			// console.log(oldVal);
			// console.log(newVal);
			var rotate=newVal-oldVal;
			this.rotate(rotate);
		}
    },
    mounted: function () {
		mui.previewImage();
		this.initRuler();
		this.bindEvents();
		
		// // 双指触摸切换模式
		// this.$refs.cropperImage.addEventListener('touchstart', function(e) {
		// 	 console.log("112");
		// 	if (e.touches.length =1) { // 检测双指
		// 	  const currentMode = this.cropper.getDragMode();
		// 	  this.cropper.setDragMode(currentMode === 'move' ? 'crop' : 'move');
		// 	}
		// });
	},
	
    methods:{
		
		//切换题
		changeTi:function(i){
			if(this.defQuestion.questionType=='1'){//主观题
				if(this.defQuestion.fileList!=''){
					mui.alert("T"+this.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
					return;
				}
			}
			this.defQuestion=this.tiList[i];
			this.defQuestionIndex=i;
			this.selectedFiles=[];
			this.uploading=false;
			if(this.defQuestion.questionType=='0'){//客观题
				if(this.defQuestion.submitStatus=='1'){//已提交
					if(this.defQuestion.myanswer==''){
						this.myanswer="1";
					}else{
						this.myanswer='';
					}
				}else{
					this.myanswer='';
				}
			}else{
				if(this.defQuestion.submitStatus=='1'){//已提交
					if(this.defQuestion.mergedImage==undefined){
						this.myanswer="1";
					}else{
						this.myanswer='';
					}
				}else{
					this.myanswer='';
				}
			}
			this.$nextTick(function() {
				this.scrollToTiItem(this.defQuestionIndex); // 调用方法
			}.bind(this));
			
			scroll();
			
			vm.expanded=true;
			vm.expanded2=true;
			
		},
		//选择题后自动滚动
		scrollToTiItem(index) {
		    const targetEl = this.$refs['tiItem_' + index][0];
		    if (targetEl) {
		      targetEl.scrollIntoView({
		        behavior: "smooth",
		        block: "nearest",
		        inline: "center"
		      });
		    }
		  },
		//点击选项
		xuanze(item){
			this.myanswer='';
			if(this.defQuestion.multiple=='0'){//单选
				this.defQuestion.myanswer=item;
			}else{//多选
				if (this.defQuestion.myanswer.includes(item)) {
					this.defQuestion.myanswer = this.defQuestion.myanswer.filter(function(i) {
					  return i !== item;
					});
				} else {
					this.defQuestion.myanswer.push(item)
				}
			}
			tijiao(null,null);
		},
		//点击不会
		buhui:function(item){
			if(this.defQuestion.questionType=='0'){
				if(this.defQuestion.multiple=='0'){
					this.defQuestion.myanswer='';
				}else{
					this.defQuestion.myanswer=[];
				}
				
			}else{
				this.defQuestion.myanswer='';
			}
			
			tijiao(item,null);
		},
		pre:pre,
		next:next,
		//提交全卷
		tijiaoAll:tijiaoAll,
		// 触发文件选择
		triggerFileInput() {
		  this.$refs.fileInput.click()
		},
		// 处理文件选择
		handleFileChange(event) {
		  var files = Array.from(event.target.files);

		  // 检查是否超过限制
		  if (this.defQuestion.fileList + files.length > this.maxFiles) {
			mui.toast('最多只能上传'+this.maxFiles+'张图片')
			return
		  }
		  
		  // 过滤和验证文件
		  var validFiles = files.filter(function(file) {
			// 验证文件类型
			if (!file.type.startsWith('image/')) {
			  mui.toast(`文件 ${file.name} 不是图片类型，已跳过`)
			  return false
			}
			
			// 验证文件大小 (限制3MB)
			// if (file.size > 3 * 1024 * 1024) {
			//   this.showAlert(`图片 ${file.name} 超过3MB限制，已跳过`)
			//   return false
			// }
			
			return true
		  })
		  
		   var totalImages = 0;
		    
		    // 统计有效图片数量
		    for (var i = 0; i < files.length; i++) {
		      if (files[i].type.match('image.*')) {
		        totalImages++;
		      }
		    }
			
			for (var i = 0; i < files.length; i++) {
			  var file = files[i];
			  if (!file.type.match('image.*')) continue;
	  
			  var reader = new FileReader();
			  reader.onload = function(e) {
				this.fileList.push(e.target.result);
				if (this.fileList.length === totalImages) {
					this.openCropper(0);
				}
			  }.bind(this);
			  reader.readAsDataURL(file);
			
			}
		  
		  // 重置文件输入，允许重复选择相同文件
		  event.target.value = ''
		  
		},
		// 移除已选图片
		removeImage(img,index) {
		
		  var btnArray = ['取消', '确定'];
		  
		  mui.confirm('确定要删除当前图片吗', '提示', btnArray, function(e) { 
			  if(e.index==1){
				  // 释放预览URL内存
				  URL.revokeObjectURL(vm.defQuestion.fileList[index].previewUrl)
				  vm.defQuestion.fileList.splice(index, 1);
				  delete vm.rotations[img.url];
			  }
		  })
		  
		},
		//旋转图片
		rotateImage(file,index) {
			this.rotations[file.url]  = (this.getRotation(file)  + 90) % 360;
			// mui.toast(' 图片已旋转90度');
			
			// 更新视图
			var imgElement = document.querySelectorAll('.xuanze img')[index];
			      
			// 应用旋转样式
			if (imgElement) {
				imgElement.style.transform = `rotate(${this.rotations[file.url]}deg)`;
				imgElement.style.transition = 'transform 0.3s ease';
			}
		},
		//移动图片
		move(action,item,index){
			//获取图片个数
			var imgCount=this.defQuestion.fileList.length;
			var offset=-1;
			switch (action) {
				case 'up':
					if (index == 0) {
						alert("已经是最前面了，不能再上移了！！！");
						return;
					}
					offset = -1;
					break;
				case 'down':
					if (index == imgCount - 1) {
						alert("已经是最下边了，不能再下移了！！！")
						return;
					}
					offset = 1;
					break;
			}
			this.defQuestion.fileList.splice(index, 0, this.defQuestion.fileList.splice(index + offset, 1)[0]);  //list.splice(要移动的下标，要删除的个数，要移动的)
		},
		// 获取图片旋转角度
		getRotation(file) {
			return this.rotations[file.url]  || 0;
		},
		//合并压缩上传主观题
		uploadScoreImg() {
			this.uploading=true;
			// 创建图片列表，每个图片对象包含file和rotation
			var imageList = this.defQuestion.fileList.map(function(file,  index) {
				return {
					file: file.url,
					rotation: vm.getRotation(file)
				};
			});
			
			mergeAndCompressImagesWithRotation(imageList, {
				dpi: 300,
			}, function(err, base64) {
				if (err) {
					console.error(' 处理失败:', err);
					vm.$message.error('图片处理失败: ' + err.message);
					return;
				}
				//上传合并压缩后的图片
				tijiao(null,base64);
			});
			

	   },
		//题干展开or收起
		zhankaiOrShouQi(){
			var el=this;
			if(el.expanded){
				el.expanded=false;
			}else{
				el.expanded=true;
			}
		},
		//知识点答案解析展开or收起
		zhankaiOrShouQi2(){
			var el=this;
			if(el.expanded2){
				el.expanded2=false;
			}else{
				el.expanded2=true;
			}
		},
		// 裁切图片
		openCropper: function(index) {
			var el=this;
		  el.currentFileIndex = index;
		  el.currentImage = el.fileList[index];
		  el.showModal = true;
		  el.isFirst = (index === 0);
		  el.isEnd = (index === el.fileList.length - 1);
		  
		  var imgWidth = this.naturalWidth;  // 图片原始宽度
		  var imgHeight = this.naturalHeight; // 图片原始高度
		  
		  el.$nextTick(function() {
			if (el.cropper) {
			  el.cropper.destroy();
			}
			el.cropper = new Cropper(el.$refs.cropperImage, {
				aspectRatio: NaN, // 保持图片原始比例, // 1:1比例，可以根据需要调整 16/9 1/1
				viewMode: 1, //限制裁切框0：无限制 1：不超过画布大小(默认) 2：不超过画布大小，且画布填充为cover 3:不超过画布大小，且画布填充为contain
				autoCropArea: 0.9,//初始裁剪框占图片90%面积 
				responsive: true,
				preview: '.crop',
				rotatable :true,
				background: false, // 设置为白色背景
				guides :true,
				checkCrossOrigin:false,
				center: true,  // 新增配置
				dragMode: 'move',//允许调整裁剪框
				cropBoxMovable: true,  // 允许移动裁剪框
				cropBoxResizable: true, // 允许调整大小（四个角可拖动）
				autoCrop: true,//自动显示裁剪框
				autoCenter: true,  // 关键配置
				toggleDragModeOnDblclick: false, // 禁用默认的双击切换
			});
		  });
		},
		//关闭模态框
		closeModal: function() {
		  this.showModal = false;
		  this.fileList=[];
		  this.justRotated=false;
		  this.currentValue=0;
		  this.$refs.fileInput.value = '';
		  if (this.cropper) {
			this.cropper.destroy();
			this.cropper = null;
		  }
		},
		//上一张
		preImage(){
			var el=this;
			if(el.currentFileIndex==0){
				mui.toast('已经是第一张了');
				return;
			}
			el.justRotated=false;
			el.currentValue=0;
			this.setValue(el.currentValue);
			el.openCropper(el.currentFileIndex-1);
		},
		//下一张
		nextImage(){
			var el=this;
			if(el.currentFileIndex==el.fileList.length-1){
				mui.toast('已经是最后一张了');
				return;
			}
			el.justRotated=false;
			el.currentValue=0;
			this.setValue(el.currentValue);
			el.openCropper(el.currentFileIndex+1);
			
		},
		//裁切界面的旋转图片
		rotate: function(degrees) {
		 if (!this.cropper) return;
		     // 每次旋转90度
			 var canvasData = this.cropper.getCanvasData(); 
			 var centerX = canvasData.left  + canvasData.width  / 2;
			 var centerY = canvasData.top  + canvasData.height  / 2;
			
			 this.cropper.rotate(degrees); 
			   
			// 保持中心点位置 
			var newCanvasData = this.cropper.getCanvasData(); 
			this.cropper.setCanvasData({ 
				left: centerX - newCanvasData.width  / 2,
				top: centerY - newCanvasData.height  / 2 ,
				background:'#fff',
			});
			
			// setTimeout(() => {
			//   const container = this.cropper.getContainerData();
			//   const canvas = this.cropper.getCanvasData();
			//   this.cropper.setCanvasData({
			//     left: (container.width - canvas.width) / 2,
			//     top: (container.height - canvas.height) / 2,
			//   });
			// }, 100);
			

			 
		},
		//放大缩小
		zoom: function(ratio) {
		  if (this.cropper) {
			this.cropper.zoom(ratio);
		  }
		},
		//裁切并继续按钮
		cropImage: function() {
		  this.currentValue=0;
		  if (this.cropper) {
			var canvas = this.cropper.getCroppedCanvas({
				fillColor:'#ffffff'
			});
			if (canvas) {
				var croppedDataUrl = canvas.toDataURL('image/jpeg', 1);
				this.fileList[this.currentFileIndex] = canvas.toDataURL('image/jpeg', 1);
				if (this.currentFileIndex < this.fileList.length - 1) {
					this.openCropper(this.currentFileIndex+1);
				}else{
					for(var i=0;i<this.fileList.length;i++){
						this.defQuestion.fileList.push(
							{
							 url: this.fileList[i]
						   })
					}
					this.fileList=[],
					this.closeModal();
				}
				
			}
		  }
		},
		// handleInput(event) {
		//   this.$emit('update:modelValue', Number(event.target.value));
		// }
		initRuler() {
			const ruler = document.getElementById('ruler');
			this.rulerWidth = ruler.offsetWidth;
			
			// 初始位置设为0，确保0刻度对准指针
			this.setValue(0);
		},
		bindEvents() {
			const ruler = document.getElementById('ruler');
			const wrapper = document.getElementById('rulerWrapper');
			
			// 触摸开始
			ruler.addEventListener('touchstart', function(e) {
				this.isDragging = true;
				this.startX = e.touches[0].pageX;
				// 拖动开始时移除过渡效果，使拖动更跟手
				wrapper.style.transition = 'none';
				e.preventDefault();
			}.bind(this), { passive: false });
			
			// 触摸移动
			ruler.addEventListener('touchmove', function(e) {
				if (!this.isDragging) return;
				
				const moveX = e.touches[0].pageX - this.startX;
				this.wrapperTranslateX += moveX;
				this.startX = e.touches[0].pageX;
				
				// 计算当前值
				const offset = -this.wrapperTranslateX / this.scaleWidth;
				this.currentValue = Math.round(offset);
				
				// 限制范围
				if (this.currentValue < -45) {
					this.currentValue = -45;
					this.wrapperTranslateX = 45 * this.scaleWidth;
				} else if (this.currentValue > 45) {
					this.currentValue = 45;
					this.wrapperTranslateX = -45 * this.scaleWidth;
				}
				
				e.preventDefault();
			}.bind(this), { passive: false });
			
			// 触摸结束
			ruler.addEventListener('touchend', function() {
				this.isDragging = false;
				// 恢复过渡效果
				wrapper.style.transition = 'transform 0.3s ease-out';
				// 滑动结束后吸附到最近的刻度
				this.setValue(this.currentValue);
			}.bind(this));
			
			// 鼠标事件（用于PC端测试）
			ruler.addEventListener('mousedown', function(e) {
				this.isDragging = true;
				this.startX = e.pageX;
				wrapper.style.transition = 'none';
				e.preventDefault();
			}.bind(this),{ passive: false });
			
			document.addEventListener('mousemove', function(e) {
				if (!this.isDragging) return;
				
				const moveX = e.pageX - this.startX;
				this.wrapperTranslateX += moveX;
				this.startX = e.pageX;
				
				// 计算当前值
				const offset = -this.wrapperTranslateX / this.scaleWidth;
				this.currentValue = Math.round(offset);
				
				// 限制范围
				if (this.currentValue < -45) {
					this.currentValue = -45;
					this.wrapperTranslateX = 45 * this.scaleWidth;
				} else if (this.currentValue > 45) {
					this.currentValue = 45;
					this.wrapperTranslateX = -45 * this.scaleWidth;
				}
				
				e.preventDefault();
			}.bind(this));
			
			document.addEventListener('mouseup', function() {
				this.isDragging = false;
				wrapper.style.transition = 'transform 0.3s ease-out';
				// 滑动结束后吸附到最近的刻度
				this.setValue(this.currentValue);
			}.bind(this));
		},
		setValue(value) {
			// 限制范围
			value = Math.max(-45, Math.min(45, value));
			this.currentValue = value;
			
			// 计算wrapper应该移动到的位置
			this.wrapperTranslateX = -value * this.scaleWidth;
		},
		getScaleLineClass(scale) {
			if (scale % 10 === 0) return 'long';
			if (scale % 5 === 0) return 'medium';
			return 'short';
		},
		changeDragMode: function(){
			console.log("589");
			this.cropper.setDragMode(!this.isCropMode?'crop':'move');
		}
		
		
	}
	
})
//查询当前作业的题数据
function Config() {
	
	vm.examNum=examNum;
	vm.gradeNum=gradeNum;
	vm.subjectNum=subjectNum;
	vm.examPaperNum=examPaperNum;
	vm.stageId=stageId;
	vm.startTime=startTime;
	vm.overTime=overTime;
	vm.tijiaoCount=tijiaoCount;
	vm.tijiaoStatus=tijiaoStatus;
	vm.cepingName=zyName;
	vm.picUrl=$.getPicUrl();
	//判断当前学生是否有提交过数据
	if(tijiaoCount==0){//没有提交过，添加第一次需要添加的数据如reg表之类的
		var url = $.getUrl() +'/zaixianceping!insertStudentCepingData.action';
		$.newAjax({
			url: url,
			timeout: 10000,
			async: true,
			data: {
				exampaperNum: examPaperNum,
				examNum: examNum,
				gradeNum:gradeNum,
				subjectNum:subjectNum,
				studentId: plus.storage.getItem("studentid"),
			},
			success: function(res) {
				getCepingPaperQuestions();
			},error:function(XMLHttpRequest, textStatus, errorThrown){
				mui.alert("获取题信息失败："+textStatus);
		   }
		});
		
	}else{
		getCepingPaperQuestions();
	}

}

//查询需要测评的作业的题信息
function getCepingPaperQuestions(){
	$.newAjax({
		url: $.getUrl() +'/zaixianceping!getCepingPaperQuestions.action',
		data: {
			examPaperNum: examPaperNum,
			examNum: examNum,
			subjectNum:subjectNum,
			stageId:stageId,
			studentId: plus.storage.getItem("studentid"),
		},
		success: function(res) {
			
			if(res.code=='200'){
				vm.tiList=res.data;
				vm.defQuestion=vm.tiList[0];
				vm.defQuestionIndex=0;
				if(vm.defQuestion.questionType=='0'){
					if(vm.defQuestion.submitStatus=='1'){
						
						if(vm.defQuestion.myanswer==''){
							vm.myanswer="1";
						}else{
							vm.myanswer="";
						}
					}
				}
			}else{
				vm.tiList=[];
				vm.defQuestion=[];
				vm.defQuestionIndex='';
			}
			
			
		},error:function(XMLHttpRequest, textStatus, errorThrown){
			mui.toast("查题失败，请联系管理员："+textStatus);
	   }
	});
}

//上一题
function pre(){
	if(vm.defQuestionIndex=='0'){//已经是第一题了
		mui.toast("已经是第一题了");
	}else{
		if(vm.defQuestion.questionType=='1'){//主观题
			if(vm.defQuestion.fileList!=''){
				mui.alert("T"+vm.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
				return;
			}
		}
		// vm.defQuestion=vm.tiList[i];
		// vm.defQuestionIndex=i;
		vm.defQuestion=vm.tiList[vm.defQuestionIndex-1];
		vm.defQuestionIndex=vm.defQuestionIndex-1;
		vm.selectedFiles=[];
		vm.uploading=false;
		if(vm.defQuestion.questionType=='0'){//客观题
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.myanswer==''){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}else{
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.mergedImage==undefined){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}
		this.$nextTick(function() {
			this.scrollToTiItem(this.defQuestionIndex); // 调用方法
		}.bind(this));
		scroll();
		vm.expanded=true;
		vm.expanded2=true;
	}
}

//下一题
function next(){
	if(vm.defQuestionIndex==(vm.tiList.length-1)){//已经是第一题了
		mui.toast("已经是最后一题了");
	}else{
		if(vm.defQuestion.questionType=='1'){//主观题
			if(vm.defQuestion.fileList!=''){
				mui.alert("T"+vm.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
				return;
			}
		}
		vm.defQuestion=vm.tiList[vm.defQuestionIndex+1];
		vm.defQuestionIndex=vm.defQuestionIndex+1;
		vm.selectedFiles=[];
		vm.uploading=false;
		if(vm.defQuestion.questionType=='0'){//客观题
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.myanswer==''){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}else{
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.mergedImage==undefined){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}
		this.$nextTick(function() {
				this.scrollToTiItem(this.defQuestionIndex); // 调用方法
		}.bind(this));
		scroll();
		vm.expanded=true;
		vm.expanded2=true;
	}
}

function scroll(){
	var mainDiv = document.querySelector('.tigan');
	mainDiv.scrollTo({
		top: 0,
		behavior: 'smooth'
	});
}

function tijiao(item,mergedImage){
	
	//首先判断当前时间是否大于测评起始时间
	var nowDate=new Date()

	if(nowDate>vm.overDate){//当前时间大于终止时间，测评时间结束
		mui.toast("已过测评时间,无法提交");
		return;
	}

	if(vm.tijiaoStatus=='1'){
		mui.toast("全卷已经提交过了,不可修改");
		return;
	}
	
	if(vm.defQuestion.questionType=='0'){//客观题

		var myanswer2='';
		if(vm.defQuestion.multiple=='0'){//单选题
			myanswer2=vm.defQuestion.myanswer;
		}else{//多选题

			for(var i=0;i<vm.defQuestion.myanswer.length;i++){
				if(vm.defQuestion.myanswer[i]!='1'){
					myanswer2+=vm.defQuestion.myanswer[i];
				}else{
					break;
				}
			}
			
		}
		//提交题
		$.newAjax({
			url: $.getUrl() +'/zaixianceping!updateObjectiveScore.action',
			data: {
				myanswer:myanswer2,
				scoreId:vm.defQuestion.scoreId,
				questionNum:vm.defQuestion.questionNum,
				pid:vm.defQuestion.pid,
				overTime:overTime,
				buhuizuo:item,
				studentId: plus.storage.getItem("studentid"),
			},
			success: function(res) {
				if(res.code=='200'){
					if(item=='1'){
						vm.defQuestion.submitStatus='1';
					}else{
						if(myanswer2==''){
							vm.defQuestion.submitStatus='0';
						}else{
							vm.defQuestion.submitStatus='1';
						}
					}
				}else{
					mui.toast("上传答案失败，请联系管理员"+res.msg);
				}
			},error:function(XMLHttpRequest, textStatus, errorThrown){
				mui.toast("上传答案失败，请联系管理员："+textStatus);
		   }
		});
			
		
	}else if(vm.defQuestion.questionType=='1'){//主观题
		//上传合并压缩后的图片
		var formData = new FormData();
		formData.append("examNum",vm.examNum);
		formData.append("scoreId",vm.defQuestion.scoreId);
		formData.append("questionNum",vm.defQuestion.questionNum);
		formData.append("examPaperNum",vm.examPaperNum);
		formData.append("studentId",plus.storage.getItem("studentid"));
		formData.append("overTime",overTime);
		formData.append("mergedImageBase64",mergedImage);
		if(item=='1'){//主观题不会做
			formData.append("answerStatus","1");
			vm.uploading2=true;
		}
		
		axios({
			url:$.getUrl() +'/zaixianceping!uploadScoreImg.action',
			method:'post',
			data:formData,
			headers: {
				'Content-Type': 'multipart/form-data' // 必须设置
			},
		}).then(function (res){
			var msgRes = res.data;
			if(msgRes.code==200){
				vm.uploading=false;
				vm.defQuestion.submitStatus='1';
				vm.defQuestion.fileList=[];
				vm.rotations={};
				if(item=='1'){
					vm.defQuestion.mergedImage=null;
					vm.uploading2=false;
				}else{
					 vm.myanswer='';
					vm.defQuestion.mergedImage=mergedImage;
				}
				mui.toast("上传成功！");
			}else{
				vm.uploading=false;
				mui.alert(msgRes.msg);
				return;
			}
		});
	}
	
}

function tijiaoAll(){
	
	if(vm.tijiaoStatus=='1'){
		// mui.toast("全卷已经提交过了,只能提交一次");
		return;
	}
	
	var btnArray = ['取消', '确定'];
	mui.confirm('确定要提交全卷吗?(未保存答案的题或为上传的题,不会自动保存,请仔细检查)', '提示', btnArray, function(e) { 
		if(e.index == 1) {//确定
		
			//首先判断当前时间是否大于测评起始时间
			var now = new Date();
			
			// 获取年、月、日、时、分、秒
			var year = now.getFullYear();
			var month = String(now.getMonth() + 1).padStart(2, '0'); // 月份补零
			var day = String(now.getDate()).padStart(2, '0'); // 日期补零
			var hours = String(now.getHours()).padStart(2, '0');
			var minutes = String(now.getMinutes()).padStart(2, '0');
			
			
			var date=year+"-"+month+"-"+day;
			var time=hours+":"+minutes;
			if(date+" "+time>vm.overTime){//当前时间大于终止时间,不可以提交
				mui.toast("已过测评时间,无法提交");
				return;
			}
			
			if(vm.tijiaoStatus=='1'){
				mui.toast("全卷已经提交过了,只能提交一次");
				return;
			}
			
			var isNoUpload='';
			for(var i=0;i<vm.tiList.length;i++){
				var submitStatus=vm.tiList[i].submitStatus;
				if(submitStatus=='0'){//有题没有提交，
					if(i==vm.tiList.length-1){
						isNoUpload+='T'+vm.tiList[i].questionName;
					}else{
						isNoUpload+='T'+vm.tiList[i].questionName+"、";
					}
					
				}
			}
			if(isNoUpload==''){
				$.newAjax({
					url: $.getUrl() +'/zaixianceping!tijiaoQuanJuan.action',
					data: {
						examPaperNum: examPaperNum,
						examNum: examNum,
						overTime:overTime,
						studentId: plus.storage.getItem("studentid"),
					},
					success: function(res) {
						if(res.code=='200'||res.code=='201'){
							vm.tijiaoStatus='1';
							mui.openWindow({
								id: 'tijiaoQuanJuan',
								url: 'tijiaoQuanJuan.html',
								show: {
									aniShow: 'pop-in'
								},
								waiting: {
									autoShow: true, //自动显示等待框，默认为true
								}
							});
							// mui.toast("提交全卷成功");
							return;
					
						}else{
							mui.toast("提交全卷失败，请联系管理员"+res.msg);
							return;
						}
					},error:function(XMLHttpRequest, textStatus, errorThrown){
						mui.toast("提交全卷失败，请联系管理员"+textStatus);
						return;
				   }
				});
						
				
			}else{
				mui.alert(isNoUpload+"没有做或未提交，请先提交后再提交整卷！");
				return;
			}
		}
	})
}

