var bodyWidth = window.screen.width;
var nowwidth = bodyWidth * 4 / 15;
var byId = function(id) {
	return document.getElementById(id);
};

var getOptionSchool = function(chartType) {
	var chartOption;
	if(chartType == 'bar') { //学科均衡性--柱状图
		chartOption = {
			legend: {
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				},
				data: ['']
			},
			grid: [{
				bottom: 5 * 0.12 * nowwidth,
				right: 4 * 0.12 * nowwidth
			}],
			tooltip: {
				textStyle: {
					fontSize: 0.14 * nowwidth,
					lineHeight:0.14 * nowwidth
				}
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				name: '科目',
				gridIndex: 0,
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.005 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitArea: { // 图表背景网格的颜色
					show: true,
					areaStyle: {
						color: ["#F0F5F9", '#FAFAFA']
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle: {
						width: 0.01 * nowwidth
					}
				},

				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					align: 'center',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
			}],
			yAxis: [{
				type: 'value',
				gridIndex: 0,
				axisLine: {
					show: false
				},
				/*隐藏横坐标的线*/
				name: '百分比',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.005 * nowwidth
					}
				},
				axisLabel: {
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				scale: true
			}],
			series: [{
				name: '',
				type: 'bar',
				barWidth: 0.15 * nowwidth,
				data: [
					//2.0, 4.9, 7.0, 23.2, 25.6, 76.7, 135.6, 162.2, 32.6
				]
			}]
		};
		return chartOption;
	}
	if(chartType == 'bar1') { //总分分段统计-柱状图

		chartOption = {
			legend: {
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				},
				data: ['']
			},
			color: [''],
			grid: [{
				bottom: 5 * 0.12 * nowwidth,
				right: 4 * 0.12 * nowwidth
			}],
			tooltip: {
				textStyle: {
					fontSize: 0.14 * nowwidth
				}
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				name: '(分数)',
				gridIndex: 0,
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitArea: { // 图表背景网格的颜色
					show: true,
					areaStyle: {
						color: ["#F0F5F9", '#FAFAFA']
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle: {
						width: 0.01 * nowwidth
					}
				},

				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					margin: 5 * 0.12 * nowwidth,
					rotate: 90,
					align: 'left',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
			}],
			yAxis: [{
				type: 'value',
				gridIndex: 0,
				axisLine: {
					show: false
				},
				/*隐藏横坐标的线*/
				name: '(人数)',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				axisLabel: {
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				scale: true
			}],
			series: [{
				name: '',
				type: 'bar',
				barWidth: 0.15 * nowwidth,
				data: [
					//2.0, 4.9, 7.0, 23.2, 25.6, 76.7, 135.6, 162.2, 32.6
				],
				markPoint: {
					symbolSize: 0.35 * nowwidth,
					data: [{}, ],
					itemStyle: {
						normal: {
							color: '#FF9132'
						}
					},
					label: {
						fontSize: 0.10 * nowwidth
					}
				}
			}]
		};
		return chartOption;
	}
	if(chartType == 'bar2') { //进退步检测-柱状图
		chartOption = {
			tooltip: {
				//trigger: 'axis'
				textStyle: {
					fontSize: 0.14 * nowwidth
				}
			},
			color: ['#FF9132', '#B4E04F', '#C3E0FE', '#B6A2DE'],
			/*图例颜色*/
			legend: {
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				},
				data: ['']
			},
			grid: [{
				bottom: 5 * 0.12 * nowwidth,
				right: 4 * 0.12 * nowwidth
			}],
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				name: '科目',
				gridIndex: 0,
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitArea: { // 图表背景网格的颜色
					show: true,
					areaStyle: {
						color: ["#F0F5F9", '#FAFAFA']
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle: {
						width: 0.01 * nowwidth
					}
				},

				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					align: 'center',
					margin: 5 * 0.12 * nowwidth,
					rotate: 90,
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
			}],
			yAxis: [{
				type: 'value',
				gridIndex: 0,
				axisLine: {
					show: false
				},
				/*隐藏横坐标的线*/
				name: '标准分',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				axisLabel: {
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				scale: true
			}],
			series: [{
				name: '',
				type: 'bar',
				barWidth: 0.15 * nowwidth,
				data: [
					//2.0, 4.9, 7.0, 23.2, 25.6, 76.7, 135.6, 162.2, 32.6
				]
			}]
		};
		return chartOption;
	}
	if(chartType == 'pie') { //我的分数--饼状图
		chartOption = {
			title: {
				show: true, //显示策略，默认值true,可选为：true（显示） | false（隐藏）
				text: '', //主标题文本，'\n'指定换行
				x: 'center', //水平安放位置，默认为'left'，可选为：'center' | 'left' | 'right' | {number}（x坐标，单位px）
				y: 'center', //垂直安放位置，默认为top，可选为：'top' | 'bottom' | 'center' | {number}（y坐标，单位px）
				backgroundColor: 'rgba(0,0,0,0)', //标题背景颜色，默认'rgba(0,0,0,0)'透明
				borderColor: '#ccc', //标题边框颜色,默认'#ccc'
				borderWidth: 0, //标题边框线宽，单位px，默认为0（无边框）
				padding: 0.05 * nowwidth, //标题内边距，单位px，默认各方向内边距为5，接受数组分别设定上右下左边距
				textStyle: {
					color: '#ffffff',
					fontSize: 0.14 * nowwidth,
				},
			},
			legend: {
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				}
			},
			tooltip: {
				trigger: 'item',
			},
			color: ['rgba(255,255,255,0.8)', 'rgba(141,233,246,1)'],
			/*图例颜色*/
			/*calculable : true,*/
			/*是否现在边框*/
			series: [{
				name: '访问来源',
				type: 'pie',
				radius: ['80%', '85%'],
				avoidLabelOverlap: true,
				itemStyle: { /*引导线*/
					normal: {
						label: {
							show: true,
							position: 'center',
							textStyle: {
								fontSize: 0.70 * nowwidth,
								color: '#ffffff'
							},
							formatter: function(params) {
								return total;
							},
						},
						labelLine: {
							show: false,
						}
					},
				},
				data: [{
						value: ''
					},
					{
						value: ''
					},
				]
			}]
		};
		return chartOption;
	}
	if(chartType == 'radar') { //学科均衡性--雷达图
		chartOption = {
			tooltip: {
				trigger: 'axis',
				showDelay: 0,
				hideDelay: 2000,
				transitionDuration: 0,
				borderRadius: 0.08 * nowwidth,
				borderWidth: 0.02 * nowwidth,
				// padding: 0.10 * nowwidth,
				textStyle: {
					fontSize: 0.14 * nowwidth
				}
			},
			/*color:['rgba(255, 145, 50, 1)','rgba(180, 244, 79, 1)'],*/
			/*图例颜色*/
			color: ['#F68C32', '#AEDE54'],
			/*图例颜色*/
			legend: {
				// orient: 'vertical',
				// x: 'left',
				// y: 'top',
				// itemWidth: 0.25 * nowwidth,
				// itemHeight: 0.14 * nowwidth,
				position: 'center',
				itemGap:60,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				},
				selected: {
				  '校超越率': true,
				  '区超越率': false,
				},
				data: []
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: false
					},
					dataView: {
						show: false,
						readOnly: false
					},
					restore: {
						show: false
					},
					saveAsImage: {
						show: false
					}
				}
			},
			radar: [{
					name: {
						color: '#000000', // 工艺等文字颜色
						fontSize: 0.12 * nowwidth,
						lineHeight: 0.12 * nowwidth
					},
					nameGap: 0.01 * nowwidth,
					center: ['50%', '50%'],
					axisLine: {
						lineStyle: {
							width: 0.01 * nowwidth
						}
					},
					splitLine: {
						lineStyle: {
							width: 0.01 * nowwidth
						}
					},
					// radius:90,
					indicator: []
				}

			],
			calculable: false,
			series: [{
				name: '',
				type: 'radar',
				tooltip: {
					trigger: 'item'
				},
				symbolSize: 0.04 * nowwidth,

				data: [{
						value: [],
						name: '',
						areaStyle: {
							color: "rgba(255, 145, 50, 0.3)" // 图表中各个图区域的颜色
						}
					},
					{
						value: [],
						name: '',
						areaStyle: {
							color: "rgba(180, 244, 79, 0.3)" // 图表中各个图区域的颜色

						}
					}
				]
			}]
		}
		return chartOption;
	}
	if(chartType == 'radar1') { //学科均衡性--雷达图
		chartOption = {
			tooltip: {
				trigger: 'axis',
				showDelay: 0,
				hideDelay: 2000,
				transitionDuration: 0,
				borderRadius: 0.08 * nowwidth,
				borderWidth: 0.02 * nowwidth,
				padding: 0.10 * nowwidth,
				textStyle: {
					fontSize: 0.14 * nowwidth
				}
			},
			/*color:['rgba(255, 145, 50, 1)','rgba(180, 244, 79, 1)'],*/
			/*图例颜色*/
			color: ['#F68C32', '#AEDE54'],
			/*图例颜色*/
			legend: {
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth
				},
				itemGap:60,
				data: []
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: false
					},
					dataView: {
						show: false,
						readOnly: false
					},
					restore: {
						show: false
					},
					saveAsImage: {
						show: false
					}
				}
			},
			radar: [{
					name: {
						color: '#000000', // 工艺等文字颜色
						fontSize: 0.12 * nowwidth,
						lineHeight: 0.12 * nowwidth
					},
					nameGap: 0.01 * nowwidth,
					center: ['50%', '50%'],
					axisLine: {
						lineStyle: {
							width: 0.01 * nowwidth
						}
					},
					splitLine: {
						lineStyle: {
							width: 0.01 * nowwidth
						}
					},
					radius:90,
					indicator: []
				}

			],
			calculable: false,
			series: [{
				name: '',
				type: 'radar',
				tooltip: {
					trigger: 'item'
				},
				symbolSize: 0.04 * nowwidth,

				data: [{
					value: [],
					name: '',
					areaStyle: {
						color: "rgba(255, 145, 50, 0.3)" // 图表中各个图区域的颜色
					}
				}]
			}]
		}
		return chartOption;
	}
	if(chartType == 'line') { //成绩对比--折线图
		chartOption = {
			legend: {
				data: [],
				/*bottom:200*/
				/*图例和底部的距离 */
				/*padding:[10,0 ,100,0]*/
				x: 'right',
				y: 'top',
				itemWidth: 0.19 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth,
					color: '#7C7C7C'
				},
				orient: 'horizontal',
				padding: 0.02 * nowwidth,
				itemGap: 0.01 * nowwidth,
			},
			color: ['#FF9132', '#C3E0FE', '#B4E04F'],
			/*图例颜色*/
			grid: [{
				top: "22%",
				right: 4 * 0.12 * nowwidth
			}],
			tooltip: {
				trigger: 'axis',
				borderRadius: 0.10 * nowwidth,
				padding: 0.10 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth
				},
				//强制去掉tooltip的overflow
				position: function (point, params, dom, rect, size) {
					dom.style.transform = "translateZ(0)";
				},
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				name: '(科目)',
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitArea: { // 图表背景网格的颜色
					show: true,
					areaStyle: {
						color: ['#FAFAFA', "#F0F5F9"]
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle:{
						width:0.01*nowwidth
					}
				},
				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				boundaryGap: false,
				/*汉字和坐标轴对齐*/
			}],
			yAxis: [{
				type: 'value',
				name: '(分数)',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				scale: true /*纵坐标自适应*/
			}],
			series: [{
				name: '',
				type: 'line',
				data: [],
				smooth: false,
				symbolSize: 0.04 * nowwidth,
				lineStyle: {
					width: 0.02 * nowwidth,
				},
				/*线圆滑*/
				symbol: 'emptyCircle'

			}, {
				name: '',
				type: 'line',
				symbol: 'emptyCircle',
				symbolSize: 0.04 * nowwidth,
				lineStyle: {
					width: 0.02 * nowwidth,
				},
				data: [],
				smooth: false,
			}, {
				name: '',
				type: 'line',
				symbol: 'emptyCircle',
				symbolSize: 0.04 * nowwidth,
				lineStyle: {
					width: 0.02 * nowwidth,
				},
				data: [],
				smooth: false,
			}],
		};
		return chartOption;
	}

	if(chartType == 'line1') { //总分分段统计--折线图
		chartOption = {
			legend: {
				data: [],
				x: 'right',
				y: 'top',
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth,
					color: '#7C7C7C'
				},
				orient: 'horizontal',
				padding: 0.05 * nowwidth,
				itemGap: 0.10 * nowwidth
			},
			grid: [{
				top: "18%",
				right: 4 * 0.12 * nowwidth
			}],
			tooltip: { // Option config. Can be overwrited by series or data
				trigger: 'item',
				showDelay: 0,
				hideDelay: 50,
				transitionDuration: 0,
				borderRadius: 0.08 * nowwidth,
				borderWidth: 0.02 * nowwidth,
				padding: 0.10 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth
				},
				position: function(p) {
					// 位置回调
					return [p[0] + 10, p[1] - 10];
				},
				formatter: function(params, ticket, callback) {
					if(params.name == "您的位置") {
						return '您的位置';
					} else {
						var res = "";
						res = "分数段：" + params.name + "<br/>"
						res += "累计人数：" + params.value;
						return res;
					}
				}
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				name: '分数段',
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitArea: { // 图表背景网格的颜色
					show: true,
					areaStyle: {
						color: ['#FAFAFA', "#F0F5F9"]
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle:{
						width:0.01*nowwidth
					}
				},
				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					margin: 5 * 0.12 * nowwidth,
					rotate: 90,
					align: 'left',
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				boundaryGap: false,
				/*汉字和坐标轴对齐*/
			}],
			yAxis: [{
				type: 'value',
				name: '累计人数',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				scale: true /*纵坐标自适应*/
			}],
			series: [{
				name: '',
				type: 'line',
				symbolSize: 0.04 * nowwidth,
				lineStyle: {
					width: 0.02 * nowwidth,
				},
				data: [],
				markPoint: {
					symbolSize: 0.35 * nowwidth,
					data: [{}, ],
					label: {
						fontSize: 0.10 * nowwidth
					}
				}
			}],
		};
		return chartOption;
	}

	if(chartType == 'line2') { //进退步检测--折线图
		chartOption = {
			legend: {
				x: 'right',
				y: 'center',
				data: [],
				itemWidth: 0.25 * nowwidth,
				itemHeight: 0.14 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth,
					lineHeight: 0.12 * nowwidth,
					color: '#7C7C7C'
				},
				type:"scroll",
				orient:'vertical',
				padding: 0.05 * nowwidth,
				itemGap: 0.10 * nowwidth
			},
			grid: [{
				right: "22%",
				// bottom: 0
			}],
			tooltip: { // Option config. Can be overwrited by series or data
				trigger: 'item',
				showDelay: 0,
				hideDelay: 2000,
				transitionDuration: 0,
				borderRadius: 0.08 * nowwidth,
				borderWidth: 0.02 * nowwidth,
				padding: 0.10 * nowwidth,
				textStyle: {
					fontSize: 0.12 * nowwidth
				},
				position: function(p) {
					// 位置回调
					return [p[0] + 10, p[1] - 10];
				},
				formatter: function(params, ticket, callback) {
					var res = "考试：";
					var paramName = params.name;
					if(paramName.length > 20) {
						paramName = paramName.substring(0, 20) + "<br/>" + paramName.substring(20, paramName.length);
					}
					res += paramName + "<br/>";
					console.log(JSON.stringify(params));
					res += "科目：" + params.seriesName + "<br/>";
					res += "标准分：" + params.value;
					return res;
				}
			},
			toolbox: {
				show: false,
				feature: {
					mark: {
						show: true
					},
					dataView: {
						show: true,
						readOnly: false
					},
					magicType: {
						show: true,
						type: ['line', 'bar']
					},
					restore: {
						show: true
					},
					saveAsImage: {
						show: true
					}
				}
			},
			calculable: false,
			xAxis: [{
				type: 'category',
				data: [],
				nameTextStyle: { /*横坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*横坐标轴线*/
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				/*隐藏横坐标的线*/
				axisTick: { /*横坐标刻度线*/
					show: false,
				},
				splitLine: { // 图表背景网格线的颜色
					show: false,
					lineStyle:{
						width:0.01*nowwidth
					}
				},
				axisLabel: {
					show: true,
					align: 'center',
					interval: 0,
					rotate: 0,
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					},
					// formatter: function(params) {
					// 	//xHuanHang(params);
					// 	var newParamsName = ""; // 最终拼接成的字符串
					// 	var paramsNameNumber = params.length; // 实际标签的个数
					// 	var provideNumber = 4; // 每行能显示的字的个数
					// 	var rowNumber = Math.ceil(paramsNameNumber / provideNumber); // 换行的话，需要显示几行，向上取整
					// 	/**
					// 	 * 判断标签的个数是否大于规定的个数， 如果大于，则进行换行处理 如果不大于，即等于或小于，就返回原标签
					// 	 */
					// 	// 条件等同于rowNumber>1
					// 	if(paramsNameNumber > provideNumber) {
					// 		/** 循环每一行,p表示行 */
					// 		for(var p = 0; p < rowNumber; p++) {
					// 			var tempStr = ""; // 表示每一次截取的字符串
					// 			var start = p * provideNumber; // 开始截取的位置
					// 			var end = start + provideNumber; // 结束截取的位置
					// 			// 此处特殊处理最后一行的索引值
					// 			if(p == rowNumber - 1) {
					// 				// 最后一次不换行
					// 				tempStr = params.substring(start, paramsNameNumber);
					// 			} else {
					// 				// 每一次拼接字符串并换行
					// 				tempStr = params.substring(start, end) + "\n";
					// 			}
					// 			newParamsName += tempStr; // 最终拼成的字符串
					// 		}

					// 	} else {
					// 		// 将旧标签的值赋给新标签
					// 		newParamsName = params;
					// 	}
					// 	//将最终的字符串返回
					// 	return newParamsName;
					// }
				},
				/* boundaryGap:false*/
			}],
			yAxis: [{
				type: 'value',
				nameTextStyle: { /*纵坐标名称样式*/
					color: '#48C6FF',
					fontSize: 0.12 * nowwidth
				},
				axisLine: { /*纵坐标坐标颜色*/
					show: true,
					lineStyle: {
						width: 0.01 * nowwidth
					}
				},
				splitLine: { // 图表背景网格线的颜色
					show: true,
					lineStyle: {
						color: '#DCDCDC',
						width: 0.01 * nowwidth
					}
				},
				axisLabel: { /*横坐标标签颜色*/
					show: true,
					interval: 0,
					color: '#000000',
					textStyle: {
						fontSize: 0.12 * nowwidth
					}
				},
				scale: true /*纵坐标自适应*/
			}],
			series: [{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					// symbolSize: 40px,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.04 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				},
				{
					name: '',
					type: 'line',
					symbol: 'emptyCircle',
					symbolSize: 0.08 * nowwidth,
					lineStyle: {
						width: 0.02 * nowwidth,
					},
					data: []
				}
			],
		};
		return chartOption;
	}
}
/*var colorList = ['#C1232B','#C1232B','#C1232B','#C1232B','#27727B','#C1232B','#C1232B','#C1232B','#C1232B','#60C0DD',
					'#C1232B','#C1232B','#F4E001','#C1232B','#26C0C0'
					];*/