document.addEventListener('DOMContentLoaded', function() {
    // 获取sessionStorage中的图片数据
	// var imagesData = plus.webview.currentWebview().imagesToCrop;
    var imagesData = JSON.parse(sessionStorage.getItem('imagesToCrop'));
    var currentImageIndex = 0;
    var cropper;
    var croppedImages = [];
    
    // 初始化UI
    var imageElement = document.getElementById('image-to-crop');
    var prevBtn = document.getElementById('prev-btn');
    var nextBtn = document.getElementById('next-btn');
    var cropBtn = document.getElementById('crop-btn');
    var finishBtn = document.getElementById('finish-btn');
    var currentImageSpan = document.getElementById('current-image');
    var totalImagesSpan = document.getElementById('total-images');
    
    totalImagesSpan.textContent = imagesData.length;
    
    // 加载当前图片
    function loadImage(index) {
        if (cropper) {
            cropper.destroy();
        }
        
        imageElement.src = imagesData[index].dataUrl;
        currentImageSpan.textContent = index + 1;

		var imgWidth = this.naturalWidth;  // 图片原始宽度
		var imgHeight = this.naturalHeight; // 图片原始高度

		// // 3. 计算适合屏幕的最大尺寸
		// var maxWidth = window.innerWidth * 0.9;  // 屏幕宽度的 90%
		// var maxHeight = window.innerHeight * 0.8; // 屏幕高度的 80%

		// // 4. 按比例缩放图片尺寸
		// var scale = Math.min(
		// 	maxWidth / imgWidth,
		// 	maxHeight / imgHeight
		// );
		// var displayWidth = imgWidth * scale;
		// var displayHeight = imgHeight * scale;

		// // 5. 设置图片显示尺寸
		// this.style.width = displayWidth + 'px';
		// this.style.height = displayHeight + 'px';



        // 初始化Cropper.js
        cropper = new Cropper(imageElement, {
            aspectRatio: imgWidth / imgHeight, // 保持图片原始比例, // 1:1比例，可以根据需要调整 16/9 1/1
            viewMode: 2, //限制裁切框0：无限制 1：不超过画布大小(默认) 2：不超过画布大小，且画布填充为cover 3:不超过画布大小，且画布填充为contain
            autoCropArea: 1,//
            responsive: true,
            preview: '.preview',
			rotatable :true,
			background :false,
			guides :true,
			
			// // 设置画布为图片原始尺寸
			// minCanvasWidth: imagesData[index].width,
			// minCanvasHeight: imagesData[index].height,
			// canvasData: {
			//   width: imagesData[index].width,
			//   height: imagesData[index].height
			// },
			
        });
        
        // 更新导航按钮状态
        prevBtn.disabled = index === 0;
        nextBtn.disabled = index === imagesData.length - 1;
        
        // 如果是最后一张图片，显示完成按钮
        if (index === imagesData.length - 1) {
            finishBtn.style.display = 'block';
            cropBtn.style.display = 'none';
        } else {
            finishBtn.style.display = 'none';
            cropBtn.style.display = 'block';
        }
    }
    
    // 导航按钮事件
    prevBtn.addEventListener('click', function() {
        if (currentImageIndex > 0) {
            currentImageIndex--;
            loadImage(currentImageIndex);
        }
    });
    
    nextBtn.addEventListener('click', function() {
        if (currentImageIndex < imagesData.length - 1) {
            currentImageIndex++;
            loadImage(currentImageIndex);
        }
    });
    
    // 裁切按钮事件
    cropBtn.addEventListener('click', function() {
        // 获取裁切后的canvas
        var canvas = cropper.getCroppedCanvas({
            width: 800, // 设置裁切后的宽度
            height: 1000, // 设置裁切后的高度
            minWidth: 256,
            minHeight: 256,
            maxWidth: 4096,
            maxHeight: 4096,
            fillColor: '#fff',
            imageSmoothingEnabled: true,
            imageSmoothingQuality: 'high',
        });
        
        // 将canvas转为DataURL并保存
        var croppedDataUrl = canvas.toDataURL('image/jpeg', 0.9);
        croppedImages[currentImageIndex] = {
            name: imagesData[currentImageIndex].name,
            dataUrl: croppedDataUrl
        };
        
        // 转到下一张图片
        if (currentImageIndex < imagesData.length - 1) {
            currentImageIndex++;
            loadImage(currentImageIndex);
        }
    });
    
    // 完成按钮事件
    finishBtn.addEventListener('click', function() {
        // 获取最后一张图片的裁切结果
        var canvas = cropper.getCroppedCanvas({
            width: 800,
            height: 800,
            fillColor: '#fff',
        });
        
        var croppedDataUrl = canvas.toDataURL('image/jpeg', 0.9);
        croppedImages[currentImageIndex] = {
            name: imagesData[currentImageIndex].name,
            dataUrl: croppedDataUrl
        };
        
        // 过滤掉未裁切的图片（如果有）
        var finalCroppedImages = croppedImages.filter(img => img !== undefined);
        
        // 将结果存储到sessionStorage中
        sessionStorage.setItem('croppedImages', JSON.stringify(finalCroppedImages));
        
        // 返回主页面
        window.history.back();
    });
    
    // 初始化加载第一张图片
    loadImage(0);
});