var vueObj = new Vue({
    el: '#all',
    data: {
        param_zyNum:'',
        param_studentId:'',
        paramMap:{},
        data_chengjibaodao:[],
        data_fenduantongji:[],
        data_fazhandongtai:[],
        data_xiaoti:[],
        data_zhishidian:[],
        data_nenglidian:[],
        data_tixing:[],
		switchVal_fenduan:false,
		switchVal_fazhan:false,
		switchVal_xiaoti:false,
		switchVal_zhishidian:false,
		switchVal_nenglidian:false,
		switchVal_tixing:false,
		studentTotalScore:0,
    },
    methods: {
		getBasicInfoOfStudentZuoyeReport:function(){
			var el = this;
			if(el.param_zyNum==''){
				return;
			}
			// 显示等待提示 
			plus.nativeUI.showWaiting(" 正在加载基础信息数据...");
			axios({
			    url: $.getUrl() +'/zyBaogao!getBasicInfoOfStudentZuoyeReport.action',
			    method: 'post',
			    params: {
			        zyNum: el.param_zyNum,
			        studentId: $.getValue('studentid')
			    }
			}).then(function (res) {
			    var resData = res.data;
			    if(resData.code!=200){
			        alert(resData.msg);
			        return;
			    }
			    vueObj.paramMap = resData.data;
			}).then(function (res2) {
			    vueObj.getChengjiOfStudentZuoyeReport();
			}).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
		},
        getChengjiOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载成绩报道...");
            axios({
                url: $.getUrl() +'/zyBaogao!getChengjiOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
				//行转列
                el.data_chengjibaodao = [
					{label:'科目',value:resData.data[0].subjectName},
					{label:'满分',value:resData.data[0].fullScore},
					{label:'得分',value:resData.data[0].totalScore},
					{label:'班级平均分',value:resData.data[0].avg_cla},
					{label:'班级最高分',value:resData.data[0].max_cla},
					{label:'班级排名',value:resData.data[0].rank_cla}
				];
				el.studentTotalScore = resData.data[0].totalScore;
            }).then(function (res2) {
                if(el.data_chengjibaodao==null){
                    return;
                }
                vueObj.getFenduanOfStudentZuoyeReport();
                vueObj.getFazhandongtaiOfStudentZuoyeReport();
                vueObj.getXiaotiOfStudentZuoyeReport();
                vueObj.getZhishidianOfStudentZuoyeReport();
                vueObj.getNenglidianOfStudentZuoyeReport();
                vueObj.getTixingStudentZuoyeReport();
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getFenduanOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载分段统计...");
            axios({
                url: $.getUrl() +'/zyBaogao!getFenduanOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_fenduantongji = resData.data.fenduanMapList;

                var barChartOfFenduan = resData.data.barChartOfFenduan;
                if(barChartOfFenduan!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = barChartOfFenduan.sesiesli;
                    chartParamMap["legends"] = barChartOfFenduan.legends;
                    chartParamMap["categories"] = barChartOfFenduan.categories;
                    chartParamMap["title"] = '';
                    chartParamMap["divContent"] = 'chart_fenduantongji';
                    chartParamMap["boundaryType"] = false;
                    chartParamMap["scale"] = false;
                    chartParamMap["type"] = 'bar';
                    chartParamMap["isPercent"] = '0';
                    chartParamMap["legendShow"] = false;
                    chartParamMap["rotate"] = 45;
                    chartParamMap["xAxisName"] = "分数段";
                    chartParamMap["yAxisName"] = "累计人数";
                    //我的位置气泡
                    // var totalScore = el.data_chengjibaodao[0].totalScore;
                    var myPosition = el.data_fenduantongji.filter(function (obj) {
                        return el.studentTotalScore>=obj.fenshu_start && el.studentTotalScore<obj.fenshu_end;
                    })[0];
                    var markPoint = {
                        label: {
                            show: true, // 显示标签
                            formatter: function() {
                                return '我的位置';
                            },
                            fontSize:8
                        },
                        data:[{
                            coord:[myPosition.fenshuduan_chart,myPosition.leijirenshu]
                        }]
                    };
                    chartParamMap["markPoint"] = markPoint;
                    lineOrBarChartFuncOfZuoye(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getFazhandongtaiOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载发展动态...");
            axios({
                url: $.getUrl() +'/zyBaogao!getFazhandongtaiOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_fazhandongtai = resData.data.fazhandongtaiMapList;

                var lineChartOfFazhandongtai = resData.data.lineChartOfFazhandongtai;
                if(lineChartOfFazhandongtai!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = lineChartOfFazhandongtai.sesiesli;
                    chartParamMap["legends"] = lineChartOfFazhandongtai.legends;
                    chartParamMap["categories"] = lineChartOfFazhandongtai.categories;
                    chartParamMap["title"] = '';
                    chartParamMap["divContent"] = 'chart_fazhandongtai';
                    chartParamMap["boundaryType"] = false;
                    chartParamMap["scale"] = false;
                    chartParamMap["type"] = 'line';
                    chartParamMap["isPercent"] = '0';
                    chartParamMap["legendShow"] = false;
                    chartParamMap["rotate"] = 45;
                    chartParamMap["xAxisName"] = "作业时间";
                    chartParamMap["yAxisName"] = "班级排名";
                    //反向坐标轴
                    chartParamMap["inverse"] = true;
                    lineOrBarChartFuncOfZuoye(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getXiaotiOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载小题诊断...");
            axios({
                url: $.getUrl() +'/zyBaogao!getXiaotiOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_xiaoti = resData.data.xiaotiMapList;

                var lineAndBarChartOfXiaoti = resData.data.lineAndBarChartOfXiaoti;
                if(lineAndBarChartOfXiaoti!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = lineAndBarChartOfXiaoti.sesiesli;
                    chartParamMap["legends"] = lineAndBarChartOfXiaoti.legends;
                    chartParamMap["categories"] = lineAndBarChartOfXiaoti.categories;
                    chartParamMap["title"] = '小题正确率(%)对比图';
                    chartParamMap["divContent"] = 'chart_xiaoti';
                    chartParamMap["boundaryType"] = false;
                    chartParamMap["scale"] = false;
                    chartParamMap["type"] = 'line';
                    chartParamMap["isPercent"] = '1';
                    chartParamMap["legendShow"] = true;
                    chartParamMap["rotate"] = 0;
                    chartParamMap["xAxisName"] = "正确率(%)";
                    chartParamMap["yAxisName"] = "小题";
                    //反向坐标轴
                    chartParamMap["inverse"] = true;
                    //动态计算图形高度，跟表格行对应显示，大于14个小题不做对应，限制最大高度
                    var categoriesLen = chartParamMap["categories"].length;
                    // if(categoriesLen>14){
                    //     $("#chart_xiaoti").height(800);
                    // }else{
                        //图形上grid-top、横坐标轴下刻度高度
                        var height_guding = 50+20;
                        //表格一行的高度
                        var height_tr = 20;
                        $("#chart_xiaoti").height(height_guding+(height_tr*categoriesLen));
                    // }
                    lineOrBarChartFuncOfZuoye_zhuanzhi(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getZhishidianOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载知识点诊断...");
            axios({
                url: $.getUrl() +'/zyBaogao!getZhishidianOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_zhishidian = resData.data.zhishidianMapList;

                var radarChartOfZhishidian = resData.data.radarChartOfZhishidian;
                if(radarChartOfZhishidian!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = radarChartOfZhishidian.sesiesli;
                    chartParamMap["legends"] = radarChartOfZhishidian.legends;
                    chartParamMap["indicator"] = radarChartOfZhishidian.indicator;
                    chartParamMap["title"] = '';
                    chartParamMap["divContent"] = 'chart_zhishidian';
                    chartParamMap["isPercent"] = '1';
                    radarChartFuncOfZuoye(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getNenglidianOfStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载能力点诊断...");
            axios({
                url: $.getUrl() +'/zyBaogao!getNenglidianOfStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_nenglidian = resData.data.nenglidianMapList;

                var radarChartOfNenglidian = resData.data.radarChartOfNenglidian;
                if(radarChartOfNenglidian!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = radarChartOfNenglidian.sesiesli;
                    chartParamMap["legends"] = radarChartOfNenglidian.legends;
                    chartParamMap["indicator"] = radarChartOfNenglidian.indicator;
                    chartParamMap["title"] = '';
                    chartParamMap["divContent"] = 'chart_nenglidian';
                    chartParamMap["isPercent"] = '1';
                    radarChartFuncOfZuoye(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        getTixingStudentZuoyeReport:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在加载题型诊断...");
            axios({
                url: $.getUrl() +'/zyBaogao!getTixingStudentZuoyeReport.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if(resData.code!=200){
                    mui.toast(resData.msg);
                    return;
                }
                el.data_tixing = resData.data.tixingMapList;
                var radarChartOfTixing = resData.data.radarChartOfTixing;
                if(radarChartOfTixing!=null){
                    var chartParamMap = new Map();
                    chartParamMap["sesiesli"] = radarChartOfTixing.sesiesli;
                    chartParamMap["legends"] = radarChartOfTixing.legends;
                    chartParamMap["indicator"] = radarChartOfTixing.indicator;
                    chartParamMap["title"] = '';
                    chartParamMap["divContent"] = 'chart_tixing';
                    chartParamMap["isPercent"] = '1';
                    radarChartFuncOfZuoye(chartParamMap);
                }
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
        //跳转到答题卡页面
        toDatikaImg:function () {
			var el = this;
			if(el.paramMap.zyType=='3'){
				mui.openWindow({
					url: '../zaixianceping/cePingDetail.html',
					id: 'cePingDetail.html',
					extras: {
						examNum:el.paramMap.examNum,
						gradeNum:el.paramMap.gradeNum,
						subjectNum:el.paramMap.subjectNum,
						examPaperNum:el.paramMap.defineStatus,
						stageId:el.paramMap.stage,
						zyName:el.paramMap.zyName,
					}
				});
			}else{
				mui.openWindow({
					url: '../../oneSub/ownPapers/ownPapers.html',
					id: 'ownPapers.html',
					extras: {
						exampaperNum:el.paramMap.defineStatus,
						examName:el.paramMap.zyName,
						subjectName:el.paramMap.subjectName,
						rptSource:'',//暂时不用
						examNum:el.paramMap.examNum,
					}
				});
			}
        },
        //分段统计-自己所在分数段行背景颜色变成红色
        getRowClassName:function({row}) {
            var el = this;
            // var totalScore = el.data_chengjibaodao[0].totalScore;
            if(el.studentTotalScore>=row.fenshu_start && el.studentTotalScore<row.fenshu_end){
                return 'bgColor_red';
            }
            return '';
        },
        //小题、知识点、能力点、题型-得分率差距小于零单元格背景颜色变成红色
        getCellClassName:function ({row, column}) {
            if(column.property=='chaju' && row.chaju<0){
                return 'bgColor_red';
            }
            return '';
        },
        //跳转到原题/答案/我的答案/优秀答案页面
        toYuantiDaanYouxiudaan:function (row) {
			axios({
			    url: $.getUrl()+'/appIndex!getConfiguration.action',
			    method: 'post',
			}).then(function (res) {
			    var examPaperNum = vueObj.paramMap.defineStatus;
				var param_questionName = '';
				var questionList = row.questionList;
				if(questionList){//非小题诊断的，传入多个小题，下一个页面做小题切换
					for(var i=0;i<questionList.length;i++){
						var oneQues = questionList[i];
						param_questionName += oneQues.questionNum + '-' + oneQues.questionName + (oneQues.qtype == '0' ? '(客观题)' : '(主观题)') +',';
					}
					param_questionName = param_questionName.slice(0,-1);
				}else{//小题诊断，只有一个小题
					param_questionName = row.questionNum + '-' + row.questionName + (row.qtype == '0' ? '(客观题)' : '(主观题)');
				}
			    var id = 'JiaoXueZhenDuanQuestionDetail';
			    var url = '../../../html/oneSub/oneSubAnalysis/JiaoXueZhenDuanQuestionDetail.html';
			    mui.openWindow({
			    	id: id,
			    	url: url,
			    	show: {
			    		aniShow: 'pop-in'
			    	},
			    	extras: { //extras里面的就是参数了
			    		examPaperNum: examPaperNum,
			    		configuration:res.data,
			    		questionName: param_questionName
			    	},
			    	waiting: {
			    		autoShow: true, //自动显示等待框，默认为true
			    	}
			    });
			}).catch(function (error) {
				
            });
        },
        //导出报告
        exportStudentReportOfZuoye:function () {
            var el = this;
            var formData = new FormData();
            formData.append("paramMapJson",JSON.stringify(el.paramMap));
			// 显示等待提示
			plus.nativeUI.showWaiting(" 正在下载作业报告...");
            axios({
                url: $.getUrl() +'/zyBaogao!exportStudentReportOfZuoye.action',
                method: 'post',
                data: formData
            }).then(function (res) {
                var resData = res.data;
                if (resData.code != 200) {
                    alert(resData.msg);
                    return;
                }
				plus.runtime.openURL(encodeURI(resData.msg));
                // document.location.href = $("#basePath").val()+resData.msg;
            }).finally(() => {
			    // 无论成功失败都关闭等待框 
			    plus.nativeUI.closeWaiting(); 
			});
        },
		//切换表格和图形
		handleItemChange:function(enabled, paramId, id){
			Vue.set(vueObj.$data,paramId,enabled);
			if(enabled){
				//切换成图形时需要重绘，不然图形的宽度获取不到
				this.$nextTick(function(){
					echarts.init(document.getElementById(id)).resize();
				});
			}
		},
		renderHeader:function(h, { column }){
			return h('span', {
					  domProps: {
						innerHTML: column.label  // 解析HTML标签
					  },
					});
		},
        formatPercentage:function (row, column, cellValue) {
            // 1. 乘以100转换为百分比数值
            var value = parseFloat(cellValue) * 100;

            // 2. 去除小数点后多余的零
            // 方法1: 使用Number.toLocaleString() （自动处理末尾的零）
            return value.toLocaleString(undefined,  { maximumFractionDigits: 10 }) + '%';

            // 方法2: 使用正则表达式去除多余的零
            // return (value.toString().replace(/(\.\d*?[1-9])0+$ |\.0+$/, '$1')) + '%';

            // 方法3: 直接使用Number.toFixed()  + 处理（需指定精度）
            // return parseFloat(value.toFixed(6))  + '%'; // 保留最多6位小数
        }
    },
    mounted:function() {//初始化  created也可以 created是在html渲染之前，mounted是在渲染之后
        // this.getBasicInfoOfStudentZuoyeReport();
    }
});