/**
 * 作业报告-筛选条件
 */

//-----------------------------------------参数配置-------------------------------------
//选中的参数
var params_selected = new Vue({
	data: {
		jp_zyNum:'',
	}
});

//-----------------------------------------联动监听-------------------------------------
params_selected.$watch('jp_zyNum',function(){
	if(params_selected.jp_zyNum==''){
		return;
	}
	if(!plus.webview.currentWebview().isVisible()){//教学单位树加载完成时
		submitData();
	}
},{deep: true});

//-----------------------------------------确定事件-------------------------------------
function submitData() {
	fromMemory = false;
	closeMenu();//公共方法
}


//---------------------------------common--------------------------------------
/**
 * 筛选条件-公共方法
 */

//----------------------------------------------------初始化---------------------------------------------
//作业数据
var zuoye = new Vue({
	el: '#zuoye',
	data: {
		zuoyeList: [],
		zuoyeLimitNum: 8
	},
	methods: {
		loadMore: function(){
		  this.zuoyeLimitNum += 8;
		}
	}
});


//----------------------------------------------------获取数据---------------------------------------------
//作业
function ajaxZuoye(){
	params_selected.jp_zyNum = '';
	zuoye.zuoyeList = [];
	axios({
		url: $.getUrl() +'/zyBaogao!getZuoyeListOfStudentReport.action',
		method: 'post',
		params: {
			studentId: $.getValue('studentid')
		}
	}).then(function (res) {
		var resData = res.data;
		if(resData.code!=200){
			alert(resData.msg);
			return;
		}
		var zuoyeData = resData.data[0];
		if(zuoyeData.length>0){
			setFirstSelected("jp_zyNum",zuoyeData);
			zuoye.zuoyeList = zuoyeData;
		}
	});
}

//----------------------------------------------------监听事件---------------------------------------------
function setSelected(paramId,selectedValue,index){
	if(paramId=='jp_zyNum'){
		plus.storage.setItem("selectedZuoyeIndex",index.toString());
	}
	Vue.set(params_selected.$data,paramId,selectedValue);
}

function setFirstSelected(paramId,objData){
	var isMemory = false;
	var _val = plus.storage.getItem(paramId);
	if(_val!=null&&_val!=''){
		$.each(objData, function(i,obj) {
			if(_val==obj.zyNum){
				plus.storage.setItem("selectedZuoyeIndex",i.toString());
				isMemory = true;
				return false;
			}
		});
	}
	if(!isMemory){
		_val = objData[0].zyNum;
	}
	
	//作业加载更多最大显示条数赋值
	updateZuoyeLimitNum(paramId,plus.storage.getItem("selectedZuoyeIndex"));
	
	Vue.set(params_selected.$data,paramId,_val);
	
}

//作业加载更多最大显示条数赋值
function updateZuoyeLimitNum(paramId,currentZuoyeDataIndex){
	if(paramId=='jp_zyNum'){
		var currentZuoyeIndex = null!=currentZuoyeDataIndex&&currentZuoyeDataIndex>0?Math.ceil(currentZuoyeDataIndex/8)*8:8;
		zuoye.zuoyeLimitNum = currentZuoyeIndex;
	}
}

//----------------------------------------------------确定事件---------------------------------------------
document.getElementById("close-btn").addEventListener('tap',submitData);
		
function closeMenu() {
	plus.nativeUI.closeWaiting();
	//记忆选中的条件
	$.setLocal(params_selected.$data);
	
	mui.fire(main,"getFilterValues",params_selected.$data);
}
		
//----------------------------------------------------页面初始化---------------------------------------------
var main = null;
var changeMemory = false;
var fromMemory = false;
mui.plusReady(function(){
	main = plus.webview.currentWebview().opener();//父级页面
	mui.back = function(){
		mui.fire(main,"swiperight");
	};
	ajaxZuoye();
});

mui.init({
	pullRefresh : {
		container:"#refreshContainer",//下拉刷新容器标识，querySelector能定位的css选择器均可，比如：id、.class等
		down : {
			style:'circle',//必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
			color:'#2BD009', //可选，默认“#2BD009” 下拉刷新控件颜色
			height:'50px',//可选,默认50px.下拉刷新控件的高度,
			range:'100px', //可选 默认100px,控件可下拉拖拽的范围
			offset:'0px', //可选 默认0px,下拉刷新控件的起始位置
			auto: false,//可选,默认false.首次加载自动上拉刷新一次
			callback:function(){
				setTimeout(function(){//定时器，提升用户体验
					ajaxZuoye();
					mui('#refreshContainer').pullRefresh().endPulldownToRefresh(); //完成刷新
				}, 1000);
			} //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
		}
	}
});

//主页面
window.addEventListener('submitData', function(event) {
	submitData();
});

//主页面-记忆
window.addEventListener('getMemory', function(event) {
	getMemory();
});

//非第一次点击导航，默认记忆
function getMemory(){
	console.log("-----------非第一次点击导航，默认记忆");
	//作业加载更多最大显示条数赋值
	updateZuoyeLimitNum('jp_zyNum',plus.storage.getItem("selectedZuoyeIndex"));
	
	// plus.nativeUI.showWaiting();
	changeMemory = true;
	fromMemory = true;
	var methodFlag = true;
	for (var key in params_selected.$data) {
		if(plus.storage.getItem(key)!=null){
			if(params_selected.$data[key]==null){
				methodFlag = false;
			}else if(params_selected.$data[key]!=plus.storage.getItem(key)){
				methodFlag = false;
			}
			Vue.set(params_selected.$data,key,plus.storage.getItem(key));
		}
	}
	// console.log("-----------非第一次点击导航，默认记忆"+methodFlag);
	if(methodFlag){
		submitData();
	}
}