function lineOrBarChartFuncOfZuoye(chartParamMap){
    var sesiesli = chartParamMap.sesiesli;
    var legends = chartParamMap.legends;
    var categories = chartParamMap.categories;
    var title = chartParamMap.title;
    var divContent = chartParamMap.divContent;
    var boundaryType = chartParamMap.boundaryType;
    var scale = chartParamMap.scale;
    var type = chartParamMap.type;
    var isPercent = chartParamMap.isPercent;
    var isMarkLine = chartParamMap.isMarkLine;
    var yAxisParam = chartParamMap.yAxisParam;
    var legendShow = chartParamMap.legendShow;
    var rotate = chartParamMap.rotate;
    var xAxisName = chartParamMap.xAxisName;
    var yAxisName = chartParamMap.yAxisName;
    var markPoint = chartParamMap.markPoint;
    var inverse = chartParamMap.inverse;

    $("#"+divContent).attr('_echarts_instance_','');//已经生成图表的div清除instance属性，不然点击查询再生成会报错
    var myChart = echarts.init(document.getElementById(divContent));  //定义图表容器

    option = {
        title: {
            text: title,
            x: 'center',
            textStyle :	{
                fontSize:10,
            }
        },
        grid:{
            left: 20,
            right: 70,
            bottom: 0,
            top:50,
            containLabel: true//显示全坐标文本，里面图形宽高自适应
        },
        toolbox: {			//工具箱
            show: false, //是否显示工具箱
            feature: {		//启用功能，
                // dataZoom: {//显示区域缩放工具
                //     yAxisIndex: "none"
                // },
                saveAsImage: {
                    show: true ,
                    // title:"下载图片"
                }//保存图片
            },
            orient: "vertical",
            right: 20
        },
        tooltip : {         // Option config. Can be overwrited by series or data
            trigger: 'item',
			confine: true, // 关键配置：限制 tooltip 在图表区域内 
            axisPointer: {            // Use axis to trigger tooltip
                type: type        // 'shadow' as default; can also be 'line' or 'shadow'
            },
            showDelay: 0,
            hideDelay: 50,
            transitionDuration:0,
            borderRadius : 8,
            borderWidth: 2,
            padding: 10,    // [5, 10, 15, 20]
            position : function(p) {
                // 位置回调
                return [p[0] + 10, p[1] - 10];
            },
            formatter: function (params) {
                // trigger=‘axis’  悬浮的时候显示多有图例
                /*
                var percentStr = isPercent=='1'?"%":"";
                var html = '<div style="font-size:14px;color:#666;font-weight:400;line-height:1;">'+params[0].name+'</div>';
                for(var i=0;i<params.length;i++){
                    html += '<div style="margin: 10px 0 0;line-height:1;">'
                                +'<span style="font-size:14px;color:#666;font-weight:400;margin-left:2px">'+params[i].marker+params[i].seriesName+'</span>'
                                +'<span style="float:right;margin-left:20px;font-size:14px;color:#666;font-weight:900">'+params[i].value+percentStr+'</span>'
                                +'<div style="clear:both"></div>'
                    html += "</div>";
                }
                return html;
                 */
                // trigger=‘item’  悬浮的时候只显示多当前图例
                if(params.componentType!='series'){
                    return '';
                }
                var percentStr = isPercent=='1'?"%":"";
                var html = '<div style="font-size:14px;color:#666;font-weight:400;line-height:1;text-align:left;">'+params.name+'</div>';
                    html += '<div style="margin: 10px 0 0;line-height:1;">'
                        +'<span style="font-size:14px;color:#666;font-weight:400;margin-left:2px">'+params.marker+params.seriesName+'</span>'
                        +'<span style="float:right;margin-left:20px;font-size:14px;color:#666;font-weight:900">'+params.value+percentStr+'</span>'
                        +'<div style="clear:both"></div>'
                    html += "</div>";
                return html;
            }
        },
        color: ["#66b1ff","#ff0000", "#87cefa", "#da70d6", "#32cd32", "#6495ed", "#ff69b4", "#ba55d3", "#cd5c5c", "#ffa500", "#40e0d0", "#1e90ff", "#ff6347", "#7b68ee", "#00fa9a", "#ffd700", "#6699FF", "#ff6666", "#3cb371", "#b8860b", "#30e0e0"],
        legend: {
            show:legendShow,
            data: legends,
            x:'center',
            y:'top',
            textStyle:{
                fontSize:9
            },
            padding:[22,5,5,5]
            // orient: 'vertical',
        },
        calculable: false,	//容易搞错的属性，折线图、柱状图是否叠加
        xAxis: [{
            type: 'category',
            name:xAxisName,
            data: categories,
            axisTick:{
                inside:true
            },
            axisLine:{
                onZero:false//是否在另一个轴的 0 刻度上
            },
            axisLabel: {
                padding:0,
                // width:50,
                // overflow:'break',
                // interval:0,//0：强制显示所有的横坐标（可能会重叠）  'auto'：自动，不重叠
                // margin:16,//横坐标文本于轴线的距离（文本倾斜的时候可以调整这个参数让横坐标显示在轴线下）
                rotate: rotate,//文字倾斜角度
                formatter : function(xName){
                //     var newParamsName = "";// 最终拼接成的字符串
                //     var paramsNameNumber = params.length;// 实际标签的个数
                //     var provideNumber = 10;// 每行能显示的字的个数
                //     var rowNumber = Math.ceil(paramsNameNumber / provideNumber);// 换行的话，需要显示几行，向上取整
                //     /**
                //      * 判断标签的个数是否大于规定的个数， 如果大于，则进行换行处理 如果不大于，即等于或小于，就返回原标签
                //      */
                //     // 条件等同于rowNumber>1
                //     if (paramsNameNumber > provideNumber) {
                //         /** 循环每一行,p表示行 */
                //         for (var p = 0; p < rowNumber; p++) {
                //             var tempStr = "";// 表示每一次截取的字符串
                //             var start = p * provideNumber;// 开始截取的位置
                //             var end = start + provideNumber;// 结束截取的位置
                //             // 此处特殊处理最后一行的索引值
                //             if (p == rowNumber - 1) {
                //                 // 最后一次不换行
                //                 tempStr = params.substring(start, paramsNameNumber);
                //             } else {
                //                 // 每一次拼接字符串并换行
                //                 tempStr = params.substring(start, end) + "\n";
                //             }
                //             newParamsName += tempStr;// 最终拼成的字符串
                //         }
                //
                //     } else {
                //         // 将旧标签的值赋给新标签
                //         newParamsName = params;
                //     }
                //     //将最终的字符串返回
                //     return newParamsName
                    if(yAxisParam&&yAxisParam.get("xNameSplitChar")){
                        var xNameArr = xName.split(yAxisParam.get("xNameSplitChar"));//编号-名称
                        xName = xNameArr[0];
                    }

                    return xName;//横坐标只显示编号
                }
            }
        }],
        yAxis: [{
            type: 'value',
            name:yAxisName,
            inverse:inverse,
            nameLocation:inverse?'start':'end',
            minInterval: 1,
            boundaryGap: boundaryType,//x，y轴绑定焦点
            scale:scale,//true自动设置y轴坐标最大最小值，取消0点
            axisTick:{
                inside:true
            },
            axisLine:{
                show:true
            },
            axisLabel: {
                show: true,
                interval: 'auto',
                formatter: '{value}'
            }
        }],
        series: [
            {
                markLine:{},
                markArea:{},
                markPoint:{}
            }
        ]
    };

    if(isPercent=='1'){
        option.yAxis[0].axisLabel.formatter = '{value}%';
    }
    if(yAxisParam){
        if(yAxisParam.get("splitNumber")){
            option.yAxis[0].splitNumber = yAxisParam.get("splitNumber");
        }
        if(yAxisParam.get("min")){
            option.yAxis[0].min = yAxisParam.get("min");
            option.yAxis[0].scale = false;
        }
        if(yAxisParam.get("max")){
            option.yAxis[0].max = yAxisParam.get("max");
            option.yAxis[0].scale = false;
        }
    }
    myChart.setOption(option,true);
    myChart.resize();//重新设置echarts的高度

    option=myChart.getOption();
    for(var i=0;i<legends.length;i++){
        option.series[i]=sesiesli[i];
        if(option.series[i].type=='bar'){
            option.series[i].barMaxWidth = 30;
        }
        if((sesiesli[i].type=="bar"&&sesiesli[i].stack!="total")||legends.length<=1){//只有一个图例的时候折点上显示数据  sesiesli[i].type=="line"&&
            var itemStyle = {
                // normal: {
                    label: {
                        show: true,
                        position: 'inside',
                        formatter: '{c}'
                    }
                // }
            };
            option.series[i]["itemStyle"] = itemStyle;
            if(isPercent=='1'){
                option.series[i].itemStyle.normal.label.formatter = '{c}%';
            }
        }

        if(isMarkLine=='1'){//标线
            var markLine = {
                symbol:'none',//去掉箭头
                silent:true,
                lineStyle:{ //警戒线的样式  ，虚实  颜色
                    type:"solid",//实线
                    color:"red",//颜色
                    width: 2//粗细
                },
                label:{
                    position:'end',
                    formatter:""//线后显示文字
                },
                data: [{
                    name: 'Y 轴值为 0 的水平线',
                    yAxis: 0
                }]
            };
            option.series[i]["markLine"] = markLine;
        }else if(isMarkLine=='2'){//标线区域底色
            var markArea = {
                data: [
                    [{
                        yAxis: -0.2,//起始点
                        itemStyle:{ //控制当前区域样式
                            color:'#FF6464'
                        }
                    },{
                        yAxis: 0.2//结束点
                    }],
                    [{
                        yAxis: 0.2,
                        itemStyle:{ //控制当前区域样式
                            color:'#FFFF00'
                        }
                    },{
                        yAxis: 0.3
                    }]
                ],
                silent: true//不触发鼠标悬浮事件
            };
            option.series[i]["markArea"] = markArea;
        }
        if(markPoint!=undefined){
            option.series[i]["markPoint"] = markPoint;
        }
    }
    myChart.setOption(option);
}