var toolTipHtml = '';

function radarChartFuncOfZuoye(chartParamMap){
    var sesiesli = chartParamMap.sesiesli;
    var legends = chartParamMap.legends;
    var indicator = chartParamMap.indicator;
    var title = chartParamMap.title;
    var divContent = chartParamMap.divContent;
    var isPercent = chartParamMap.isPercent;

    var legendHeight = 70;
	$("#"+divContent).height(300);
	var radarYPosition = '60%';//整个盒子的中间位置

    $("#"+divContent).attr('_echarts_instance_','');//已经生成图表的div清除instance属性，不然点击查询再生成会报错
    var myChart = echarts.init(document.getElementById(divContent));  //定义图表容器

    option = {
        title: {
            text: title,
            x: 'center',
            textStyle :	{
                fontSize:10,
            }
        },
        grid:{
            left: '3%',
            right: '8%',
            bottom: '3%',
            containLabel: true
        },
        toolbox: {			//工具箱
            show: false, //是否显示工具箱
            feature: {		//启用功能，
                saveAsImage: {
                    show: true ,
                    // title:"下载图片"
                }//保存图片
            },
            orient: "vertical",
            right: 20
        },
        tooltip : {         // Option config. Can be overwrited by series or data
            trigger: 'item',
			confine: true, // 关键配置：限制 tooltip 在图表区域内 
            triggerOn: 'mousemove',//鼠标移动时触发
            showDelay: 100,//提示框延迟显示  单位：ms  配合triggerOn: 'mousemove'使用
            formatter: function(params){
                // alert('tooltip');
                // setTimeout(function () {
                // },1000);
                return toolTipHtml;
            }
        },
        color: ["#66b1ff","#ff0000", "#87cefa", "#da70d6", "#32cd32", "#6495ed", "#ff69b4", "#ba55d3", "#cd5c5c", "#ffa500", "#40e0d0", "#1e90ff", "#ff6347", "#7b68ee", "#00fa9a", "#ffd700", "#6699FF", "#ff6666", "#3cb371", "#b8860b", "#30e0e0"],
        legend: {
            show: true,
            data: legends,
            x:'center',
            y:'top',
            textStyle:{
                fontSize:9
            },
            padding:[22,5,5,5]
            // orient: 'vertical',
        },
        animation : false ,//关闭动画
        radar: {
            indicator:indicator,
            center: ['50%', radarYPosition],
            radius: 90,//半径值
            startAngle: 90,//坐标系起始角度
            axisName: {
                // formatter:'{value}',
                textStyle: {
                    color:'#000',
                },
                // width:10,
                // height:10,
                // overflow:'truncate',
                // ellipsis:'...',
                formatter:function(xName){
                    if(xName.length>8){
                        xName = xName.substring(0,7)+"...";
                    }
                    // return xName.substring(0,7)+"...";
                    return xName;
                }
            },
            splitArea: {
                areaStyle: {
                    color: ['#fff'],
                }
            },
            axisLabel: {
                // formatter : function(value, index){
                //     // return value + 'kg';//横坐标只显示编号
                // }
            }
        },
        series: sesiesli
    };
    if(indicator.length<=0){
        return null;
    }
    var axisLabel = {
        show:true,
        fontSize:12,
        color:'#000000',
        showMaxLabel:true,
        showMinLabel:true
    };
    option.radar.indicator[0].axisLabel = axisLabel;
    if(isPercent=='1'){
        option.radar.indicator[0].axisLabel.formatter = '{value}%';
    }

    myChart.setOption(option,true);
    myChart.resize();//重新设置echarts的高度

    myChart.on('mouseover', function(params) {
        // alert('mouseover');
        toolTipHtml = '';
        var isSelectedDot = params.event.target.__dimIdx;
        if(isSelectedDot == undefined) return;
        //做鼠标滑过拐点的操作
        // this.tooltip.showTip = true;
        var percentStr = isPercent=='1'?"%":"";
        var seriesName = this._model.option.radar[0].indicator[isSelectedDot].text;
        toolTipHtml = '<div style="font-size:14px;color:#666;font-weight:400;line-height:1;text-align:left;">'+params.name+'</div>';
        toolTipHtml += '<div style="margin: 10px 0 0;line-height:1;">'
            +'<span style="font-size:14px;color:#666;font-weight:400;margin-left:2px">'
            +'<span style="display:inline-block;margin-right:4px;border-radius:10px;width:10px;height:10px;background-color:'+params.color+';"></span>'+seriesName+'</span>'
            +'<span style="float:right;margin-left:20px;font-size:14px;color:#666;font-weight:900">'+params.value[isSelectedDot]+percentStr+'</span>'
            +'<div style="clear:both"></div>'
        toolTipHtml += "</div>";
    });

    setTimeout(createImgBase64(),100);
    function createImgBase64(){
        data = myChart.getDataURL("png");
    }
    return data;
}
