var main, menu, mask = mui.createMask(_closeMenu);
var showMenu = false,
	mode = 'menu-move';
var storeUrl="";

//整体滑动暂不支持android手机，因为两个页面的移动动画，无法保证同步性；
if (!mui.os.android) {
	//整体滑动暂不支持android手机，因为两个页面的移动动画，无法保证同步性；
	// document.getElementById("move-togger").classList.remove('mui-hidden');
	var spans = document.querySelectorAll('.android-only');
	for (var i = 0, len = spans.length; i < len; i++) {
		spans[i].style.display = "none";
	}
}

mui.init({
	swipeBack: false,
	beforeback: back
});

function back() {
	if (showMenu) {
		//菜单处于显示状态，返回键应该先关闭菜单,阻止主窗口执行mui.back逻辑；
		closeMenu();
		return false;
	} else {
		//菜单处于隐藏状态，执行返回时，要先close菜单页面，然后继续执行mui.back逻辑关闭主窗口；
		menu.close('none');
		return true;
	}
}
//plusReady事件后，自动创建menu窗口；
mui.plusReady(function() {
	//plus.screen.unlockOrientation(); // 取消旋转屏幕
	plus.screen.lockOrientation("portrait-primary"); // 或者使用把屏幕改变成竖屏正方向

	main = plus.webview.currentWebview();
});

/*
 * 显示菜单菜单
 */
function openMenu() {
	if (!showMenu) {
		//解决android 4.4以下版本webview移动时，导致fixed定位元素错乱的bug;
		if (mui.os.android && parseFloat(mui.os.version) < 4.4) {
			document.querySelector("header.mui-bar").style.position = "static";
			//同时需要修改以下.mui-contnt的padding-top，否则会多出空白；
			document.querySelector(".mui-bar-nav~.mui-content").style.paddingTop = "0px";
		}

		//侧滑菜单处于隐藏状态，则立即显示出来；
		//显示完毕后，根据不同动画效果移动窗体；
		menu.show('none', 0, function() {
			switch (mode) {
				case 'main-move':
					//主窗体开始侧滑；
					main.setStyle({
						left: '-90%',
						transition: {
							duration: 150
						}
					});
					break;
				case 'menu-move':
					menu.setStyle({
						left: '10%',
						transition: {
							duration: 150
						}
					});
					break;
				case 'all-move':
					main.setStyle({
						left: '-90%',
						transition: {
							duration: 150
						}
					});
					menu.setStyle({
						left: '10%',
						transition: {
							duration: 150
						}
					});
					break;
			}
		});
		//显示主窗体遮罩
		mask.show();
		showMenu = true;
		$.set('filterID',menu.id);
	}
}

function closeMenu() {
	//窗体移动
	_closeMenu();
	//关闭遮罩
	mask.close();
}

/**
 * 关闭侧滑菜单(业务部分)
 */
function _closeMenu() {
	if (showMenu) {
		//解决android 4.4以下版本webview移动时，导致fixed定位元素错乱的bug;
		if (mui.os.android && parseFloat(mui.os.version) < 4.4) {
			document.querySelector("header.mui-bar").style.position = "fixed";
			//同时需要修改以下.mui-contnt的padding-top，否则会多出空白；
			document.querySelector(".mui-bar-nav~.mui-content").style.paddingTop = "44px";
		}

		switch (mode) {
			case 'main-move':
				//主窗体开始侧滑；
				main.setStyle({
					left: '0',
					transition: {
						duration: 150
					}
				});
				break;
			case 'menu-move':
				//主窗体开始侧滑；
				menu.setStyle({
					left: '100%',
					transition: {
						duration: 150
					}
				});
				break;
			case 'all-move':
				//主窗体开始侧滑；
				main.setStyle({
					left: '0',
					transition: {
						duration: 150
					}
				});
				//menu页面同时移动
				menu.setStyle({
					left: '100%',
					transition: {
						duration: 150
					}
				});

				break;
		}
		//等窗体动画结束后，隐藏菜单webview，节省资源；
		setTimeout(function() {
			menu.hide();
		}, 300);
		showMenu = false;
	}
}

function preloadFilterView(id, url) {
	if (!plus) return;
	var win = plus.webview.getWebviewById(id);
	
	if (win) {
		if(storeUrl==$.getUrl()){
			win.hide();
			menu = win;
			console.log("fire getMemory方法...");
			mui.fire(win, 'getMemory');
			return;
		}else{
			win.close();
		}
	}
	setTimeout(function() {
		
		storeUrl=$.getUrl();
		//侧滑菜单默认隐藏，这样可以节省内存；
		menu = mui.preload({
			id: id,
			url: url,
			styles: {
				top: '53px',
				bottom: subWinBottom,
				left: "10%",
				width: '90%',
				zindex: 9997
			},
			waiting: {
				autoShow: true, //自动显示等待框，默认为true
			}
		});
	}, 300);
}


//点击侧滑图标，打开侧滑菜单；
// document.querySelector('.singleSubjectReport-filter').addEventListener('tap', openMenu);
//在android4.4中的swipe事件，需要preventDefault一下，否则触发不正常
//故，在dragleft，dragright中preventDefault
window.addEventListener('dragright', function(e) {
	e.detail.gesture.preventDefault();
});
window.addEventListener('dragleft', function(e) {
	e.detail.gesture.preventDefault();
});
//主界面向左滑动，若菜单未显示，则显示菜单；否则不做任何操作；
// window.addEventListener("swipeleft", openMenu);
//主界面向右滑动，若菜单已显示，则关闭菜单；否则，不做任何操作；
window.addEventListener("swiperight", closeMenu);
//menu页面向右滑动，关闭菜单；
window.addEventListener("menu:swiperight", closeMenu);

/*
//重写mui.menu方法，Android版本menu按键按下可自动打开、关闭侧滑菜单；
mui.menu = function() {
	if (showMenu) {
		closeMenu();
	} else {
		openMenu();
	}
}
*/

window.addEventListener("closeMenu", closeMenu);

window.onbeforeunload = function() {
	// console.log('menu window onbeforeunload ... ');
	closeMenu();
};

window.addEventListener("pagehide", function() {
	// console.log('menu window pagehide ... ');
	closeMenu();
}, false);

