//线型
var bodyWidth = window.screen.width;
var nowwidth = bodyWidth * 4 / 15;
function getLineChart(baseUrl, divContent, title1, boundaryType, scale, type) {

	var categories = [];
	var legends = [];
	var sesiesli = "";
	var maxScore = ""; //最高分
	var xMark = 0;
	var yMark = "";
	var sname = "";
	var sdata = "";
	var totalScore = "";
	$.newAjax({
		url: baseUrl,
		success: function(data) {

			sesiesli = data[0];
			legends = data[1]; //legend的数据
			categories = data[2]; //横坐标的数据
			maxScore = data[3]; //最大值
			xMark = data[4]; //mark的横坐标
			yMark = data[5]; //mark的纵坐标
			totalScore = data[6]; //mark的值
			if(categories.length > 0) {

				sname = sesiesli[0].name;
				sdata = sesiesli[0].data;

				if(type == "1") { //班
					$("#item0CStr1").html("注：");
					$("#item0CStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②班级最高分：" + maxScore + "分");
				} else if(type == "2") { //校
					$("#item0GStr1").html("注：");
					$("#item0GStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②全校最高分：" + maxScore + "分");
				} else if(type == "3") { //区
					$("#item0AStr1").html("注：");
					$("#item0AStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②全区最高分：" + maxScore + "分");
				}

				var option = {
					title: {
						text: '',
						x: 'center',
						textStyle: {
							fontSize: 0.10 * nowwidth,
							lineHeight: 0.10 * nowwidth
						}
					},
					tooltip: {
						trigger: 'item',
						showDelay: 0,
						hideDelay: 2000,
						transitionDuration: 0,
						borderRadius: 0.10 * nowwidth,
						borderWidth: 0,
						backgroundColor: 'rgba(72, 198, 255, 0.7)',
						padding: 0.10 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						},
						position: function(p) {
							// 位置回调
							return [p[0] + 10, p[1] - 10];
						},
						formatter: function(params, ticket) {
							var res = "";
							if(params.name == '你的位置') {
								res = params.name;
							} else {
								res = "分数段： " + params.name + '<br>';
								res += "人数： " + params.value;
							}
							return res;
						}
					},
					legend: {
						data: legends,
						x: 'center',
						y: 'top',
						itemWidth: 0.25 * nowwidth,
						itemHeight: 0.14 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						},
						orient: 'vertical'
					},
					toolbox: {
						show: false, //是否显示工具箱
						feature: {
							mark: {
								show: true
							}, //辅助线
							dataView: {
								show: true,
								readOnly: false
							}, //数据视图
							magicType: {
								show: true,
								type: ['line', 'bar', 'stack', 'tiled']
							}, //折线图切换，跟具体属性有关
							restore: {
								show: true
							}, //恢复
							saveAsImage: {
								show: true,
								title: "放大"
							} //保存图片
						}
					},
					calculable: false, //容易搞错的属性，折线图、柱状图是否叠加
					grid: [{
						top: "15%",
						bottom: 5 * 0.12 * nowwidth,
						right: 4.8 * 0.12 * nowwidth
					}],
					xAxis: [{
						name: '(分数)',
						nameTextStyle: {
							fontSize: 0.15 * nowwidth,
							fontWeight: 'bolder',
							color: '#48C6FF'
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						type: 'category',
						boundaryGap: boundaryType, //x，y轴绑定焦点
						data: categories,
						axisLabel: {
							margin: 5 * 0.12 * nowwidth,
							rotate: 90,
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						splitArea: {
							show: true,
							areaStyle: {
								color: ['#F0F5F9', '#FAFAFA']
							},
							onGap: true
						},
						axisTick: {
							show: false
						}
					}]
					yAxis: [{
						name: '(人数)',
						nameTextStyle: {
							fontSize: 0.15 * nowwidth,
							fontWeight: 'bolder',
							color: '#48C6FF'
						},
						axisLabel: {
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						splitArea: {
							show: false
						},
						type: 'value',
						scale: scale //自动设置y轴坐标最大最小值，取消0点
					}],
					series: [
//					{
//						name: sname,
//						type: "bar",
//						barWidth: 0.10 * nowwidth,
//						data: sdata,
//						markPoint: {
//							data: [{
//								name: '你的位置',
//								value: totalScore,
//								xAxis: xMark,
//								yAxis: yMark,
//								symbol: 'pin',
//								symbolSize: 0.35 * nowwidth,
//								itemStyle: {
//									normal: {
//										color: '#FF9132'
//									}
//								},
//								label: {
//									position: 'right',
//									fontSize: 0.20 * nowwidth,
//									fontWeight: 'bold'
//								}
//							}]
//						},
//						itemStyle: {
//							normal: {
//								color: function(params) {
//									var color = title1;
//									return color
//								}
//							}
//						},
//					}
					]

				};
				alert("123312265456465465");
				var myChart = echarts.init(divContent);
				myChart.setOption(option);

			}
		},
		error: function(data) {
			return false;
		}
	});

}

//柱-线混合
function getMixChart(baseUrl, divContent, title1, boundaryType, scale, type) {
	var categories = [];
	var legends = [];
	var sesiesli = "";
	var qType = "";
	var fullScore = "";
	$.newAjax({
		url: baseUrl,
		success: function(data) {
			sesiesli = data[0];
			legends = data[1];
			categories = data[2];
			fullScore = data[3];
			qType = data[4];
			$("#" + divContent).height((1.20 + 0.40 * (categories.length)) * bodyWidth * 4 / 15);

			if(categories.length > 0) {
				var option = {
					title: {
						text: title1,
						x: 'center',
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						}
					},
					tooltip: {
						trigger: 'item',
						showDelay: 0,
						hideDelay: 2000,
						transitionDuration: 0,
						backgroundColor: 'rgba(72, 198, 255, 0.7)',
						borderRadius: 0.10 * nowwidth,
						borderWidth: 0,
						padding: 0.10 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth
						},
						position: function(p) {
							// 位置回调
							return [p[0] + 10, p[1] - 10];
						},
						formatter: function(params, ticket) {
							var res = "";
							var index = ticket.replace(/[^0-9]+/ig, "");
							var tuli = ticket.replace(/[0-9]+/ig, "");
							if(type == "item1") {
								var qtypename = "";
								if(qType[index] == "0") {
									qtypename = "客观题";
								} else if(qType[index] == "1") {
									qtypename = "主观题";
								}
								res = '题型： ' + qtypename + '<br/>';
								res += '题号：' + params.name + '<br/>';
								res += '满分值：' + fullScore[index] + '<br/>';
								res += params.seriesName + ":" + params.value + '%';
							} else if(type == "item2") {
								res = '知识点：' + changeStrTT(qType[index], 30) + '<br/>';
								res += '满分值：' + fullScore[index] + '<br/>';
								res += params.seriesName + ":" + params.value + '%';
							} else if(type == "item3") {
								res = '能力点：' + changeStrTT(qType[index], 30) + '<br/>';
								res += params.seriesName + params.value + '<br/>';
								res += '满分值：' + fullScore[index];

							} else if(type == "item4") {
								res = '题型：' + changeStrTT(qType[index], 30) + '<br/>';
								res += params.seriesName + params.value + '<br/>';
								res += '满分值：' + fullScore[index];
							}
							return res;
						}
					},
					legend: {
						data: legends,
						x: 'center',
						y: 'top',
						itemWidth: 0.25 * nowwidth,
						itemHeight: 0.14 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							color: '#7C7C7C'
						},
						orient: 'horizontal',
						padding: [0, 0.05 * nowwidth, 0.3 * nowwidth, 0.05 * nowwidth],
						itemGap: 0.10 * nowwidth,
					},
					toolbox: {
						show: false, //是否显示工具箱
						feature: {
							mark: {
								show: true
							}, //辅助线
							dataView: {
								show: true,
								readOnly: false
							}, //数据视图
							magicType: {
								show: true,
								type: ['line', 'bar', 'stack', 'tiled']
							}, //折线图切换，跟具体属性有关
							restore: {
								show: true
							}, //恢复
							saveAsImage: {
								show: true,
								title: "放大"
							} //保存图片
						}
					},
					calculable: false, //容易搞错的属性，折线图、柱状图是否叠加
					grid: [{
						top: "15%",
						left: 0.6 * nowwidth
					}],
					yAxis: [{
						type: 'category',
						boundaryGap: boundaryType, //x，y轴绑定焦点
						data: categories,
						axisLabel: {
							rotate: 0,
							textStyle: {
								align: 'center',
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							},
							margin: 0.30 * nowwidth
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						axisTick: {
							show: false
						},
						splitArea: {
							show: true,
							areaStyle: {
								color: ['#F0F5F9', '#FAFAFA']
							},
							onGap: true
						},
						splitLine: {
							lineStyle: {
								width: 0.01 * nowwidth
							}
						}
					}],
					xAxis: [{
						type: 'value',
						min: 0,
						max: 100,
						splitNumber: 5,
						axisLabel: {
							formatter: '{value} %',
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						splitLine: {
							lineStyle: {
								width: 0.01 * nowwidth
							}
						},
						scale: scale, //自动设置y轴坐标最大最小值，取消0点
						position: 'top',
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						}
					}],
					series: []
				};

				for(var i = 0; i < legends.length; i++) {
					option.series[i] = sesiesli[i];
					if(option.series[i].type == "bar") {
						option.series[i].barWidth = 0.15 * nowwidth
					} else if(option.series[i].type == "line") {
						option.series[i].symbolSize = 0.04 * nowwidth;
						option.series[i].lineStyle = {
							width: 0.02 * nowwidth,
						};
					}
				}
				var myChart = echarts.init(byId(divContent));
				myChart.setOption(option);
			}
		},
		error: function(data) {
			return false;
		}
	});

}

//指定长度换行
function changeStrTT(str, len) {
	if(str == null || str == "") {
		return "";
	}
	if(len == null) {
		len = 10;
	}
	var result = "";
	var curlen = 0;
	var patten = /.*[\u4e00-\u9fa5]+.*$/;
	for(var i = 0; i < str.length; i++) {
		if(patten.test(str[i])) {
			curlen += 2;
		} else {
			curlen++;
		}
		if(curlen >= len) {
			curlen = 0;
			result += "<br>";
		}
		result += str[i];
	}
	return result;
}

//南丁格尔玫瑰图
function getPieChart(baseUrl, divContent, title1, boundaryType, scale, type) {
	var legends = [];
	var sesiesli = "";
	var maxScore = ""; //最高分
	var xMark = 0;
	var yMark = "";

	$.newAjax({
		url: baseUrl,
		success: function(data) {
			sesiesli = data[0];
			legends = data[1];
			maxScore = data[2];
			xMark = data[3];
			yMark = data[4];
			if(sesiesli.length > 0) {
				if(type == "1") { //班
					$("#item0CStr").html("注：①气泡代表学生本人所处的位置。②班级最高分：" + maxScore);
				} else if(type == "2") { //校
					$("#item0GStr").html("注：①气泡代表学生本人所处的位置。②全校最高分：" + maxScore);
				} else if(type == "3") { //区
					$("#item0AStr").html("注：①气泡代表学生本人所处的位置。②全区最高分：" + maxScore);
				}
			}
		}
	});
	var option = {
		title: {
			text: title1,
			x: 'center',
			textStyle: {
				fontSize: 10,
			}
		},
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b} : {c} ({d}%)"
		},
		legend: {
			data: legends,
			x: 'left',
			y: 'center',
			textStyle: {
				fontSize: 9,
			},
			orient: 'vertical'
		},
		toolbox: {
			show: false,
			feature: {
				mark: {
					show: true
				},
				dataView: {
					show: true,
					readOnly: false
				},
				magicType: {
					show: true,
					type: ['pie', 'funnel']
				},
				restore: {
					show: true
				},
				saveAsImage: {
					show: true
				}
			}
		},
		calculable: true, //容易搞错的属性，折线图、柱状图是否叠加
		series: [{
			name: '面积模式',
			type: 'pie',
			radius: [20, '50%'],
			center: ['60%', '50%'],
			roseType: 'area',
			x: '50%', // for funnel
			max: 40, // for funnel
			sort: 'ascending', // for funnel
			data: sesiesli,
			markPoint: {
				symbol: 'pin',
				data: [
					//	                    {name : '我的位置', value : '', x:'50%', y:50, symbolSize:12,symbolRotate:-45}
				]
				//{name:'你的位置',value :"", xAxis: xMark, yAxis: yMark}
			}
		}]

	};
	var myChart = echarts.init(divContent);
	myChart.setOption(option);
}