//线型
var bodyWidth = window.screen.width;
var nowwidth = bodyWidth * 4 / 15;
function getLineChart(baseUrl, divContent, title1, boundaryType, scale, type) {

	var categories = [];
	var legends = [];
	var sesiesli = "";
	var maxScore = ""; //最高分
	var xMark = 0;
	var yMark = "";
	var sname = "";
	var sdata = "";
	var totalScore = "";
	$.newAjax({
		url: baseUrl,
		success: function(data) {
			sesiesli = data[0];
			legends = data[1]; //legend的数据
			categories = data[2]; //横坐标的数据
			maxScore = data[3]; //最大值
			xMark = data[4]; //mark的横坐标
			yMark = data[5]; //mark的纵坐标
			totalScore = data[6]; //mark的值
			if(categories.length > 0) {

				sname = sesiesli[0].name;
				sdata = sesiesli[0].data;

				if(type == "1") { //班
					$("#item0CStr1").html("注：");
					$("#item0CStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②班级最高分：" + maxScore + "分");
				} else if(type == "2") { //校
					$("#item0GStr1").html("注：");
					$("#item0GStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②全校最高分：" + maxScore + "分");
				} else if(type == "3") { //区
					$("#item0AStr1").html("注：");
					$("#item0AStr2").html("①<img width='0.11rem' height='0.11rem' style='vertical-align:middle;' src='../../../img/oneSub/qipao.png'>代表学生本人所处的位置<br>②全区最高分：" + maxScore + "分");
				}

				var option = {
					title: {
						text: '',
						x: 'center',
						textStyle: {
							fontSize: 0.10 * nowwidth,
							lineHeight: 0.10 * nowwidth
						}
					},
					tooltip: {
						trigger: 'item',
						showDelay: 0,
						hideDelay: 2000,
						transitionDuration: 0,
						borderRadius: 0.10 * nowwidth,
						borderWidth: 0,
						backgroundColor: 'rgba(72, 198, 255, 0.7)',
						padding: 0.10 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						},
						position: function(p) {
							// 位置回调
							return [p[0] + 10, p[1] - 10];
						},
						formatter: function(params, ticket) {
							var res = "";
							if(params.name == '你的位置') {
								res = params.name;
							} else {
								res = "分数段： " + params.name + '<br>';
								res += "人数： " + params.value;
							}
							return res;
						}
					},
					legend: {
						data: legends,
						x: 'center',
						y: 'top',
						itemWidth: 0.25 * nowwidth,
						itemHeight: 0.14 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						},
						orient: 'vertical'
					},
					toolbox: {
						show: false, //是否显示工具箱
						feature: {
							mark: {
								show: true
							}, //辅助线
							dataView: {
								show: true,
								readOnly: false
							}, //数据视图
							magicType: {
								show: true,
								type: ['line', 'bar', 'stack', 'tiled']
							}, //折线图切换，跟具体属性有关
							restore: {
								show: true
							}, //恢复
							saveAsImage: {
								show: true,
								title: "放大"
							} //保存图片
						}
					},
					calculable: false, //容易搞错的属性，折线图、柱状图是否叠加
					grid: [{
						top: "8%",
						bottom: 5 * 0.12 * nowwidth,
						right: 4.8 * 0.12 * nowwidth
					}],
					xAxis: [{
						name: '(分数)',
						nameTextStyle: {
							fontSize: 0.15 * nowwidth,
							fontWeight: 'bolder',
							color: '#48C6FF'
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						type: 'category',
						boundaryGap: boundaryType, //x，y轴绑定焦点
						data: categories,
						axisLabel: {
							margin: 5 * 0.02 * nowwidth,
							rotate: 90,
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						splitArea: {
							show: true,
							areaStyle: {
								color: ['#F0F5F9', '#FAFAFA']
							},
							onGap: true
						},
						axisTick: {
							show: false
						}
					}],
					yAxis: [{
						name: '(人数)',
						nameTextStyle: {
							fontSize: 0.15 * nowwidth,
							fontWeight: 'bolder',
							color: '#48C6FF'
						},
						axisLabel: {
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						splitArea: {
							show: false
						},
						type: 'value',
						scale: scale //自动设置y轴坐标最大最小值，取消0点
					}],
					series: [
					{
						name: sname,
						type: "bar",
						barWidth: 0.10 * nowwidth,
						data: sdata,
						markPoint: {
							data: [{
								name: '你的位置',
								value: totalScore,
								xAxis: xMark,
								yAxis: yMark,
								symbol: 'pin',
								symbolSize: 0.35 * nowwidth,
								itemStyle: {
									normal: {
										color: '#FF9132'
									}
								},
								label: {
									position: 'right',
									fontSize: 0.20 * nowwidth,
									fontWeight: 'bold'
								}
							}]
						},
						itemStyle: {
							normal: {
								color: function(params) {
									var color = title1;
									return color
								}
							}
						},
					}
					]

				};
				var myChart = echarts.init(divContent);
				myChart.setOption(option);

			}
		},
		error: function(data) {
			return false;
		}
	});

}

//柱-线混合
function getMixChart(baseUrl, divContent, title1, boundaryType, scale, type) {
	var categories = [];
	var legends = [];
	var sesiesli = "";
	var qType = "";
	var fullScore = "";
	
	$.newAjax({
		url: baseUrl,
		success: function(data) {
			sesiesli = data[0];
			legends = data[1];
			categories = data[2];
			fullScore = data[3];
			qType = data[4];
			$("#" + divContent).height((1.20 + 0.40 * (categories.length)) * bodyWidth * 4 / 15);

			if(categories.length > 0) {
			
				var option = {
					title: {
						text: title1,
						x: 'center',
						textStyle: {
							fontSize: 0.12 * nowwidth,
							lineHeight: 0.12 * nowwidth
						}
					},
					tooltip: {
						trigger: 'item',
						showDelay: 0,
						hideDelay: 2000,
						transitionDuration: 0,
						backgroundColor: 'rgba(72, 198, 255, 0.7)',
						borderRadius: 0.10 * nowwidth,
						borderWidth: 0,
						padding: 0.10 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth
						},
						position: function(p) {
							// 位置回调
							return [p[0] + 10, p[1] - 10];
						},
						formatter: function(params, ticket) {
							var res = "";
							var index = ticket.replace(/[^0-9]+/ig, "");
							var tuli = ticket.replace(/[0-9]+/ig, "");
							if(type == "item1") {
								var qtypename = "";
								if(qType[index] == "0") {
									qtypename = "客观题";
								} else if(qType[index] == "1") {
									qtypename = "主观题";
								}
								res = '题型： ' + qtypename + '<br/>';
								res += '题号：' + params.name + '<br/>';
								res += '满分值：' + fullScore[index] + '<br/>';
								res += params.seriesName + ":" + params.value + '%';
							} else if(type == "item2") {
								res = '知识点：' + changeStrTT(qType[index], 30) + '<br/>';
								res += '满分值：' + fullScore[index] + '<br/>';
								res += params.seriesName + ":" + params.value + '%';
							} else if(type == "item3") {
								res = '能力点：' + changeStrTT(qType[index], 30) + '<br/>';
								res += params.seriesName + params.value + '<br/>';
								res += '满分值：' + fullScore[index];

							} else if(type == "item4") {
								res = '题型：' + changeStrTT(qType[index], 30) + '<br/>';
								res += params.seriesName + params.value + '<br/>';
								res += '满分值：' + fullScore[index];
							}
							return res;
						}
					},
					legend: {
						data: legends,
						x: 'center',
						y: 'top',
						itemWidth: 0.25 * nowwidth,
						itemHeight: 0.14 * nowwidth,
						textStyle: {
							fontSize: 0.12 * nowwidth,
							color: '#7C7C7C'
						},
						orient: 'horizontal',
						padding: [0, 0.05 * nowwidth, 0.3 * nowwidth, 0.05 * nowwidth],
						itemGap: 0.10 * nowwidth,
					},
					toolbox: {
						show: false, //是否显示工具箱
						feature: {
							mark: {
								show: true
							}, //辅助线
							dataView: {
								show: true,
								readOnly: false
							}, //数据视图
							magicType: {
								show: true,
								type: ['line', 'bar', 'stack', 'tiled']
							}, //折线图切换，跟具体属性有关
							restore: {
								show: true
							}, //恢复
							saveAsImage: {
								show: true,
								title: "放大"
							} //保存图片
						}
					},
					calculable: false, //容易搞错的属性，折线图、柱状图是否叠加
					grid: [{
						top: 0.6 * nowwidth,
						left: 0.6 * nowwidth
					}],
					yAxis: [{
						type: 'category',
						boundaryGap: boundaryType, //x，y轴绑定焦点
						data: categories,
						axisLabel: {
							rotate: 0,
							textStyle: {
								align: 'center',
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							},
							margin: 0.30 * nowwidth
						},
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						},
						axisTick: {
							show: false
						},
						splitArea: {
							show: true,
							areaStyle: {
								color: ['#F0F5F9', '#FAFAFA']
							},
							onGap: true
						},
						splitLine: {
							lineStyle: {
								width: 0.01 * nowwidth
							}
						}
					}],
					xAxis: [{
						type: 'value',
						min: 0,
						max: 100,
						splitNumber: 5,
						axisLabel: {
							formatter: '{value} %',
							textStyle: {
								color: '#7C7C7C',
								fontSize: 0.12 * nowwidth
							}
						},
						splitLine: {
							lineStyle: {
								width: 0.01 * nowwidth
							}
						},
						scale: scale, //自动设置y轴坐标最大最小值，取消0点
						position: 'top',
						axisLine: {
							show: true,
							lineStyle: {
								color: '#F4F5F7',
								width: 0.01 * nowwidth,
								type: 'solid'
							}
						}
					}],
					series: []
				};

				for(var i = 0; i < legends.length; i++) {
					option.series[i] = sesiesli[i];
					if(option.series[i].type == "bar") {
						option.series[i].barWidth = 0.15 * nowwidth
					} else if(option.series[i].type == "line") {
						option.series[i].symbolSize = 0.04 * nowwidth;
						option.series[i].lineStyle = {
							width: 0.02 * nowwidth,
						};
					}
				}
				var myChart = echarts.init(byId(divContent));
				myChart.setOption(option);
			}
		},
		error: function(data) {
			return false;
		}
	});

}

//指定长度换行
function changeStrTT(str, len) {
	if(str == null || str == "") {
		return "";
	}
	if(len == null) {
		len = 10;
	}
	var result = "";
	var curlen = 0;
	var patten = /.*[\u4e00-\u9fa5]+.*$/;
	for(var i = 0; i < str.length; i++) {
		if(patten.test(str[i])) {
			curlen += 2;
		} else {
			curlen++;
		}
		if(curlen >= len) {
			curlen = 0;
			result += "<br>";
		}
		result += str[i];
	}
	return result;
}

//南丁格尔玫瑰图
function getPieChart(baseUrl, divContent, title1, boundaryType, scale, type) {
	var legends = [];
	var sesiesli = "";
	var maxScore = ""; //最高分
	var xMark = 0;
	var yMark = "";

	$.newAjax({
		url: baseUrl,
		success: function(data) {
			sesiesli = data[0];
			legends = data[1];
			maxScore = data[2];
			xMark = data[3];
			yMark = data[4];
			if(sesiesli.length > 0) {
				if(type == "1") { //班
					$("#item0CStr").html("注：①气泡代表学生本人所处的位置。②班级最高分：" + maxScore);
				} else if(type == "2") { //校
					$("#item0GStr").html("注：①气泡代表学生本人所处的位置。②全校最高分：" + maxScore);
				} else if(type == "3") { //区
					$("#item0AStr").html("注：①气泡代表学生本人所处的位置。②全区最高分：" + maxScore);
				}
			}
		}
	});
	var option = {
		title: {
			text: title1,
			x: 'center',
			textStyle: {
				fontSize: 10,
			}
		},
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b} : {c} ({d}%)"
		},
		legend: {
			data: legends,
			x: 'left',
			y: 'center',
			textStyle: {
				fontSize: 9,
			},
			orient: 'vertical'
		},
		toolbox: {
			show: false,
			feature: {
				mark: {
					show: true
				},
				dataView: {
					show: true,
					readOnly: false
				},
				magicType: {
					show: true,
					type: ['pie', 'funnel']
				},
				restore: {
					show: true
				},
				saveAsImage: {
					show: true
				}
			}
		},
		calculable: true, //容易搞错的属性，折线图、柱状图是否叠加
		series: [{
			name: '面积模式',
			type: 'pie',
			radius: [20, '50%'],
			center: ['60%', '50%'],
			roseType: 'area',
			x: '50%', // for funnel
			max: 40, // for funnel
			sort: 'ascending', // for funnel
			data: sesiesli,
			markPoint: {
				symbol: 'pin',
				data: [
					//	                    {name : '我的位置', value : '', x:'50%', y:50, symbolSize:12,symbolRotate:-45}
				]
				//{name:'你的位置',value :"", xAxis: xMark, yAxis: yMark}
			}
		}]

	};
	var myChart = echarts.init(divContent);
	myChart.setOption(option);
}
//分段统计图
function getSubsectionData(param){
	 
	var schoolNum = $("#schoolNum").val();
	var classNum = $("#classNum").val();
	var isMoreSchool = $("#isMoreSchool").val();
	var baseurl = $.getUrl()+"/appIndex!getSubsectionData.action?";
	var paramC = param+"&schoolNum="+schoolNum+"&classNum="+classNum;
	//分段统计图-班
	getLineChart(baseurl+encodeURI(paramC),byId("item0CChart"),"#B4E04F",true,false,"1");
	//分段统计图-校
	var paramG = param+"&schoolNum="+schoolNum+"&classNum=-1";
	getLineChart(baseurl+encodeURI(paramG),byId("item0GChart"),"#C3E0FE",true,false,"2");
	if(isMoreSchool == "T"){
		//分段统计图-区
		var paramA = param+"&schoolNum=-1&classNum=-1";
		getLineChart(baseurl+encodeURI(paramA),byId("item0AChart"),"#CCCCFF",true,false,"3");
	}else{
		$("#qChart").hide();
	}
}
//小题得分率
function getQueScoreData(paramCommon){
	//小题得分率
	var baseurl = $.getUrl()+"/appIndex!getQueScoreData.action?"+encodeURI(paramCommon);
	getMixChart(baseurl,"item1Chart","",true,true,"item1");
}

//知识点得分率
function getKnoScoreData(paramCommon){
	//知识点得分率
	var baseurl = $.getUrl()+"/appIndex!getKnoScoreData.action?"+encodeURI(paramCommon);
	getMixChart(baseurl,"item2Chart","",true,true,"item2");
}

//能力点得分率
function getAbiScoreData(paramCommon){
	//能力点得分率
	var baseurl = $.getUrl()+"/appIndex!getAbiScoreData.action?"+encodeURI(paramCommon);
	getMixChart(baseurl,"item3Chart","",true,true,"item3");
}

//题型得分率
function getQtScoreData(paramCommon){
	//题型得分率
	var baseurl = $.getUrl()+"/appIndex!getQtScoreData.action?"+encodeURI(paramCommon);
	getMixChart(baseurl,"item4Chart","",true,true,"item4");
}

function showOrHideStuExamPaperImg(){
	/*
	var url = $.getUrl()+"/appIndex!showStuExamPaperImg.action";
	$.newAjax({
		url: url,
		async: true,
		dataType:'text',
		success: function(data) {
			if(data=='0'){
				$('#toMyPaper').hide();
			}
		},
		error: function(XMLHttpRequest, statusText, errorThrown) {
			console.log(JSON.stringify(XMLHttpRequest))
		}
	});
	*/
}

//基础成绩
function getBaseData(){
	var examNum = $("#examNum").val();
	var subjectNum = $("#subjectNum").val();
	var fenshuyuan = $("#fenshuyuan").val();
	var isMoreSchool = $("#isMoreSchool").val();
	
	var url = $.getUrl()+"/appIndex!getBaseData.action";
	
	$.newAjax( {
		 url : url,//目标地址
		 data : {
			 examNum:examNum,
			 subjectNum:subjectNum,
			 isMoreSchool:isMoreSchool,
			 fenshuyuan:fenshuyuan
		 },
		 success : function(data) {
			 var base1Str='';
		 	$.each(data,function(i,obj){
		 		$("#schoolNum").val(obj.schoolNum);
		 		$("#gradeNum").val(obj.gradeNum);
		 		$("#classNum").val(obj.classNum);
		 		$("#exampaperNum").val(obj.examPaperNum);
		 		$("#totalScore").val(obj.totalScore);
		 		$("#studentType").val(obj.studentType);
		 		$("#fullScore").val(obj.fullScore);
				$("#rptSource").val(obj.ext6);
				var fsyStr="";
				if(fenshuyuan=="1"){
					fsyStr="（赋分）";
				}
				var studentReportShowItem = $('#studentReportShowItem').val(); 
				switch(studentReportShowItem){
					case '0':
						base1Str = "得分："+changeDecimal_f(obj.totalScore,1)+fsyStr+"/"+changeDecimal_f(obj.fullScore,1);
					break;
					case '1':
						base1Str = "正确率："+ Math.round(obj.totalScore * 100.0 / obj.fullScore, 2) + '%';
					break;
					case '2':
						base1Str = "等级："+obj.dengji;
					break;
				}
		 		$("#base1").html(base1Str);
				$("#subScore").val(changeDecimal_f(obj.totalScore,1));
// 		 		if($("#S1Set").val()=='0'){//显示超越率
// 		 			$("#bRank").hide();
// 		 			$("#rankOrPercentileBtn").html("超越率");
// 		 			$("#rankOrPercentileDiv").find(".li_rank4").hide();
// //		 			$("#base2_1").html(obj.ext4);
// 			 		$("#base3_1").html(obj.ext5+"%");
// 			 		if($("#isMoreSchool").val() == "T" ){
// 			 			$("#base4_1").html(obj.ext6+"%");
// 			 			$("#xRank").removeClass("mui-col-xs-4").addClass("mui-col-xs-6");
// 			 			$("#qRank").removeClass("mui-col-xs-5").addClass("mui-col-xs-6");
// 			 		}else{
// 			 			$("#qRank").hide();
// 			 			$("#xRank").removeClass("mui-col-xs-4").addClass("mui-col-xs-12");
// 			 		}
// 		 		}else{
// 		 			$("#rankOrPercentileBtn").html("排名");
// 		 			$("#base2_1").html(obj.classRanking);
// 			 		$("#base2_2").html(obj.ext1);
// 			 		$("#base3_1").html(obj.gradeRanking);
// 			 		$("#base3_2").html(obj.ext2);
// 			 		if($("#isMoreSchool").val() == "T" ){
// 			 			$("#base4_1").html(obj.areaRanking);
// 			 			$("#base4_2").html(obj.ext3);
// 			 		}else{
// 			 			$("#qRank").hide();
// 			 			$("#bRank").removeClass("mui-col-xs-3").addClass("mui-col-xs-6");
// 			 			$("#xRank").removeClass("mui-col-xs-4").addClass("mui-col-xs-6");
// 			 		}
// 		 		}
		 		base5_1Str = changeDecimal_f(obj.oqts,1);
		 		base5_2Str = changeDecimal_f(obj.sqts,1);
		 		$("#base5_1").html(base5_1Str);
		 		$("#base5_2").html(base5_2Str);
		 	});
		 },
		 error : function(data) {
		 	return false;
		 }
	});
	$.newAjax({
		url: $.getUrl() + "/teacherAppBind!getPicUrl.action",
		async: true,
		data: {
			requestSource: '0'
		},
		success: function(data) {
			// console.log("url:"+data.data);
			$.set("picUrl",data.data);
		},
		error: function(XMLHttpRequest, statusText, errorThrown) {
		}
	});
}

//跳转到查看试卷页面
$("#toMyPaper").on("tap", function() {
	
	var type=$("#modelType").val();
	console.log(type);
	// if(type=='3'){
	// 	mui.openWindow({
	// 		url: '../../zuoye/zaixianceping/CePingJieMian.html',
	// 		id: 'CePingJieMian.html',
	// 		extras: {
				
	// 			examNum:$("#examNum").val(),
	// 			gradeNum:$("#gradeNum").val(),
	// 			subjectNum:$("#subjectNum").val(),
	// 			examPaperNum:$("#exampaperNum").val(),
	// 			stageId:$("#stageId").val(),
	// 			startTime:$("#startTime").val(),
	// 			overTime:$("#overTime").val(),
	// 			zyName:$("#zyName").val(),
	// 			tijiaoCount:$("#tijiaoCount").val(),
	// 			tijiaoStatus:$("#tijiaoStatus").val(),
		
	// 		}
	// 	});
		
	// }else{
		mui.openWindow({
			url: '../ownPapers/ownPapers.html',
			id: 'ownPapers.html',
			extras: {
				exampaperNum:$("#exampaperNum").val(),
				examName:$("#examName").val(),
				subjectName:$("#base0").html(),
				rptSource:$("#rptSource").val(),
				examNum: $("#examNum").val()
			}
		});
	// }
	
	
	
//	var extras = {
//		exampaperNum:$("#exampaperNum").val()
//	};
//	extras.acceleration = "capture";
//	var webview = plus.webview.create("../ownPapers/ownPapers.html","viewgroup2","",extras);
//	webview.addEventListener("titleUpdate",function () {
//		setTimeout(function () {
//			webview.show('slide-in-right',300);
//		},100);
//	});
});

//刷新数据
function refreshData(index){
	if(index === 0){
		//分段统计图
		getSubsectionData();
	}else if(index === 1){
		//小题得分率
		getQueScoreData();
	}else if(index === 2){
		//知识点得分率
		getKnoScoreData();
	}else if(index === 3){
		//能力点得分率
		getAbiScoreData();
	}else if(index === 4){
		//题型
		getQtScoreData();
	}
}
