
var vm = new Vue({
    el: '#cepingjiemian',
    data: {
		examNum:'',
		subjectNum:'',
		gradeNum:'',
		examPaperNum:'',
		stageId:'',
        cepingName:'',
		//题信息
		tiList:[],
		//当前选的题的下标
		defQuestionIndex:'',
		//当前选择的题
		defQuestion:{},
		//当前题的选择的选项
		myanswer:'',
		//主观题是否作答
		disabled:true,
		screenState:'S',//当前是横屏还是竖屏 H:横屏 S:竖屏
		expanded: false,//题干展开收起
		expanded2:false,//知识点答案解析展开收起
    },
    mounted: function () {
		mui.previewImage();
	},
	
    methods:{
		//切换题
		changeTi:function(i){
			if(this.defQuestion.questionType=='1'){//主观题
				if(this.defQuestion.fileList!=''){
					mui.alert("T"+this.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
					return;
				}
			}
			this.defQuestion=this.tiList[i];
			this.defQuestionIndex=i;
			this.selectedFiles=[];
			this.uploading=false;
			if(this.defQuestion.questionType=='0'){//客观题
				if(this.defQuestion.submitStatus=='1'){//已提交
					if(this.defQuestion.myanswer==''){
						this.myanswer="1";
					}else{
						this.myanswer='';
					}
				}else{
					this.myanswer='';
				}
			}else{
				if(this.defQuestion.submitStatus=='1'){//已提交
					if(this.defQuestion.mergedImage==undefined){
						this.myanswer="1";
					}else{
						this.myanswer='';
					}
				}else{
					this.myanswer='';
				}
			}
			this.$nextTick(function() {
				this.scrollToTiItem(this.defQuestionIndex); // 调用方法
			}.bind(this));
			
			scroll();
			
			vm.expanded=false;
			vm.expanded2=false;
			
		},
		//选择题后自动滚动
		scrollToTiItem(index) {
		    const targetEl = this.$refs['tiItem_' + index][0];
		    if (targetEl) {
		      targetEl.scrollIntoView({
		        behavior: "smooth",
		        block: "nearest",
		        inline: "center"
		      });
		    }
		  },
		pre:pre,
		next:next,
		//题干展开or收起
		zhankaiOrShouQi(){
			var el=this;
			if(el.expanded){
				el.expanded=false;
			}else{
				el.expanded=true;
			}
		},
		//知识点答案解析展开or收起
		zhankaiOrShouQi2(){
			var el=this;
			if(el.expanded2){
				el.expanded2=false;
			}else{
				el.expanded2=true;
			}
		},
		
	}
	
})
//查询当前作业的题数据
function Config() {
	
	vm.examNum=examNum;
	vm.gradeNum=gradeNum;
	vm.subjectNum=subjectNum;
	vm.examPaperNum=examPaperNum;
	vm.stageId=stageId
	vm.cepingName=zyName;
	vm.disabled=disabled;
	vm.picUrl=$.getPicUrl();
	
	getCepingPaperQuestions();
	
}

//查询需要测评的作业的题信息
function getCepingPaperQuestions(){
	$.newAjax({
		url: $.getUrl() +'/zaixianceping!getCepingPaperQuestions.action',
		data: {
			examPaperNum: examPaperNum,
			examNum: examNum,
			subjectNum:subjectNum,
			stageId:stageId,
			studentId: plus.storage.getItem("studentid"),
		},
		setTimeout:10000,
		success: function(res) {
			
			if(res.code=='200'){
				vm.tiList=res.data;
				vm.defQuestion=vm.tiList[0];
				vm.defQuestionIndex=0;
				if(vm.defQuestion.questionType=='0'){
					if(vm.defQuestion.submitStatus=='1'){
						
						if(vm.defQuestion.myanswer==''){
							vm.myanswer="1";
						}else{
							vm.myanswer="";
						}
					}
				}
			}else{
				vm.tiList=[];
				vm.defQuestion=[];
				vm.defQuestionIndex='';
				mui.toast(res.msg);
				return;
			}

		},error:function(XMLHttpRequest, textStatus, errorThrown){
			if(textStatus === "timeout") {
				mui.toast("请求超时，请检查网络连接");
			} else if(!navigator.onLine) {
				mui.toast("网络已断开，请连接网络后重试");
			} else {
				mui.toast("查题失败，请联系管理员："+textStatus);
			}
	   }
	});
}

//上一题
function pre(){
	if(vm.defQuestionIndex=='0'){//已经是第一题了
		mui.toast("已经是第一题了");
	}else{
		if(vm.defQuestion.questionType=='1'){//主观题
			if(vm.defQuestion.fileList!=''){
				mui.alert("T"+vm.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
				return;
			}
		}
		// vm.defQuestion=vm.tiList[i];
		// vm.defQuestionIndex=i;
		vm.defQuestion=vm.tiList[vm.defQuestionIndex-1];
		vm.defQuestionIndex=vm.defQuestionIndex-1;
		vm.selectedFiles=[];
		vm.uploading=false;
		if(vm.defQuestion.questionType=='0'){//客观题
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.myanswer==''){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}else{
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.mergedImage==undefined){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}
		this.$nextTick(function() {
			this.scrollToTiItem(this.defQuestionIndex); // 调用方法
		}.bind(this));
		scroll();
		vm.expanded=false;
		vm.expanded2=false;
	}
}

//下一题
function next(){
	if(vm.defQuestionIndex==(vm.tiList.length-1)){//已经是第一题了
		mui.toast("已经是最后一题了");
	}else{
		if(vm.defQuestion.questionType=='1'){//主观题
			if(vm.defQuestion.fileList!=''){
				mui.alert("T"+vm.defQuestion.questionName+"的图片没有上传,上传或清空后可切换下一题");
				return;
			}
		}
		vm.defQuestion=vm.tiList[vm.defQuestionIndex+1];
		vm.defQuestionIndex=vm.defQuestionIndex+1;
		vm.selectedFiles=[];
		vm.uploading=false;
		if(vm.defQuestion.questionType=='0'){//客观题
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.myanswer==''){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}else{
			if(vm.defQuestion.submitStatus=='1'){//已提交
				if(vm.defQuestion.mergedImage==undefined){
					vm.myanswer="1";
				}else{
					vm.myanswer='';
				}
			}else{
				vm.myanswer='';
			}
		}
		this.$nextTick(function() {
				this.scrollToTiItem(this.defQuestionIndex); // 调用方法
		}.bind(this));
		scroll();
		vm.expanded=false;
		vm.expanded2=false;
	}
}

function scroll(){
	var mainDiv = document.querySelector('.tigan');
	mainDiv.scrollTo({
		top: 0,
		behavior: 'smooth'
	});
}

