//  const { TextDecoder } = require('util');
// console.log((0, module.require)('util'),'====')
// (0, module.require)('util').TextDecoder
import dayjs from 'dayjs'

const TextDecoder = require('text-encoding').TextDecoder

let wasm
export function __wbg_set_wasm(val) {
    wasm = val
}
const lTextDecoder = TextDecoder
let cachedTextDecoder = new lTextDecoder('utf-8', { ignoreBOM: true, fatal: true })
cachedTextDecoder.decode()
let cachedUint8Memory0 = null

function getUint8Memory0() {
    cachedUint8Memory0 = new Uint8Array(wasm.memory.buffer)
    return cachedUint8Memory0
}

function getStringFromWasm0(ptr, len) {
    ptr = ptr >>> 0
    return cachedTextDecoder.decode(getUint8Memory0().subarray(ptr, ptr + len))
}

let cachedInt32Memory0 = null

function getInt32Memory0() {
    cachedInt32Memory0 = new Int32Array(wasm.memory.buffer)
    return cachedInt32Memory0
}
/**
 * @returns {string}
 */
export function get_key() {
    console.log( dayjs().format('YYYY-MM-DD hh:mm:ss'))
    let deferred1_0
    let deferred1_1
    try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16)
        wasm.get_key(retptr)
        var r0 = getInt32Memory0()[retptr / 4 + 0]
        var r1 = getInt32Memory0()[retptr / 4 + 1]
        deferred1_0 = r0
        deferred1_1 = r1
        return getStringFromWasm0(r0, r1)
    } finally {
        wasm.__wbindgen_add_to_stack_pointer(16)
        wasm.__wbindgen_free(deferred1_0, deferred1_1, 1)
    }
}

let WASM_VECTOR_LEN = 0

// console.log(TextDecoder, 'TextDecoder')

let cachedTextEncoder = new lTextDecoder('utf-8', { ignoreBOM: true, fatal: true })

const encodeString = (typeof cachedTextEncoder.encodeInto === 'function'
    ? function (arg, view) {
    return cachedTextEncoder.encodeInto(arg, view);
}
    : function (arg, view) {
    const buf = cachedTextEncoder.encode(arg);
    view.set(buf);
    return {
        read: arg.length,
        written: buf.length
    };
});

function passStringToWasm0(arg, malloc, realloc) {

    if (realloc === undefined) {
        const buf = cachedTextEncoder.encode(arg);
        const ptr = malloc(buf.length, 1) >>> 0;
        getUint8Memory0().subarray(ptr, ptr + buf.length).set(buf);
        WASM_VECTOR_LEN = buf.length;
        return ptr;
    }

    let len = arg.length;
    let ptr = malloc(len, 1) >>> 0;

    const mem = getUint8Memory0();

    let offset = 0;

    for (; offset < len; offset++) {
        const code = arg.charCodeAt(offset);
        if (code > 0x7F) break;
        mem[ptr + offset] = code;
    }

    if (offset !== len) {
        if (offset !== 0) {
            arg = arg.slice(offset);
        }
        ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
        const view = getUint8Memory0().subarray(ptr + offset, ptr + len);
        const ret = encodeString(arg, view);

        offset += ret.written;
        ptr = realloc(ptr, len, offset, 1) >>> 0;
    }

    WASM_VECTOR_LEN = offset;
    return ptr;
}
/**
 * @param {string} secret_text
 * @returns {string}
 */
export function decrypt(secret_text) {
    let deferred2_0;
    let deferred2_1;
    try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(secret_text, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.decrypt(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        deferred2_0 = r0;
        deferred2_1 = r1;
        return getStringFromWasm0(r0, r1);
    } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
    }
}

function notDefined(what) { return () => { throw new Error(`${what} is not defined`); }; }

export function __wbg_log_6507dcafd840b967(arg0, arg1) {
    console.log(getStringFromWasm0(arg0, arg1));
};

export const __wbg_random_26e2d782b541ca6b = typeof Math.random == 'function' ? Math.random : notDefined('Math.random');

export function __wbindgen_throw(arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
};
