var update = function(callback) {
	var data = {
		AppID: plus.runtime.appid,
		System: plus.os.name
	};
	mui.getJSON(queryVersion, getUrlParams(data), function(response) {
		printLog("最新版本信息：" + JSON.stringify(response));
		if (response.success != true) {
			//			showAlert("检测更新失败！");
			callback(true);
			return;
		}
		var data = response.data;
		// 获取本地应用资源版本号
		plus.runtime.getProperty(plus.runtime.appid, function(inf) {
			var version = inf.version;
			printLog("当前应用版本：" + version);
			var compare = compareVersion(version, data.Version);
			printLog("compare = " + compare);
			if (compare) {
				// 下载安装文件
				callback(false);
				plus.ui.confirm("有新版本，请立即更新！", function(i) {
						plus.runtime.openURL(data.Url);
					plus.runtime.quit();
				}, data.System, ["立即更新"]);
			} else {
				callback(true);
			}
		});
	});
};
/**
 * 比较版本大小，如果新版本nv大于旧版本ov则返回true，否则返回false
 * @param {String} ov
 * @param {String} nv
 * @return {Boolean}
 */
var compareVersion = function(ov, nv) {
	if (!ov || !nv || ov == "" || nv == "") {
		return false;
	}
	var b = false,
		ova = ov.split(".", 4),
		nva = nv.split(".", 4);
	for (var i = 0; i < ova.length && i < nva.length; i++) {
		var so = ova[i],
			no = parseInt(so),
			sn = nva[i],
			nn = parseInt(sn);
		if (nn > no || sn.length > so.length) {
			return true;
		} else if (nn < no) {
			return false;
		}
	}
	if (nva.length > ova.length && 0 == nv.indexOf(ov)) {
		return true;
	}
	return false;
};