/**
 * 本模块封装了Android、iOS的应用权限判断、打开应用权限设置界面、以及位置系统服务是否开启
 */
// -1拒绝授权 0 未请求 1已授权
var location = 0;
var isConfirm = false;
var isIos;
let systemInfo = {};
// #ifdef APP
isIos = (plus.os.name == "iOS")

systemInfo = uni.getWindowInfo();
let device = uni.getDeviceInfo();
systemInfo.platform = device.platform;
systemInfo.system = device.system;
systemInfo.brand = device.deviceBrand;
// #endif

// 判断推送权限是否开启
function judgeIosPermissionPush() {
	var result = false;
	var UIApplication = plus.ios.import("UIApplication");
	var app = UIApplication.sharedApplication();
	var enabledTypes = 0;
	if (app.currentUserNotificationSettings) {
		var settings = app.currentUserNotificationSettings();
		enabledTypes = settings.plusGetAttribute("types");
		console.log("enabledTypes1:" + enabledTypes);
		if (enabledTypes == 0) {
			console.log("推送权限没有开启");
		} else {
			result = true;
			console.log("已经开启推送功能!")
		}
		plus.ios.deleteObject(settings);
	} else {
		enabledTypes = app.enabledRemoteNotificationTypes();
		if (enabledTypes == 0) {
			console.log("推送权限没有开启!");
		} else {
			result = true;
			console.log("已经开启推送功能!")
		}
		console.log("enabledTypes2:" + enabledTypes);
	}
	plus.ios.deleteObject(app);
	plus.ios.deleteObject(UIApplication);
	return result;
}

// 判断定位权限是否开启
function judgeIosPermissionLocation() {
	var result = false;
	var cllocationManger = plus.ios.import("CLLocationManager");
	var status = cllocationManger.authorizationStatus();
	result = (status != 2)
	//console.log("定位权限开启：" + result);
	// 以下代码判断了手机设备的定位是否关闭，推荐另行使用方法 checkSystemEnableLocation
	/* var enable = cllocationManger.locationServicesEnabled();
	var status = cllocationManger.authorizationStatus();
	console.log("enable:" + enable);
	console.log("status:" + status);
	if (enable && status != 2) {
		result = true;
		console.log("手机定位服务已开启且已授予定位权限");
	} else {
		console.log("手机系统的定位没有打开或未给予定位权限");
	} */
	plus.ios.deleteObject(cllocationManger);
	return result;
}

// 判断麦克风权限是否开启
function judgeIosPermissionRecord() {
	var result = false;
	var avaudiosession = plus.ios.import("AVAudioSession");
	var avaudio = avaudiosession.sharedInstance();
	var status = avaudio.recordPermission();
	//console.log("permissionStatus:" + status);
	if (status === 1970168948) {
	    result = null;
	} else if (status === 1735552628) {
	    result = true;
	}
	plus.ios.deleteObject(avaudiosession);
	return result;
}

// 判断相机权限是否开启
function judgeIosPermissionCamera() {
	var result = false;
	var AVCaptureDevice = plus.ios.import("AVCaptureDevice");
	var authStatus = AVCaptureDevice.authorizationStatusForMediaType('vide');
	//console.log("authStatus:" + authStatus);
	if (authStatus == 3) {
		result = true;
		console.log("相机权限已经开启");
	} else {
		console.log("相机权限没有开启");
	}
	plus.ios.deleteObject(AVCaptureDevice);
	return result;
}

// 判断相册权限是否开启
function judgeIosPermissionPhotoLibrary() {
	var result = false;
	var PHPhotoLibrary = plus.ios.import("PHPhotoLibrary");
	var authStatus = PHPhotoLibrary.authorizationStatus();
	if (authStatus === 0 || authStatus == 3) {
	    result = true;
	}
	plus.ios.deleteObject(PHPhotoLibrary);
	return result;
}

// 判断通讯录权限是否开启
function judgeIosPermissionContact() {
	var result = false;
	var CNContactStore = plus.ios.import("CNContactStore");
	var cnAuthStatus = CNContactStore.authorizationStatusForEntityType(0);
	if (cnAuthStatus == 3) {
		result = true;
		console.log("通讯录权限已经开启");
	} else {
		console.log("通讯录权限没有开启");
	}
	plus.ios.deleteObject(CNContactStore);
	return result;
}

// 判断日历权限是否开启
function judgeIosPermissionCalendar() {
	var result = false;
	var EKEventStore = plus.ios.import("EKEventStore");
	var ekAuthStatus = EKEventStore.authorizationStatusForEntityType(0);
	if (ekAuthStatus == 3) {
		result = true;
		console.log("日历权限已经开启");
	} else {
		console.log("日历权限没有开启");
	}
	plus.ios.deleteObject(EKEventStore);
	return result;
}

// 判断备忘录权限是否开启
function judgeIosPermissionMemo() {
	var result = false;
	var EKEventStore = plus.ios.import("EKEventStore");
	var ekAuthStatus = EKEventStore.authorizationStatusForEntityType(1);
	if (ekAuthStatus == 3) {
		result = true;
		console.log("备忘录权限已经开启");
	} else {
		console.log("备忘录权限没有开启");
	}
	plus.ios.deleteObject(EKEventStore);
	return result;
}

// Android权限查询
function requestAndroidPermission(permissionID) {
	return new Promise((resolve, reject) => {
		plus.android.requestPermissions(
			permissionID.split(","),  
			//[permissionID], // 理论上支持多个权限同时查询，但实际上本函数封装只处理了一个权限的情况。有需要的可自行扩展封装
			function(resultObj) {
				var result = 0;
				for (var i = 0; i < resultObj.granted.length; i++) {
					var grantedPermission = resultObj.granted[i];
					//console.log('已获取的权限：' + grantedPermission);
					result = 1
				}
				for (var i = 0; i < resultObj.deniedPresent.length; i++) {
					var deniedPresentPermission = resultObj.deniedPresent[i];
					//console.log('拒绝本次申请的权限：' + deniedPresentPermission);
					result = 0
				}
				for (var i = 0; i < resultObj.deniedAlways.length; i++) {
					var deniedAlwaysPermission = resultObj.deniedAlways[i];
					//console.log('永久拒绝申请的权限：' + deniedAlwaysPermission);
					result = -1
				}
				resolve(result);
				// 若所需权限被拒绝,则打开APP设置界面,可以在APP设置界面打开相应权限
				// if (result != 1) {
				// gotoAppPermissionSetting()
				// }
			},
			function(error) {
				//console.log('申请权限错误：' + error.code + " = " + error.message);
				resolve({
					code: error.code,
					message: error.message
				});
			}
		);
	});
}

// IOS使用一个方法，根据参数判断权限
function judgeIosPermission(permissionID) {
	return new Promise((resolve, reject) => {
	    switch (permissionID) {
	        case "push":
	            resolve(judgeIosPermissionPush());
	            break;
	        case "location":
	            resolve(judgeIosPermissionLocation());
	            break;
	        case "record":
	            resolve(judgeIosPermissionRecord());
	            break;
	        case "camera":
	            resolve(judgeIosPermissionCamera());
	            break;
	        case "contact":
	            resolve(judgeIosPermissionContact());
	            break;
	        case "calendar":
	            resolve(judgeIosPermissionCalendar());
	            break;
	        case "memo":
	            resolve(judgeIosPermissionMemo());
	            break;
			case "photoLibrary":
				resolve(judgeIosPermissionPhotoLibrary());
				break;
	        default:
	            resolve(false);
	            break;
	    }
	});
}

// 跳转到**应用**的权限页面
function gotoAppPermissionSetting() {
	if (isIos) {
		var UIApplication = plus.ios.import("UIApplication");
		var application2 = UIApplication.sharedApplication();
		var NSURL2 = plus.ios.import("NSURL");
		// var setting2 = NSURL2.URLWithString("prefs:root=LOCATION_SERVICES");		
		var setting2 = NSURL2.URLWithString("app-settings:");
		application2.openURL(setting2);

		plus.ios.deleteObject(setting2);
		plus.ios.deleteObject(NSURL2);
		plus.ios.deleteObject(application2);
	} else {
		// console.log(plus.device.vendor);
		var Intent = plus.android.importClass("android.content.Intent");
		var Settings = plus.android.importClass("android.provider.Settings");
		var Uri = plus.android.importClass("android.net.Uri");
		var mainActivity = plus.android.runtimeMainActivity();
		var intent = new Intent();
		intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
		var uri = Uri.fromParts("package", mainActivity.getPackageName(), null);
		intent.setData(uri);
		mainActivity.startActivity(intent);
	}
}

// 检查系统的设备服务是否开启
// var checkSystemEnableLocation = async function () {
function checkSystemEnableLocation() {
	if (isIos) {
		var result = false;
		var cllocationManger = plus.ios.import("CLLocationManager");
		var result = cllocationManger.locationServicesEnabled();
		console.log("系统定位开启:" + result);
		plus.ios.deleteObject(cllocationManger);
		return result;
	} else {
		var context = plus.android.importClass("android.content.Context");
		var locationManager = plus.android.importClass("android.location.LocationManager");
		var main = plus.android.runtimeMainActivity();
		var mainSvr = main.getSystemService(context.LOCATION_SERVICE);
		var result = mainSvr.isProviderEnabled(locationManager.GPS_PROVIDER);
		console.log("系统定位开启:" + result);
		return result
	}
}
// 动态检测授权
function writeStorage(url, App) {
	saveBtmap(url, App);
}

// 保存临时图片
function saveBtmap(hburl, App){
	uni.showLoading({
		title: '加载中',
		mask: true
	});
	uni.request({
		url: hburl,
		method: 'GET',
		header: {
			 'Referer': App.globalData.weburl
		},
		responseType: 'arraybuffer',
		success: res => {
			let base64 = uni.arrayBufferToBase64(res.data); //把arraybuffer转成base64
			let bitmap = new plus.nativeObj.Bitmap('haibao');
			// 加载Base64编码格式图片到Bitmap对象  
			bitmap.loadBase64Data('data:image/jpeg;base64,' + base64, function(){  
				//console.log("加载Base64图片数据成功");
				var fileName = Date.now() + '.png';
				bitmap.save("_doc/" + fileName, {}, function(i) {
					let url = i.target;
					uni.hideLoading();
					uni.navigateTo({
						url: '/pet/pages/haibao/comhb',
						success: function(res) {
						    // 通过eventChannel向被打开页面传送数据
							let data = {url: url, fileName: fileName}
						    res.eventChannel.emit('acceptPic', data);
						}
					})
					//console.log('保存图片成功：' + JSON.stringify(i));
					bitmap.clear();
				}, function(e) {
					bitmap.clear();
					uni.hideLoading();
					//console.log('保存图片失败：' + JSON.stringify(e));
				});
			}, function(e){  
				bitmap.clear();
				uni.hideLoading();
				//console.log('加载Base64图片数据失败：'+JSON.stringify(e));  
			} );
		}
	});
}
// APP保存海报图片
function downpic(url, fileName) {
	// 增加判断，防止首次授权后，会重复调用
	plus.gallery.save(url, function(e) {
		//console.log('保存到相册成功：' + JSON.stringify(e));
		if (plus.os.name == "iOS") {
			var title = '图片已保存至系统相册';
		} else {
			var title = '图片已保存至 手机存储/DCIM/Camera/' + fileName;
		}
		uni.showToast({
			title: title,
			position: 'bottom'
		});
	}, function(e) {
		//console.log('保存到相册失败：' + JSON.stringify(e));
		if (plus.os.name == "iOS") {
			if(e.code == 2){
				uni.showToast({
					title: '图片保存失败：缺少照片存储权限',
					position: 'bottom'
				});
			}
		} else {
			if(e.code == 12){
				uni.showToast({
					title: '图片保存失败：缺少存储权限',
					position: 'bottom'
				});
			}
		}
	})
}
// 动态检测授权
async function requestGallery(url, fileName) {
	if (plus.os.name == "iOS") {
		let result = await judgeIosPermission('photoLibrary');
		if (!result) {
			uni.showModal({
				title: '温馨提示',
				content: '需要您授予照片权限，来保存海报，权限尚未开启，请在设置中打开',
				cancelText: '不允许',
				confirmText: '继续',
				success(res) {
					if (res.confirm) {
						gotoAppPermissionSetting();
					}
				}
			});
		} else {
			downpic(url, fileName);
		}
	} else {
		let result = await premissionCheck('android.permission.WRITE_EXTERNAL_STORAGE',false);
		if (result == 1) {
			downpic(url, fileName);
		} else{
			uni.showModal({
				title: '温馨提示',
				content: '需要您授予存储权限，来保存海报，权限尚未开启，请在设置中打开',
				cancelText: '不允许',
				confirmText: '继续',
				success(res) {
					if (res.confirm) {
						gotoAppPermissionSetting();
					}
				}
			});
		}
	}
}
// 根据缓存处理拨打电话权限
function callPhoneStorage(phone, callback = null) {
	
	requestCallPhone(phone, callback);
	
}
// 拨打电话权限
async function requestCallPhone(phone, callback = null) {
	if (isIos) {
		uni.makePhoneCall({
			phoneNumber: phone,
			success: function(){
				typeof callback === 'function' && callback();
			}
		});
	} else {
		let result = await premissionCheck('android.permission.CALL_PHONE',false);
		if (result == 1) {
			uni.makePhoneCall({
				phoneNumber: phone,
				success: function(){
					typeof callback === 'function' && callback();
				}
			});
		} else{
			uni.showModal({
				title: '温馨提示',
				content: '拨打电话权限尚未开启，请在设置中打开',
				cancelText: '不允许',
				confirmText: '继续',
				success(res) {
					if (res.confirm) {
						gotoAppPermissionSetting();
					}
				}
			});
		}
	}
}
// 定位、打开地图选择位置请求授权
function localPermission(callback, title = '', cancel = null, scope = 'getLocation',negative=false){
	if(scope == 'chooseLocation'){
		// 与自动定位不同，地图上选择位置是用户主动发起的，需每次都请求权限，否则会造成点没反应
		location = 0;
	}
	uni.getStorage({
		key: 'local_permission',
		success: function(res) {
			requestLoaction(callback, cancel, scope,negative);
		},
		fail() {
			if(title != ''){
				uni.setStorage({
					key: 'local_permission',
					data: 1
				});
				requestLoaction(callback, cancel, scope,negative);
			}
		}
	});
}
async function requestLoaction(callback, cancel = null, scope = 'getLocation',negative=false) {
	if (isIos) {
		var result = await judgeIosPermission("location");
		if (result) {
			location = 1;
			loationFunc(callback, scope);
		}else{
			if(location != -1){
				location = -1;
				locationConfirm(cancel);
			}
		}
	} else {
		
		let result = await premissionCheck('permission_LOCATION',false,negative);
		location = result;
		if (result == 1) {
			location = 1;
			loationFunc(callback, scope);
		}else{
			
			if(result == 2){
				location = -1;
				typeof cancel === 'function' && cancel('reject');
			}else{
				locationConfirm(cancel);
			}
		}
	}
}

function loationFunc(callback, scope = 'getLocation'){
	if(scope == 'chooseLocation'){
		// 打开地图选择位置
		uni.chooseLocation({
			success: function(res) {
				callback(res);
			},
			fail: function(e) {}
		});
	}else{
		// 定位
		callback();
	}
}
function locationConfirm(cancel = null){
	uni.showModal({
		title: '温馨提示',
		content: '位置信息权限尚未开启，请在设置中打开',
		cancelText: '不允许',
		confirmText: '继续',
		success(res) {
			if (res.confirm) {
				isConfirm = true;
				gotoAppPermissionSetting();
			}else{
				typeof cancel === 'function' && cancel('cancel');
			}
		}
	});
}
function requestlocationConfirm(content, success, cancel = null){
	uni.showModal({
		title: '温馨提示',
		content: content,
		cancelText: '不允许',
		confirmText: '继续',
		success(res) {
			if (res.confirm) {
				typeof success === 'function' && success();
			}else{
				typeof cancel === 'function' && cancel('cancel');
			}
		}
	});
}

function getLocationConfirm(){
	return isConfirm;
}
function resetLocationConfirm(){
	isConfirm = false;
}
let permissionMap = {    
    "android": {    
        "android.permission.CAMERA": {    
            "name": "android.permission.CAMERA",    
            "title": "相机权限说明",    
            "content": "便于您使用该功能上传您拍摄的照片及用于更换头像、发布信息添加图片、聊天发送图片"    
        }, 
		"android.permission.WRITE_EXTERNAL_STORAGE": {
		    "name": "android.permission.WRITE_EXTERNAL_STORAGE",    
		    "title": "相册权限说明",    
		    "content": "便于您使用该功能保存海报或图片、聊天发送图片等场景中读取相册和文件内容"    
		},
		"android.permission.CALL_PHONE": {    
            "name": "android.permission.CALL_PHONE",    
            "title": "拨打电话权限说明",    
            "content": "便于您使用该功能联系客服和用户或者客服和用户与您联系等场景"    
        },
		"android.permission.RECORD_AUDIO": {
		    "name": "android.permission.RECORD_AUDIO",    
		    "title": "麦克风/录音权限说明",    
		    "content": "便于您使用该功能和用户进行语音信息联系等场景"    
		},
		"permission_LOCATION": {
			"name": "android.permission.ACCESS_FINE_LOCATION",  
			"title": "定位权限说明",  
			"content": "便于您发布信息时添加位置信息，或搜索指定位置的相关服务"  
		}, 
		"IMAGES_STORAGE": {
			"name": "android.permission.READ_EXTERNAL_STORAGE",  
			"title": "相册权限说明",  
			"content": "便于您使用该功能保存海报或图片、聊天发送图片等场景中读取相册和文件内容"  
		}, 
	},    
    "ios": {}    
}    
// 高于android 13的设备增加申请android.permission.READ_MEDIA_IMAGES
if(systemInfo.platform=='android'){
	let androidVer = parseInt(systemInfo.system.replace("Android", "").trim());
	if(androidVer>=13){
		permissionMap.android['IMAGES_STORAGE']['name'] = 'android.permission.READ_MEDIA_IMAGES,android.permission.READ_EXTERNAL_STORAGE';
		// 高于android 13的设备 WRITE_EXTERNAL_STORAGE 权限已废弃，要改权限
		permissionMap.android['android.permission.WRITE_EXTERNAL_STORAGE']['name'] = 'android.permission.READ_MEDIA_IMAGES';
	}
}
let view = null;    
var viewShow = true;
function showViewDesc(permission) {    
    let plat = isIos ? "ios" : "android";    
    view = new plus.nativeObj.View('per-modal', {    
        top: '0px',    
        left: '0px',    
        width: '100%',    
        backgroundColor: 'rgba(0,0,0,0.2)',    
        //opacity: '.9'       
    })    
    view.drawRect({    
        color: '#fff',    
        radius: '5px'    
    }, {    
        top: '30px',    
        left: '5%',    
        width: '90%',    
        height: "100px",    
    })    
    view.drawText(permissionMap[plat][permission]["title"], {    
        top: '40px',    
        left: "8%",    
        height: "30px"    
    }, {    
        align: "left",    
        color: "#000",    
    }, {    
        onClick: function(e) {    
            console.log(e);    
        }    
    })    
    view.drawText(permissionMap[plat][permission]["content"], {    
        top: '65px',    
        height: "60px",    
        left: "8%",    
        width: "84%"    
    }, {    
        whiteSpace: 'normal',    
        size: "14px",    
        align: "left",    
        color: "#656563"    
    })   
	setTimeout(()=>{  
		if(viewShow) view.show()  
	},200)  
}    
//negative:true时 为被动触发权限，此时需要根据缓存阻止权限获取，反之为手动主动触发不需要根据缓存。
function premissionCheck(permission,runDenied=true,negative=false) {    
    return new Promise(async (resolve, reject) => {    
        let plat = isIos ? "ios" : "android";    
        if (isIos) { // ios    
            // const camera = permission.judgeIosPermission("camera");//判断ios是否给予摄像头权限    
            // //ios相册没权限，系统会自动弹出授权框    
            // //let photoLibrary = permission.judgeIosPermission("photoLibrary");//判断ios是否给予相册权限    
            // if(camera){    
            //     resolve();    
            // }else{    
            //     reject('需要开启相机使用权限');    
            // }    
            resolve(1)    
        } else { // android    
            let permission_arr = permissionMap[plat][permission]["name"].split(",");    
			let flag = true;    
			// 目前数组格式权限只有相册一个，里面只需要检查android.permission.READ_MEDIA_IMAGES。循环检查先注释掉，后面有需要可以调整
			// for(let i = 0;i<permission_arr.length;i++) {    
			// 	let status = plus.navigator.checkPermission(permission_arr[i]);    
			// 	if(status == "undetermined") {    
			// 		flag = false;    
			// 	}    
			// }    
			let status = plus.navigator.checkPermission(permission_arr[0]);
			if(status == "undetermined") {
				flag = false;    
			}       
			if (flag == false) { // 未完全授权     
				androidPermissionStorage(permission,negative)
				.then(()=>{
					showViewDesc(permission);
					requestAndroidPermission(permissionMap[plat][permission]["name"]).then((res) => {   
						viewShow = false; 
						setTimeout(()=>{  
							viewShow = true;  
						},120)  
						view.close();    
						if(res != 1 && negative){
							let nowtime = new Date().getTime();
							uni.setStorage({
								key: permission,
								data: nowtime
							});
						}
						if (res == -1) {    
							
							if(runDenied){
								uni.showModal({
									title: '提示',    
									content: '操作权限已被拒绝，请手动前往设置',    
									confirmText: "立即设置",    
									success: (res) => {    
										if (res.confirm) {    
											gotoAppPermissionSetting()    
										}    
									}    
								}) 
							}
						}    
						
						resolve(res)    
					})  
				})
				.catch(()=>{//过去48小时以内拒绝授权的不请示权限，
					resolve(2)  
				});
            } else {    
                resolve(1)    
            }    
        }    
    })    
}   
function androidPermissionStorage(permission,negative=false) {
    
	return new Promise((resolve, reject)=>{
		if(negative){
			let nowtime = new Date().getTime();
			uni.getStorage({
				key: permission,
				success: (res) => {
					if(nowtime - parseInt(res.data) > 48*3600*1000){
						resolve();
					}else{
						// 48小时内的，按reject处理
						reject();
					}
				},
				fail: () =>{
					resolve();
				}
			});
		}else{
			resolve();
		}
	})
}
export default {
	judgeIosPermission,
	requestAndroidPermission,
	checkSystemEnableLocation,
	gotoAppPermissionSetting,
	writeStorage,
	callPhoneStorage,
	localPermission,
	getLocationConfirm,
	resetLocationConfirm,
	premissionCheck,
	requestGallery
}
