var mainJsInterface = window["MainJsInterface"];
var webViewJsInterface = window["WebViewJsInterface"];
var listJsInterface = window["ListJsInterface"];
var favJsInterface = window["FavJsInterface"];
var articleJsInterface = window["ArticleJsInterface"];
var systemJsInterface = window["SystemJsInterface"];
var appJsInterface = window["AppJsInterface"];
var cacheJsInterface = window["CacheJsInterface"];

var jsi = {
	getFirstRecommenedArticle : function(callback) {
		try { mainJsInterface.getFirstRecommenedArticle(callback); } catch(e) {log(e);}
	},
	getRecommendArticleList : function(exceptFirst, callback) {
		try { mainJsInterface.getRecommendArticleList(exceptFirst, callback); } catch(e) {log(e);}
	},
	isJeejenPhone : function() {
		try { return mainJsInterface.isJeejenPhone(); } catch(e) {log(e); return false;}
	},

	showMenu : function() {
		try { webViewJsInterface.showMenu(); } catch(e) {log(e);}
	},
	registerCallback : function(callback) {
		try { webViewJsInterface.registerCallback(callback); } catch(e) {log(e);}
	},
	delChoosedArticles : function(json) {
		try { webViewJsInterface.delChoosedArticles(json); } catch(e) {log(e);}
	},
	startLoadingJs : function() {
		try { webViewJsInterface.startLoadingJs(); } catch(e) {log(e);}
	},
	stopLoadingJs : function() {
		try { webViewJsInterface.stopLoadingJs(); } catch(e) {log(e);}
	},

	getArticleListByCatId : function(catId, callback) {
		try { listJsInterface.getArticleListByCatId(catId, callback); } catch(e) {log(e);}
	},

	getFavoriteArticleList : function(callback) {
		try { favJsInterface.getFavoriteArticleList(callback); } catch(e) {log(e);}
	},
	searchFav : function(key, callback) {
		try { favJsInterface.search(key, callback); } catch(e) {log(e);}
	},
	toggleInput : function() {
		try { favJsInterface.toggleInput(); } catch(e) {log(e);}
	},
	toggleInputMethod : function(show) {
		try { favJsInterface.toggleInputMethod(show); } catch(e) { try { favJsInterface.toggleInput(); } catch(e2) {log(e2);} log(e);}
	},

	isFavArticle : function(uri) {
		try { return articleJsInterface.isFavArticle(uri); } catch(e) {log(e); return false;}
	},
	storeArticle : function(uri) {
		try { return articleJsInterface.storeArticle(uri); } catch(e) {log(e); return false;}
	},
	setArticleToRead : function(uri) {
		try { articleJsInterface.setArticleToRead(uri); } catch(e) {log(e);}
	},
	speech : function(uri) {
		try { return articleJsInterface.speech(uri); } catch(e) {log(e); return false;}
	},
	stopSpeech : function() {
		try { articleJsInterface.stopSpeech(); } catch(e) {log(e);}
	},
	getArticleContent : function(uri, callback) {
		try { return articleJsInterface.getArticleContent(uri, callback); } catch(e) {log(e); return "";}
	},
	getArticleInfo : function(uri, callback) {
		try { articleJsInterface.getArticleInfo(uri, callback); } catch(e) {log(e);}
	},

	setSystemUIStatus : function(show) {
		try { mainJsInterface.setSystemUIStatus(show); } catch(e) {log(e);}
	},
	isEnableFullScreen : function() {
		try { return mainJsInterface.isEnableFullScreen(); } catch(e) {log(e); return false;}
	},
	
	getStatusBarHeight : function() {
		try { return systemJsInterface.getStatusBarHeight(); } catch(e) {log(e); return 0;}
	},
	getSdkVersion : function() {
		try { return systemJsInterface.getSdkVersion(); } catch(e) {log(e); return 0;}
	},
	getScreenWidth : function() {
		try { return systemJsInterface.getScreenWidth(); } catch(e) {log(e); return 0;}
	},
	getScreenHeight : function() {
		try { return systemJsInterface.getScreenHeight(); } catch(e) {log(e); return 0;}
	},
	
	getContextPath : function() {
		try { return appJsInterface.getContextPath(); } catch(e) {log(e); return "";}
	},
	isUnderContext : function(path) {
		try { return appJsInterface.isUnderContext(path); } catch(e) {log(e); return false;}
	},
	
	setFrContent : function(content) {
		try { cacheJsInterface.setFrContent(content); } catch(e) {log(e);}
	},
	getFrContent : function() {
		try { return cacheJsInterface.getFrContent(); } catch(e) {log(e); return "";}
	},
	getRecommendList : function() {
		try { return cacheJsInterface.getRecommendList(); } catch(e) {log(e); return "";}
	},
	setRecommendList : function(list) {
		try { cacheJsInterface.setRecommendList(list); } catch(e) {log(e);}
	},
	getIntentData: function() {
	    try { return appJsInterface.getIntentData();} catch(e) {log(e);}
	}
};