var view = {
	getListDivider : function() {
		return "<div class='divider'></div>";
	},
	getSelectableListItem : function(id, title, isRead, checkboxClass, onArticleClick) {
        //var css = isRead ? "list-item readed" : "list-item";
        var css = isRead ? " class='readed'" : "";
		return "<div class='list-item' onclick='" + onArticleClick + "(" + id + ");'><img id='img_select_" + id 
			+ "' src='image/1080/common_choose_btn.png' class='" + checkboxClass + "' /><span id='" + view.getItemTitleId(id) + "' " + css + ">" + title + "</span></div>";
	},
	getListItem : function(id, title, isRead, onArticleClick) {
        var css = isRead ? " class='readed'" : "";
		return "<div class='list-item' onclick='" + onArticleClick + "(" + id + ");'><span id='" + view.getItemTitleId(id) + "' " + css + ">" + title + "</span></div>";
	},
	showEmptyTip : function(container, emptyAlert) {
		var html = "<div class='empty-box'><span>" + emptyAlert + "</span></div>";
		container.html(html);
	},
	showList : function(container, list, selectable, checkboxClass, onArticleClick, showLastDivider, emptyAlert, showReadStatus) {
		container.empty();
        if (utils.isNull(list) || list.length <= 0) {
			if (!utils.isNull(emptyAlert)) {
				view.showEmptyTip(container, emptyAlert);
			}
            return;
        }

		var divider = view.getListDivider();
		for (index in list) {
			var item = list[index];
            if (utils.isNull(item)) {
                continue;
            }

			var id = item[0];
			var title = item[1];
            var isRead = showReadStatus ? item[2] : false;
			var itemHtml = selectable ? view.getSelectableListItem(id, title, isRead, checkboxClass, onArticleClick) 
				: view.getListItem(id, title, isRead, onArticleClick);
			container.append(itemHtml);
			if (showLastDivider) {
				container.append(divider);
			} else {
				if (index < list.length - 1) {
					container.append(divider);
				}
			}
		}
	},
	parseJsonList : function (result) {
		var list = new Array();
        if (utils.isNull(result)) {
            return list;
        }

		var json = jQuery.parseJSON(result);
        if (utils.isNull(json) || json.status != 0 || utils.isNull(json.root)) {
            return list;
        }

		for (index in json.root) {
			var article = json.root[index];
            if (utils.isNull(article)) {
                continue;
            }

			list.push(new Array(article.uri, article.title, article.isRead));
		}
		return list;
	},
	showFirstRecommend : function(container, id, imgPath, title, onArticleClick) {
		container.empty();
		container.append("<div onclick='" + onArticleClick + "(" + id + ");'><img src='" + view.checkImagePath(id, imgPath) + "' class='fr-img' /><div class='fr-mask'></div><span class='fr-title'>" + title + "</span></div>");
	},
    showPhoneStatusBar : function (show, statusBar) {
		if (!jsi.isJeejenPhone()) {
			jsi.setSystemUIStatus(show);
			return;
		}
				
        if (jsi.isEnableFullScreen()) {
            jsi.setSystemUIStatus(show);
        }
    },
    checkImagePath : function (id, imgPath) {
		if (jsi.isUnderContext(imgPath) && jsi.getSdkVersion() < 11) {
			return Consts.IMAGE_URL + id;
		}
		return imgPath;
	},
	getItemTitleId : function (id) {
		return "item_title_" + id;
	}
};
