(function($, window, undefind) {
	if ($.care) {
		return;
	}

	var PRODUCTID = "care";
	var care = $.care = {};

	care.getServiceInfo = function getServiceInfo(callback) {
		var params = {
			deviceID: $.service_common.getDeviceID(),
			oemType: $.service_common.getOemType(),
			packageName: $.service_common.getPackage(),
			version: $.service_common.getVersion()
		};

		post(PROTOCOL.GET_SERVICE_INFO_URL, params, function(json) {
			try {
				if (json.code != 200 || !json.data || !json.data.url) {
					return callback(json);
				}

				callback(null, {
					url: json.data.url
				})
			} catch (err) {
				callback(err);	
			}
		}, function (err) {
			callback(err);
		})
	}

	care.createOrder = function createOrder(callback) {
		var params = {
			deviceID: $.service_common.getDeviceID(),
			productID: PRODUCTID
		};

		post(PROTOCOL.CREATE_ORDER_URL, params, function(json) {
			try {
				if (json.code != 200 || !json.data) {
					return callback(json);
				}

				var order = json.data.order;
				var wxPrePay = json.data.wxPrePay;
				var product = JSON.parse(order.OrderPayload).Product;
				var productPayload = JSON.parse(product.ProductPayload);
				callback(null, {
					orderID: order.OrderId,
					price: order.OrderFee,
					priceLabel: productPayload.PriceLabel,
					productTitle: product.ProductTitle,
					url: wxPrePay.ScanCodeUrl,
					_source: order
				});
			} catch (err) {
				callback(err);
			}
		}, function(err) {
			callback(err);
		})
	}

	care.checkOrderStatus = function checkOrderStatus(orderID, callback) {
		var params = {
			orderID: orderID
		};

		post(PROTOCOL.CHECK_ORDER_STATUS_URL, params, function(json) {
			try {
				if (json.code != 200 || !json.data) {
					return callback(json);
				}

				var orderStatus = json.data.order.OrderState;
				callback(null, {
					paid: orderStatus.State == 'PAID'
				});
			} catch (err) {
				callback(err);
			}
		}, function(err) {
			callback(err);
		})
	}

	care.fillUserInfo = function fillUserInfo(orderID, info, callback) {
		var params = {
			deviceID: $.service_common.getDeviceID(),
			orderID: orderID,
			info: info
		};

		post(PROTOCOL.FILL_USER_INFO_URL, params, function(json) {
			callback(null, json);
		}, function(err) {
			callback(err);
		})
	}

	var HOST = 'http://family.jeejen.com/care';
	var PROTOCOL = {
		GET_SERVICE_INFO_URL: HOST + '/biz/get_service_info',
		CREATE_ORDER_URL: HOST + '/biz/create_service_order',
		CHECK_ORDER_STATUS_URL: HOST + '/biz/check_order_status',
		FILL_USER_INFO_URL: HOST + '/biz/set_user_info'
	}
	var post  = function(url, data, succeed, failed) {
		$.ajax({
				type : "POST",
				url : url,
				data: JSON.stringify(data),
				async : true,
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					if (XMLHttpRequest.status == 200) {
						succeed();
					} else {
						failed(errorThrown || "err");
					}
				},
				success: function(data) {
					try {
						var json = jQuery.parseJSON(data);
						if (json.code != 200) {
							return failed(json);
						}

						succeed(json);
					} catch (err) {
						failed(err);
					}
				}
		});
	}

}(jQuery, window))