
(function($, window, undefined) {
	if ($.service_common) {
		return;
	}

	var debug = true;
	var common = $.service_common = {};

	var JSISystem = window["android.system"];
	var JSIAndroid = window["android.app"];
	var JSIShopView = window["shop.view"]
	common.gotoLauncher = function() {
		var packageName = JSISystem.getPackageName();
		var intent = {
			"component": {
				"package": packageName,
				"class": "com.jeejen.home.launcher.Launcher"
			}
		}
		var i = JSIAndroid.getIntent(JSON.stringify(intent));
		JSIAndroid.finish()
		JSIAndroid.startActivity(i)
	}
	common.toast = function(msg) {
		try {
			JSISystem.toast(msg);
		} catch (err) {
			console.log(msg);
			console.log(err);
		}
	}

	common.getDeviceID = function() {
		try {
			return JSIShopView.getDeviceID();
		} catch (err) {
			return 'unknow';
		}
	}

	common.getVersion = function() {
		try {
			return JSISystem.getVersionName();
		} catch (err) {
			return "unknow";
		}
	}

	common.getPackage = function() {
		try {
			return JSISystem.getPackageName();
		} catch (err) {
			return "unknow";
		}
	}

	common.getOemType = function() {
		try {
			return JSIShopView.getOemType();
		} catch (err) {
			return "unknow";
		}
	}

	common.setTitle = function(title) {
		try {
			JSIShopView.setTitle(title);
		} catch (err) {
		}
	}
}(jQuery, window));