(function($, window, undefined) {
if ($.store == undefined) {
	store = $.store = {};
}

var component = store.component = {};

component.appDownloader = function(url, autoInstall, callback){
	var _DOWNLOAD_STATUS = {
		Normal : 0,
		Downloading : 1,
		Downloaded : 2,
		DownloadFailed : 3
	};
	this._url = url;
	this._status = _DOWNLOAD_STATUS.Normal;
	this._autoInstall = autoInstall;
	this._callback = callback;
	this._interval = 2000;
	this._taskId = -1;
	
	var _self = this;
	
	this.download = function(renew) {
		if (_self._status == _DOWNLOAD_STATUS.Downloading || _self._status == _DOWNLOAD_STATUS.Downloaded) {
			return;
		}
		if (renew != true) {
			renew = false;
		}
		_self._status = _DOWNLOAD_STATUS.Downloading;
		
		var succeed = _exjs.downloadApkFile(_self._url, renew);
		if (!succeed) {
			_self._status = _DOWNLOAD_STATUS.Normal;
			_exjs.toast("请插入存储卡");
			return;
		}
		callback.onDownload();
		
		if (renew) {
			_self.cleartime();
		}
		
		if (_self._taskId == -1) {
			_self._taskId = setTimeout(_self.timeTask, _self._interval);
		}
	};
	this.cancel = function() {
		try {
			_exjs.cancelDownloadApk(_self._url);
			_self._status = _DOWNLOAD_STATUS.Normal;
		} catch (e) {log("cancel "+e)}
	}
	this.onCompleted = function() {
		_self._status = _DOWNLOAD_STATUS.Downloaded;
		_self._callback.onCompleted();
		
		_self.cleartime();
		//if (_self._autoInstall) {
		//	window["store.download"].installApk(_self._url);
		//}
	};
	this.onFailed = function(e) {
		_self.cleartime();
		_self._status = _DOWNLOAD_STATUS.DownloadFailed;
		_self._callback.onFailed(e);
	};
	this.onProgress = function(downloadSize, totalSize) {
		_self._callback.onProgress(downloadSize, totalSize);
	};
	this.getStatus = function() {
		try {
			var status = _exjs.getDownloadStatus(_self._url);
			return status;
		} catch (e) {
		}
	}
	this.timeTask = function() {
		_self.cleartime();
		if (_self._url == null) {
			_self.onFailed();
			return;
		}
		
		_exjs.queryDownloadTask(_self._url, "store.component.appDownloader.manager.callback");
		
		if (_self._taskId == -1) {
			_self._taskId = setTimeout(_self.timeTask, _self._interval);
		}
	};
	this.cleartime = function() {
		if (_self._taskId != -1) {
			clearTimeout(_self._taskId);
			_self._taskId = -1;
		}
	}
}

component.appDownloader.manager = {
	urllist : {},
	create : function(url, autoInstall, cb) {
		var list = null;
		if (this.urllist[url] != null && this.urllist[url] != undefined) {
			list = this.urllist[url];
		} else {
			this.urllist[url] = [];
		}
		
		var downloader = new store.component.appDownloader(url, autoInstall, cb);
		this.urllist[url].push(downloader);
		
		return downloader;
	},
	callback : {
		succeed : function(url, data) {	
			var mgr = store.component.appDownloader.manager;
			var info = jQuery.parseJSON(data);
			var list = mgr.urllist[url];
			
			if (list == null) {
				return;
			}
			for (var i = 0; i < list.length; i++) {
				var downloader = list[i];
				if (downloader == null) {
					continue;
				}
				if (info.status == 16 || info.status == 4) {
					downloader.onFailed(-1000);
					continue;
				}
				
				if (info.status == 8) { //completed;
					downloader.onProgress(info.downloadSize, info.totalSize);
					downloader.onCompleted();
				} else { //percent;
					downloader.onProgress(info.downloadSize, info.totalSize);
				}
			}
		},
		failed : function(url, e) {
			var mgr = store.component.appDownloader.manager;
			var downloader = mgr.urllist[url];
			if (downloader != null) {
				downloader.onFailed(e);
			}
		}
	}
}
}(jQuery, window));
