(function($, window, undefined) {
	isDebug = false;
	isEmpty = function(obj) {
		return obj == null || obj == undefined;
	};
	
	log = function(msg) {
		console.log(msg);
		if (isDebug) {
			log(msg);
		}
	}
	
	var exSystem = window["android.system"];
	var exAndroidApp = window["android.app"];
	var exStoreApp = window["store.app"];
	var exStoreDownload = window["store.download"];
	_exjs = {
		showSystemUIStatus : function(show, topbar) {
			var full = _exjs.getFullScreen();
			if (full) {
				_exjs.setSystemUIStatus(show);
				if (show && !isEmpty(topbar)) {
					var height = _exjs.getStatusBarHeight();
					topbar.css("padding-top", height);
				}
			}
		},
		getProtocolVersion : function() {
			try {return exStoreApp.getProtocolVersion();} catch(e) {log(e);return 0;}
		},
		getFullScreen : function() {
			try {return exStoreApp.getFullScreen();} catch(e) {log(e);return false;}
		},
		getJsData : function(name) {
			try { return exStoreApp.getJsData(name);} catch(e) {log(e);return null;}
		},
		saveJsData : function(name, value) {
			try { exStoreApp.saveJsData(name, value);} catch(e) {log(e);}
		},
		
		registerUpgradeCallback : function (callback) {
			try { exStoreApp.registerUpgradeCallback(callback);} catch(e){log(e);}
		},
		registerDownloadCallback : function(callback) {
			try { exStoreApp.registerDownloadCallback(callback);} catch(e){log(e);}
		},
		
		isInstalled : function(packageName, versionCode) {
			try { return exStoreApp.isInstalled(packageName, versionCode);} catch(e){log(e);return false;}
		},
		isFilter : function(packageName, versionCode) {
			try { return exStoreApp.isFilter(packageName);} catch(e){log(e);return false;}
		},
		startApp : function(packageName) {
			try { exStoreApp.startApp(packageName);} catch(e) {log(e);}
		},
		
		getDownloadTaskCount : function() {
			try { return exStoreApp.getDownloadTaskCount();} catch(e) {log(e); return 0;}
		},
		getDownloadStoreAppInfo : function() {
			try { return exStoreApp.getDownloadStoreAppInfo();} catch(e) {log(e); return null;}
		},
		
		getUpgradeStoreCount : function() {
			try { return exStoreApp.getUpgradeStoreCount();} catch(e) {log(e); return 0;}
		},
		
		getUpgradeStoreAppInfo: function() {
			try { return exStoreApp.getUpgradeStoreAppInfo();} catch(e) {log(e); return null;}
		},
		
		getStoreAppInfo : function(packageName, versionCode) {
			try { return exStoreApp.getStoreAppInfo(packageName, versionCode);} catch(e) {log(e); return null;}
		},
		
		fetchStoreAppInfo : function(packageName, versionCode, callback) {
			try { return exStoreApp.fetchStoreAppInfo(packageName, versionCode, callback);} catch(e) {log(e); return null;}
		},
		
		getDownloadStatus : function(downloadUrl) {
			try {return exStoreDownload.getDownloadStatus(downloadUrl);} catch(e) {log(e); return 0;}
		},
		
		getDownloadReason : function(downloadUrl) {
			try {return exStoreDownload.getDownloadReason(downloadUrl);} catch(e) {log(e); return -1;}
		},
		
		downloadApkFile : function(downloadUrl, renew) {
			try {return exStoreDownload.downloadApkFile(downloadUrl, renew);} catch(e) {log(e); return false;}
		},
		
		cancelDownloadApk: function(downloadUrl) {
			try {exStoreDownload.cancelDownloadApk(downloadUrl);} catch(e) {log(e); return false;}
		},
		
		installApk : function(downloadUrl) {
			try {return exStoreDownload.installApk(downloadUrl);} catch(e) {log(e); return false;}
		},
		
		queryDownloadTask : function(downloadUrl, callback) {
			try {exStoreDownload.queryDownloadTask(downloadUrl, callback);} catch(e){log(e);return false;}
		},
		
		setSystemUIStatus : function(show) {
			try {exAndroidApp.setSystemUIStatus(show == true ? true : false);} catch(e) {log(e);}
		},
		getStatusBarHeight : function() {
			try {return exSystem.getStatusBarHeight();} catch(e) {log(e); return 0;}
		},
		toast: function(msg) {
			try {return exSystem.toast(msg)} catch(e) {log(e);}
		},
		transformDpi : function(num) {
			try {
				return window.devicePixelRatio * num;
			} catch(e) {
				log(e);
				return num;
			}
		},
		replaceJSONChar : function(json) {
			try {
				var result = json.replace(/\r/g, "\\r").replace(/\n/g, "\\n");
				return result;
			} catch(e) {
				return json;
			}
		},
        isMiuiPlatform : function() {
			var oldInterfaceFlag = false;
			var newInterfaceFlag = false;
            try {oldInterfaceFlag = exSystem.isMiuiPlatform();} catch(e) {log(e);}
			try {newInterfaceFlag = exStoreApp.isMiuiPlatform();} catch(e) {log(e);}
			
			return oldInterfaceFlag || newInterfaceFlag;
        },
        startXiaomiStore : function(keyword) {
            try {return exStoreApp.startXiaomiStore(keyword);} catch(e) {log(e);}
        },
		toggleInputMethod : function(show) {
			try { exSystem.toggleInputMethod(show); } catch(e) { try { exSystem.toggleInput(); } catch(e2) {log(e2);} log(e);}
		}
	}
	
	$(document).ready(function() {
		$("html").attr("ontouchstart", "");//hack mobile :hover!
	})
}(jQuery, window));
