(function($, window, undefined) {
if ($.store == undefined) {
	store = $.store = {};
}

var protocol = store.protocol = {};

var asyncRequest  = function(url, succeed, failed) {
	url += (url.indexOf("?") >= 0 ? "&" : "?") + "v="+protocol.version;
	$.ajax({
			type : "GET",
			url : url,
			async : true,
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				if (XMLHttpRequest.status == 200) {
					succeed();
				} else {
					failed(errorThrown);
				}
			},
			success: function(data) {
				succeed(data);
			}
	});
}

protocol.version = _exjs.getProtocolVersion();

protocol.config = {
	USE_CACHE : false,
	IMG_PATH : "http://astore.jeejen.com/img",
	REQ_BANNER_URL : "http://shop.jeejen.com/store/banner",
	REQ_HOT_APPS_URL : "http://shop.jeejen.com/store/hotapps",
	REQ_AUTO_SEARCH_HINT_URL : "http://shop.jeejen.com/store/autosearch",
	REQ_SEARCH_APP_URL : "http://shop.jeejen.com/store/search",
	REQ_CAT_APPS_URL : "http://shop.jeejen.com/store/cat"

    /*IMG_PATH : "http://astore.demo.jeejen.com:8181/img",
	REQ_BANNER_URL : "http://shop.demo.jeejen.com:8181/store/banner",
	REQ_HOT_APPS_URL : "http://shop.demo.jeejen.com:8181/store/hotapps",
	REQ_AUTO_SEARCH_HINT_URL : "http://shop.demo.jeejen.com:8181/store/autosearch",
	REQ_SEARCH_APP_URL : "http://shop.demo.jeejen.com:8181/store/search",
	REQ_CAT_APPS_URL : "http://shop.demo.jeejen.com:8181/store/cat"*/
};


protocol.getCache = function(name) {
	return _exjs.getJsData(name);
}
protocol.setCache = function(name, value) {
	return _exjs.saveJsData(name, value);
}

protocol.fetchStongAppInfo = function(app, callback) {
	_exjs.fetchStoreAppInfo(app.package, app.versioncode, callback);
}

protocol.getStongAppInfo = function(app) {
	try {
		var json = _exjs.getStoreAppInfo(app.package, app.versioncode);
		if (json != null && json != "") {
			var stongapp = jQuery.parseJSON(json);
			return stongapp;
		}
	} catch (e) {
	}
	
	return app;
}

protocol.requestBannerData = function(container) {
	var cacheKey = "cache_bannerdata";
	var succeed = function(data, cache) {
		try {
			var json = jQuery.parseJSON(data);
			var count = json.length;
			var parent = $("<div class='h-box'></div>");
			var seekpoints = $("<div id='banner-seek-point'></div>");
			parent.css("width", count + "00%");
			for (index in json) {
				var item = json[index];
				if (item.url == "http://#") {
					item.url = "#";
				}
				
				
				var nodeHtml = "<div class='box-item'>{{LINK-START}}<img src='"+item.img+"' style='width:100%'/>{{LINK-END}}</div>";
				if (item.url != "#") {
					nodeHtml = nodeHtml.replace("{{LINK-START}}", "<a href='"+item.url+"' class='box-item'>").replace("{{LINK-END}}", "</a>");
				} else {
					nodeHtml = nodeHtml.replace("{{LINK-START}}", "<span class='box-item'>").replace("{{LINK-END}}", "</span>");
				}
				
				var child = $(nodeHtml);
				child.width(container.width());
				child.appendTo(parent);
				
				var point = $("<img class='point' src='"+protocol.config.IMG_PATH+"/point_normal.png' />");
				point.attr("id", "seek_point_" + index);
				point.appendTo(seekpoints);
			}
			
			container.empty();
			parent.appendTo(container);
			seekpoints.appendTo(container);
			
			var b = new store.view.banner(container, parent, 0, count);
			b.setCallback(new store.view.banner.callback(function(index) {
				for (var i = 0; i < count;i++) {
					var src = i == index ? "/point_selected.png" : "/point_normal.png";
					$("#seek_point_"+i).attr("src", protocol.config.IMG_PATH + src);
				}
			}));
			b.bind();
			
			if (protocol.config.USE_CACHE && cache != false) {
				protocol.setCache(cacheKey, data);
			}
		} catch (e) {
			failed(e);
		}
	};
	
	var failed = function(e) {
		log("requestBannerData failed "+e);
	};

	var request = function() {
        var type = _exjs.isMiuiPlatform() ? 1 : 0;
        var url = store.protocol.config.REQ_BANNER_URL;
        url += (url.indexOf("?") >= 0 ? "&" : "?") + "type=" + type;
		asyncRequest(url, succeed, failed);
	}
	
	var data = !protocol.config.USE_CACHE ? null : protocol.getCache(cacheKey);
	if (isEmpty(data)) {
		request();
	} else {
		succeed(data, false);
	}
}

protocol.requestHotApps = function(container, loadview, callback) {
	var cacheKey = "cache_hotapps";
	
	if (loadview != undefined) {
		loadview.show();
	}
	var empty = function(text) {
		var emptyView = $("<div class=\"ui-empty v-center\">"+text+"</div>")
		container.empty();
		container.append(emptyView);
	}
	
	var succeed = function(data, cache) {
		try {
			container.empty();
			var json = jQuery.parseJSON(data);
			if (json.length > 0) {
				for (index in json) {
					if (store.protocol.filter(json[index])) {
						continue;
					}
					var app = store.protocol.getStongAppInfo(json[index]);
					var appview = new store.view.appItemView(app, true, false, index < json.length - 1, false);

					appview.appendTo(container);
				}
			} else {
				empty("");
			}
			
			if (protocol.config.USE_CACHE && cache != false) {
				protocol.setCache(cacheKey, data);
			}
		} catch (e) {
			log("requestHotApps "+e);
			failed(e);
			return;
		}
		
		container.show();
		if (loadview != undefined) {
			loadview.hide();
		}
		callback(true);
	};
	var failed = function(e) {
		container.hide();
		if (loadview != undefined) {
			loadview.error();
		}
		callback(false);
	};
	
	var request = function() {
		asyncRequest(store.protocol.config.REQ_HOT_APPS_URL, succeed, failed);
	}
	
	var data = !protocol.config.USE_CACHE ? null : protocol.getCache(cacheKey);
	if (isEmpty(data)) {
		request();
	} else {
		succeed(data, false);
	}
};

function getXiaomiSearchHTML(keyword) {
    if (!_exjs.isMiuiPlatform() || !_exjs.isInstalled("com.xiaomi.market", 0)) {
        return "";
    }
    
    //var startMiuiStoreHTML = "<br/><div class='h-center search-box'><input type='button' class='search-xiaomi-btn' value='到小米商店看看' onclick='javascript:_exjs.startApp(\"com.xiaomi.market\");' /></div>";
    var startMiuiStoreHTML = "<div class='search-xiaomi-box h-center' onclick='javascript:_exjs.startApp(\"com.xiaomi.market\");'><img src='img/ico_mi_orange.png' /><span oncontextmenu='return false;' onselectstart='return false;'>去小米商店</span></div>";
    return startMiuiStoreHTML;
}

protocol.autoSearchHint = function(text, container) {
	if (text == "") {
		container.empty();
		$('html, body').animate({scrollTop:1}, 'slow');
		return;
	}
	if (typeof __autoSearchText != 'undefined' && __autoSearchText == text) {
		return;
	}
	
	__autoSearchText = text;

    var startMiuiStoreHTML = getXiaomiSearchHTML(text);
	
	var empty = function(text) {
		var emptyView = $("<div class=\"ui-empty v-center\">"+text + startMiuiStoreHTML + "</div>")
		container.empty();
		container.append(emptyView);
	}
	
	var succeed = function(data) {
		try {
			if (__autoSearchText != text) {
				return;
			}
			container.show().empty();
			var json = jQuery.parseJSON(data);
			if (json.length > 0) {
				for (var index in json) {
					if (store.protocol.filter(json[index])) {
						continue;
					}
					var app = store.protocol.getStongAppInfo(json[index]);
					var appview = new store.view.appItemView(app, false, false, true, false, function() {
						_exjs.toggleInputMethod(false);
                    });
					appview.appendTo(container);
				}
                
                var miuiStoreButton = $(startMiuiStoreHTML);
                miuiStoreButton.appendTo(container);
			} else {
				empty("");
			}
		} catch (e) {
			log("autoSearchHint "+e);
		}
	};
	var failed = function(e) {
	}
	
	var request = function() {
		var url = store.protocol.config.REQ_AUTO_SEARCH_HINT_URL;
		url += (url.indexOf("?") >= 0 ? "&" : "?") + "t=" + encodeURIComponent(text);
		url += "&s=10";
		asyncRequest(url, succeed, failed);
	}
	
	request();
};

protocol.searchApp = function(text, page, container, loadview, callback) {
	var count = 10;
	if (text == "") {
		container.empty();
		$('html, body').animate({scrollTop:1}, 'slow');
		return;
	}
	
	if (typeof __searching != 'undefined' && __searching) {
		return;
	}
	//if (typeof __searchText != 'undefined' && (__searchText == text && __searchpage == page)) {
	//	return;
	//}
	var eq = typeof __searchText != 'undefined' && __searchText == text;

	__searchText = text;
	__searching = true;
	__searchpage = page;
	
	if (page <= 1) {
		if (loadview != undefined) {
			loadview.show();
		}
		container.hide();
	}

    var startMiuiStoreHTML = getXiaomiSearchHTML(text);
	
	var empty = function(text) {
		if (page == 1) {
			var emptyView = $("<div class=\"ui-empty v-center\">"+text + startMiuiStoreHTML + "</div>")
			container.show().empty();
			container.append(emptyView);
		} else {
			_exjs.toast("没有更多了");
		}
	}
	var succeed = function(data) {
		if (__searchText != text) {
			return;
		}
		
		__searching = false;
		
		if (loadview != undefined) {
			loadview.hide(true);
		}
		container.show();
		if (!eq) {
			container.empty();
		}
		try {
			var json = jQuery.parseJSON(data);
			if (json.length > 0) {
				for (var index in json) {
					if (store.protocol.filter(json[index])) {
						continue;
					}
					var app = store.protocol.getStongAppInfo(json[index]);
					var appview = new store.view.appItemView(app, true, false, true, false);
					appview.appendTo(container);
				}
                
                var miuiStoreButton = $(startMiuiStoreHTML);
                miuiStoreButton.appendTo(container);              
			} else {
				empty("没有找到数据");
			}
			
			if (callback != undefined) {
				callback.succeed(json.length >= count);
			}
		} catch(e) {
			log("searchApp "+e);
			failed(e);
		}
	};
	
	var failed = function(e) {
		__searching = false;
		__searchText = null;
		container.hide();
		if (loadview != undefined) {
			loadview.error();
		}
		
		if (callback != undefined) {
			callback.failed();
		}
	}
	
	var request = function() {
		var url = store.protocol.config.REQ_SEARCH_APP_URL;
		url += (url.indexOf("?") >= 0 ? "&" : "?") + "t=" + encodeURIComponent(text);
		url += "&p="+page+"&s="+count;
		asyncRequest(url, succeed, failed);
	}
	
	request();
}

protocol.requestUpgradeCount = function(container) {
	try {
		var count = _exjs.getUpgradeStoreCount();
		if (count > 0) {
		
			var html = "<div class=\"h-box ui-hint-bar ui-upgrade-hint-bar\">"+
				"<div class=\"flex-box v-center ui-hint-bar-gap \">"+
				"<div class=\"h-box\">"+
				"<div class=\"ui-hint-bar-gap v-center\">软件有更新</div>"+
				"<div class=\"ui-num h-center\">"+count+"</div></div></div>"+
				"<div class=\"border-box v-center\"><img src=\"img/arrow_icon.png\" class=\"ui-arrow-icon\" /></div></div>";
			container.show().html(html);
		} else {
			container.hide();
		}
		
		container.click(function() {
			window.location.href="upgradeapp.html"
		});
	} catch (e) {
		log("requestUpgradeCount"+e)
	}
}

protocol.requestUpgradeAppInfo = function(container, loadview) {
	try {
		var empty = function(text) {
			var emptyView = $("<div class=\"ui-empty v-center\">"+text+"</div>")
			container.empty();
			loadview.hide(true);
			container.append(emptyView);
		};
		
		var json = _exjs.getUpgradeStoreAppInfo();
		var apps = jQuery.parseJSON(json);
		if (apps.length > 0) {
			for (index in apps) {
				var app = store.protocol.getStongAppInfo(apps[index]);
				var appview = new store.view.appItemView(app, true, true, true, true);
				appview.appendTo(container);
			}
		} else {
			empty("没有找到数据");
		}
		
		loadview.hide(true);
	} catch (e) {
		log("requestUpgradeAppInfo "+e);
	}
}

protocol.requestCategoryApps = function(cat, page, container, loadview, callback) {
	var count = 10;
	var cacheKey = "cache_category_" + cat + "_" + page;
	if (!isEmpty(loadview)) {
		loadview.show();
	}
	
	var empty = function(text) {
		if (page == 1) {
			var emptyView = $("<div class=\"ui-empty v-center\">"+text+"</div>")
			container.show().empty();
			container.append(emptyView);
		} else {
			_exjs.toast("没有更多了");
		}
	}
	var succeed = function(data, cache) {
		try {
			var json = jQuery.parseJSON(data);
			
			if (json.length > 0) {
				for (var index in json) {
					if (store.protocol.filter(json[index])) {
						continue;
					}
					var app = store.protocol.getStongAppInfo(json[index]);
					var appview = new store.view.appItemView(app, true, false, true, false);
					appview.appendTo(container);
				}
			} else {
				empty("没有数据");
			}
			
			if (protocol.config.USE_CACHE && cache != false) {
				protocol.setCache(cacheKey, data);
			}
			if (!isEmpty(loadview)) {
				loadview.hide();
			}
			if (callback != undefined) {
				callback.succeed(json.length >= count);
			}
		} catch(e) {
			log(e);
			failed(e);
		}
	};
	
	var failed = function(e) {
		if (!isEmpty(loadview)) {
			loadview.error();
		}
		container.hide();
		if (callback != undefined) {
			callback.failed();
		}
	};
	
	var request = function() {
		var url = store.protocol.config.REQ_CAT_APPS_URL;
		url += (url.indexOf("?") >= 0 ? "&" : "?") + "c=" + cat;
		url += "&p="+page+"&s="+count;
		asyncRequest(url, succeed, failed);
	};
	
	var data = !protocol.config.USE_CACHE ? null : protocol.getCache(cacheKey);
	if (isEmpty(data)) {
		request();
	} else {
		succeed(data, false);
	}
}

protocol.requestDownloadCount = function(container) {
	try {
		var count = _exjs.getDownloadTaskCount();
		if (count > 0) {
		
			var html = "<div class=\"h-box ui-hint-bar ui-download-hint-bar\">"+
				"<div class=\"flex-box v-center ui-hint-bar-gap \">"+
				"<div class=\"h-box\">"+
				"<div class=\"ui-hint-bar-gap v-center\">软件下载列表</div>"+
				"<div class=\"ui-num h-center\">"+count+"</div></div></div>"+
				"<div class=\"border-box v-center\"><img src=\"img/arrow_icon.png\" class=\"ui-arrow-icon\" /></div></div>";
			container.show().html(html);
		} else {
			container.hide();
		}
		
		container.click(function() {
			window.location.href="downloadcenter.html"
		});
	} catch (e) {
		log("requestUpgradeCount"+e)
	}
}

protocol.requestDownloadAppInfo = function(container, loadview) {
	try {
		var empty = function(text) {
			var emptyView = $("<div class=\"ui-empty v-center\">"+text+"</div>")
			container.empty();
			loadview.hide(true);
			container.append(emptyView);
		};
		
		var json = _exjs.getDownloadStoreAppInfo();
		var apps = jQuery.parseJSON(json);
		if (apps.length > 0) {
			for (index in apps) {
				var app = store.protocol.getStongAppInfo(apps[index]);
				var appview = new store.view.appItemView(app, true, true, true, true);
				appview.appendTo(container);
			}
		} else {
			empty("没有找到数据");
		}
		
		loadview.hide(true);
	} catch (e) {
		log("requestDownloadAppInfo "+e);
	}
}

protocol.filter = function(app) {
	try {
		if (_exjs.isFilter(app.package)) {
			return true;
		}
		
		if (app.package == "com.jeejen.family" && (_exjs.isInstalled("com.jeejen.family.miui", 0) || _exjs.isInstalled( "com.jeejen.family.j1", 0))) {
			return true;
		}
	} catch(e) {
	}
	return false;
}
}(jQuery, window))




