(function($, window, undefined) {
if ($.store == undefined) {
	store = $.store = {};
}

var view = store.view = {};
view.config = {
	MIN_DRAG_DISTANCE : 0.3,
	APP_INFO_URL : "http://astore.jeejen.com/app_info.html",
	HINT_LOAD_IMG_URL : "http://astore.jeejen.com/img/icon_loading.png",
	HINT_ERR_IMG_URL : "http://astore.jeejen.com/img/icon_error.png",
	DOWNLOAD_FAILED_IMG_URL : "http://astore.jeejen.com/img/icon_error_small.png",
	DOWNLOAD_UPGRADE_IMG_URL : "http://astore.jeejen.com/img/icon_upgrade.png",
	DOWNLOAD_LOAD_IMG_URL : "http://astore.jeejen.com/img/icon_loading.png"
};

view.banner = function(screen, container, index, childCount) {
	this._screen = screen;
	this._container = container;
	this._index = index;
	this._touchX = 0;
	this._touchY = 0;
	this._lastTouchX = 0;
	this._lastTouchY = 0;
	this._childCount = childCount == undefined ? -1 : childCount;
	this._touchStartTime = 0;
	this._timeId = 0;
	
	var _self = this;
	this.touchstart = function(e) {
		var event = new view.banner.touchEvent(e);
		//event._e.preventDefault();
		
		_self._touchX = event.getTouchX();
		_self._touchY = event.getTouchY();
		_self._touchStartTime = new Date().getTime();
		_self.endRotate();
		log("start touchX="+_self._touchX +" touchY="+_self._touchY+" time="+_self._touchStartTime);
	};
	this.touchend = function(e) {
		var event = new view.banner.touchEvent(e);
		var prevent = false;
		_self._lastTouchX = event.getTouchX();
		_self._lastTouchY = event.getTouchY();
		var time = new Date().getTime();
		var quick = time - _self._touchStartTime < 100;
		
		
		var dragDistance = Math.abs(_self._lastTouchX - _self._touchX);
		var screenWidth = _self._screen.width();
		var offset = _self._lastTouchX > _self._touchX ? -1 : 1;
		if (dragDistance >= (screenWidth * view.config.MIN_DRAG_DISTANCE) || (quick && dragDistance >= (screenWidth * 0.07))) {
			prevent = true;
			_self.scroll(_self._index + offset);
		} else {
			prevent = false;
			_self.scroll(_self._index);
		}
		log("end touchX="+_self._lastTouchX +" touchY="+_self._lastTouchX+" time="+time+" prevent="+prevent);
		if (prevent) {
			event._e.preventDefault();
		}
		
		_self.startRotate();
	};
	this.touchmove = function(e) {
		var event = new view.banner.touchEvent(e);
		event._e.preventDefault();
	
		var tX = (event.getTouchX() - _self._touchX) * 0.7;
		tX -= _self._index * _self._screen.width();
		_self._container.css("-webkit-transition", "");
		_self._container.css("-webkit-transform", "translateX("+(tX)+"px)");
	};
	
	this.bind = function() {
		_self._screen.bind("touchstart", _self.touchstart);
		_self._screen.bind("touchend", _self.touchend);
		_self._screen.bind("touchcancel", _self.touchend);
		_self._screen.bind("touchmove", _self.touchmove);
	};
	
	this.unbind = function() {
		_self._screen.unbind("touchstart", _self.touchstart);
		_self._screen.unbind("touchend", _self.touchend);
		_self._screen.unbind("touchcancel", _self.touchend);
		_self._screen.unbind("touchmove", _self.touchmove);
	}
	
	this.setCallback = function(callback) {
		_self._callback = callback;
	}
	
	this.scrollLeft = function() {
		_self.scroll(_self._index - 1);
	}
	
	this.scrollRight = function() {
		_self.scroll(_self._index + 1);
	}
	
	this.scroll = function(index) {
		var toIndex = _self.normalizeIndex(index);
		var width = _self._screen.width();
		var startX = -toIndex * width;
	
		_self._container.css("-webkit-backface-visibility", "hidden");
		_self._container.css("-webkit-transition", "-webkit-transform 0.3s linear");
		//_self._container.css("transition-timing-function", "cubic-bezier(0,0.5,0.75,1)");
		_self._container.css("-webkit-transform","translate("+startX+"px, 0px)");
		_self._index = toIndex;
	
		var cb = function(e) {
			_self._index = toIndex;
			if (_self._callback != null && _self._callback != undefined) {
				_self._callback.onScrolled(toIndex);
			}
			_self._container.unbind("webkitTransitionEnd", cb);
		}
		_self._container.bind("webkitTransitionEnd", cb);
	}
	
	this.normalizeIndex = function(index) {
		if (index <= 0) {
			return 0;
		}
		var childCount = this._childCount == -1 ? this._container.children().length : this._childCount;
		
		if (index >= childCount) {
			return childCount - 1;
		}
		
		return index;
	};
	
	this.startRotate = function() {
		try {
			if (_self._timeId != 0) {
				_self.endRotate();
			}
			_self._timeId = setTimeout(function() {
				try {
					var childCount = _self._childCount == -1 ? _self._container.children().length : _self._childCount;
					if (_self._index == childCount - 1) {
						_self.scroll(0);
					} else {
						_self.scrollRight();
					}
					_self.startRotate();
				} catch(e) {
				}
			}, 5000);
		} catch(e) {
		}
	}
	
	this.endRotate = function() {
		clearTimeout(_self._timeId);
		_self._timeId = 0;
	}
	
	_self.scroll(index);
	_self.startRotate();
}

view.banner.touchEvent = function(e) {
	var _self = this;
	this.getTouchX = function() {
		return _self._e.changedTouches[0].pageX;
	}
	
	this.getTouchY = function() {
		return _self._e.changedTouches[0].pageY;
	}
	
	this.transaformEvent = function(e) {
		var event = e.originalEvent;
		return event;
	}
	
	this._e = this.transaformEvent(e);
}

view.banner.callback = function(scrolledCallback) {
	this.onScrolled = function(index) {
		if (scrolledCallback != undefined) {
			scrolledCallback(index);
		}
	}
}

view.progressBar = function(canvas, foreground, background, annularcolor, thickness) {
	this._canvas = canvas;
	this._foreground = foreground;
	this._background = background;
	this._annularcolor = annularcolor;
	this._thickness = thickness;
	
	var _self = this;
	this.progress = function(percent) {
		var canvas = _self._canvas.get(0);  
		var context = canvas.getContext('2d');
		var width = _self._canvas.attr("width");
		var center = width / 2;
		percent = _self.adjustPercent(percent);
		
		context.clearRect(0, 0, width, width);
		context.beginPath();  
		context.moveTo(center, center);  
		context.arc(center, center, center, 0, Math.PI * 2, false);  
		context.closePath();  
		context.fillStyle = _self._foreground;
		context.fill();  
		
		context.beginPath();  
		context.moveTo(center, center);  
		context.arc(center, center, center, 1.5 * Math.PI, Math.PI * 2 * percent / 100 - 0.5 * Math.PI, false);  
		context.closePath();  
		context.fillStyle = _self._annularcolor;
		context.fill();
		
		context.beginPath();  
		context.moveTo(center, center);  
		context.arc(center, center, _self._thickness, 0, Math.PI * 2, true);  
		context.closePath();  
		context.fillStyle = _self._background;
		context.fill();
	};
	this.adjustPercent = function(percent) {
		return percent == 0 ? 100 : (percent == 100 ? 0 : percent);
	};
};

view.HINT_TOKEN = 0;
view.hintView = function(container, paddingtop) {
	view.HINT_TOKEN += 1;
	
	this._paddingtop = paddingtop;
	this._container = container;
	this._view = null;
	this._loadview = null;
	this._errview = null;
	this._token = view.HINT_TOKEN;
	
	var _self = this;
	this.show = function(text) {
		var parent = _self.getParent();
		if (text == null || text == undefined) {
			text = "正在加载内容";
		}
		
		if (_self._loadview == null) {
			var loadview = $("<div id=\"loading\" class=\"ui-hint-view\">");
			var imgview = $("<div class=\"ui-v-gap\"><img src=\"" + view.config.HINT_LOAD_IMG_URL + "\" /></div>");
			var textview = $("<div class=\"ui-text\" id=\"load-text\"></div>");
			
			imgview.find("img").load(function() {
				$(this).addClass("anim-loading ui-icon");
			});
			imgview.appendTo(loadview);
			textview.appendTo(loadview);
			loadview.appendTo(parent);
			
			_self._loadview = loadview;
		}
		
		_self._loadview.find("#load-text").html(text);
		_self._loadview.show();
		
		if (_self._errview != null) {
			_self._errview.hide();
		}
	};
	
	this.hide = function(hideParent) {
		if (_self._view == null) {
			return;
		}
		
		_self._view.hide();
		if (hideParent != undefined && hideParent == true) {
			_self._view.parent().hide();
		}
	}
	
	this.error = function(text) {
		var parent = _self.getParent();
		if (text == null || text == undefined) {
			text = "请检查网络连接是否正常";
		}
		
		if (_self._errview == null) {
			var errview = $("<div id=\"error\" class=\"ui-hint-view\">");
			var imgview = $("<div class=\"ui-v-gap\"><img src=\"" + view.config.HINT_ERR_IMG_URL + "\" class=\"ui-icon\" /></div>");
			var textview = $("<div class=\"ui-text\" id=\"err-text\"></div>");
			
			imgview.appendTo(errview);
			textview.appendTo(errview);
			errview.appendTo(parent);
			
			_self._errview = errview;
		}
		
		_self._errview.find("#err-text").html(text);
		_self._errview.show();
		
		if (_self._loadview != null) {
			_self._loadview.hide();
		}
	};
	
	this.appendTo = function(view) {
		var parent = _self._container;
		if (parent == null) {
			parent = $("body");
			parent.height($(window).height());
		}
		
		view.appendTo(parent);
	}
	
	this.getParent = function() {
		var parent = _self._view;
		if (parent == null) {
			parent = $("<div></div>");
			parent.attr("id", _self.getName());
			if (_self._paddingtop != undefined) {
				parent.css("padding-top", _self._paddingtop);
			}
			_self._view = parent;
			_self.appendTo(parent);
		}
		
		return parent;
	}
	
	this.getContainer = function() {
		return _self._container;
	}
	
	this.getName = function() {
		return "hit-view" + _self._token;
	}
	
	this.getParent();
}

view.appItemView = function(app, showimg, showstatus, showline, upgrade, clickCallback) {
	this._app = app;
	this._showimg = showimg;
	this._showstatus = showstatus;
	this._showline = showline;
	this._upgrade = upgrade;
	this._view = null;
	this._downloader = null;
	
	var _self = this;
	
	var createDownloader = function() {
		if (_self._downloader != null || _self._app.downloadurl == undefined) {
			return;
		}
		
		_self._downloader = store.component.appDownloader.manager.create(_self._app.downloadurl, true, {
			onDownload : function() {
				_self.fetching();
			},
			onFailed : function(e) {
				_self.failed();
			},
			onProgress : function(downloadSize, totalSize) {
				var percent = totalSize > 0 ? (downloadSize * 100 / totalSize) : 0;
				_self.progress(percent);
			},
			onCompleted : function() {
			}
		});
	};
	this.fetching = function() {
		_self._view.find("#app-status-icon").hide();
		_self._view.find("#app-status-img").show();
		_self._view.find("#app-status-img").addClass("anim-loading");
		_self._view.find("#app-status-img").attr("src", store.view.config.DOWNLOAD_LOAD_IMG_URL);
	}
	this.failed = function() {
		_self._view.find("#app-status-icon").hide();
		_self._view.find("#app-status-img").show().removeClass("anim-loading");;
		
		_self._view.find("#app-status-img").attr("src", store.view.config.DOWNLOAD_FAILED_IMG_URL);
	}
	this.progress = function(percent) {
		var statusview = _self._view.find("#app-status-icon");
		if (statusview.data("view") == null) {
			var bar = new store.view.progressBar(statusview, "rgba(0,0,0,0.05)", "#f7f7f7", "#50BB13", 15);
			statusview.data("view", bar);
		}
		statusview.show().data("view").progress(percent);
		_self._view.find("#app-status-img").hide();
	}
	this.updateUpgradeStatus = function() {
		_self._view.find("#app-status-icon").hide();
		_self._view.find("#app-status-img").show().removeClass("anim-loading");
		_self._view.find("#app-status-img").attr("src", store.view.config.DOWNLOAD_UPGRADE_IMG_URL);
	}
	this.init = function() {
		var width = _exjs.transformDpi(30);
		var view = $("<div class=\"ui-list-app-item\"></div>");
		_self._view = view;
		
		var linkview = $("<a href=\"javascript:void(0)\" class=\"ui-link h-box\"></a>");
		view.append(linkview);
		
		var nameview = $("<div class=\"flex-box v-center ui-app-name ui-r-gap\"><div class=\"ellipsis\">" + _self._app.name +"</div></div>");
		var statusview = $("<div class=\"border-box v-center\" ><canvas id=\"app-status-icon\" width=\""+width+"\" height=\""+width+"\" class=\"ui-app-status-icon\" /><img id=\"app-status-img\" style=\"width:"+width+"px;height:"+width+"px;\"/></div></a>");
		var lineview = $("<div class=\"ui-sep-line\"></div>");
		
		if (_self._showimg) {
			var imgview = $("<div class=\"border-box v-center ui-r-gap\"><img src=\"img/icon_empty.png\" data-original=\"" + _self._app.iconurl + "\" class=\"ui-app-icon\" /></div>");
			imgview.find("img").lazyload({event : "sporty"});
			setTimeout(function(){imgview.find("img").trigger("sporty")}, 0);
			linkview.append(imgview);
		}
		
		linkview.append(nameview);
		if (_self._showstatus) {
			linkview.append(statusview);
			if (_self._app.downloadurl != undefined) {
				createDownloader();
			}
			
			var status = _self._downloader != null ? _self._downloader.getStatus() : 0;
			if (status == 0) {
				if (_self._upgrade) {
					_self.updateUpgradeStatus();
				}
			} else if (status == 2) {
				_self._downloader.timeTask();
			} else if (status == 16 || status == 4) {
				_self.failed();
			} else if (status == 8) {
				_self.progress(100);
			}
			
			statusview.click(function(event) {
				try {
					event.stopPropagation();
					
					var callback = "fetch"+newGuid();
					var download = function() {
						createDownloader();
						
						var status = _self._downloader.getStatus();
						if (_self._upgrade) {
							if (status == 0 || status == 16 || status == 4) {
								_self._downloader.download(status != 0);
							} else if (status == 8){
								_self.progress(100);
							}
						}
					}
					window[callback] = {
						succeed : function(data) {
							try {
								var app = jQuery.parseJSON(data);
								if (app != null && app.downloadurl != undefined) {
									_self._app = app;
								}
							} catch (e) {log("callback "+e);}
							
							download();
						},
						failed : function(e) {
							_self.failed();
						}
					}
					if (_self._downloader == null) {
						_self.fetching();
						store.protocol.fetchStongAppInfo(_self._app, callback);
					} else {
						download();
					}
				} catch (e) {
					log("click "+e);
				}
			});
		}
		
		if (_self._showline) {
			view.append(lineview);
		}
		view.click(function() {
			try {
				window["store.app"].saveJsData("app_info", "{\"package\":\""+_self._app.package+"\", \"versioncode\":"+_self._app.versioncode+"}");
 				window.location.href = store.view.config.APP_INFO_URL;
			} catch (e) {log(e);}

			if (clickCallback != undefined && clickCallback != null) {
				clickCallback();
			}
		});
	}
	
	this.appendTo = function(container) {
		if (_self._view == null) {
			return;
		}
		container.append(_self._view);
	}
	
	var newGuid = function() {
		var g = "";
		var i = 32;
		while(i--){
			g += Math.floor(Math.random()*16.0).toString(16);
		}
	
		return g;
	}
	this.init();
};
}(jQuery, window));







