/*
 * Decompiled with CFR 0.152.
 */
package com.locnet.inject;

import android.net.LocalSocket;
import android.os.Build;
import android.os.RemoteException;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.locnet.inject.InjectHelper;
import com.locnet.inject.InjectHelper16;
import com.locnet.inject.Main;
import com.locnet.inject.UInputHelper;
import com.locnet.utility.ReflectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ClientHandler {
    private static final int ACTION_HOVER_MOVE = 7;
    private static final int ACTION_SCROLL = 8;
    private static final int SOURCE_KEYBOARD = 257;
    private static final int SOURCE_JOYSTICK = 0x1000010;
    private static final int SOURCE_TOUCHSCREEN = 4098;
    private static final int SOURCE_MOUSE = 8194;
    private static final int SAMPLE_X = 0;
    private static final int SAMPLE_Y = 1;
    private static final int SAMPLE_PRESSURE = 2;
    private static final int SAMPLE_SIZE = 3;
    InjectHelper injectHelper = null;
    InjectHelper16 injectHelper16 = null;
    LocalSocket socket;
    private static final int NUM_POINTER = 5;
    private static final int MY_NUM_SAMPLE_DATA = 2;
    private static final int MY_SAMPLE_X = 0;
    private static final int MY_SAMPLE_Y = 1;
    boolean[] mUsedPointer = new boolean[5];
    int[] mInData = new int[10];
    int[] mAxisData = new int[8];

    public ClientHandler(LocalSocket s) throws IOException, RemoteException {
        if (ClientHandler.preJB()) {
            this.injectHelper = new InjectHelper();
        } else {
            this.injectHelper16 = new InjectHelper16();
        }
        this.socket = s;
        Thread tHandleCmd = new Thread(){

            @Override
            public void run() {
                ClientHandler.this.handleCmd();
            }
        };
        tHandleCmd.start();
        try {
            tHandleCmd.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handleCmd() {
        try {
            InputStream is = this.socket.getInputStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            if (Main.mDebug) {
                Log.d((String)"gamepad", (String)"handleCmd");
            }
            while (true) {
                String line;
                if ((line = r.readLine()) == null) {
                    r.close();
                    this.socket.close();
                    break;
                }
                if (Main.mDebug) {
                    Log.d((String)"gamepad", (String)("Received : " + line));
                }
                try {
                    if (!ClientHandler.handleCommand(this.injectHelper, this.injectHelper16, line, this.mInData, this.mUsedPointer, this.mAxisData)) continue;
                    r.close();
                    this.socket.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        UInputHelper.nativeStopServer();
        Log.d((String)"gamepad", (String)"LocnetService: Stopped");
        System.exit(0);
    }

    public static boolean handleCommand(InjectHelper wm, InjectHelper16 im, String line, int[] inData, boolean[] usedPointer, int[] axisData) throws RemoteException {
        String[] paramList = line.split("/");
        String type = paramList[0];
        if (type.equals("quit")) {
            return true;
        }
        if (type.equals("pointer")) {
            MotionEvent event = ClientHandler.getTouchScreenMotionEvent(paramList, inData, usedPointer);
            if (event != null) {
                if (ClientHandler.preJB()) {
                    wm.injectPointerEvent(event, false);
                } else {
                    im.injectInputEvent((InputEvent)event, 4098, true);
                }
                event.recycle();
            }
        } else if (type.equals("key")) {
            KeyEvent event = ClientHandler.getKeyEvent(paramList);
            if (event != null) {
                if (ClientHandler.preJB()) {
                    wm.injectKeyEvent(event, false);
                } else {
                    im.injectInputEvent((InputEvent)event, 0, false);
                }
            }
        } else if (!type.equals("trackball")) {
            if (type.equals("joycreate")) {
                UInputHelper.nativeAddJoy(ClientHandler.getDeviceName(paramList, "gamekeyboard"));
            } else if (type.equals("joydestroy")) {
                UInputHelper.nativeRemoveJoy(-1);
            } else if (type.equals("joystick")) {
                int i = 1;
                long downTime = Long.parseLong(paramList[i++]);
                long eventTime = Long.parseLong(paramList[i++]);
                int action = Integer.parseInt(paramList[i++]);
                int x = Integer.parseInt(paramList[i++]);
                int y = Integer.parseInt(paramList[i++]);
                int id = Integer.parseInt(paramList[i++]);
                int metaState = Integer.parseInt(paramList[i++]);
                if (action == 2) {
                    switch (id) {
                        case 2: {
                            if (axisData[2] != x) {
                                UInputHelper.nativeInjectAbs(2, x + 128);
                            }
                            if (axisData[3] != y) {
                                UInputHelper.nativeInjectAbs(5, y + 128);
                            }
                            axisData[2] = x;
                            axisData[3] = y;
                            break;
                        }
                        case 3: {
                            if (axisData[4] != x) {
                                UInputHelper.nativeInjectAbs(3, x + 128);
                            }
                            axisData[4] = x;
                            break;
                        }
                        case 4: {
                            if (axisData[5] != y) {
                                UInputHelper.nativeInjectAbs(4, y + 128);
                            }
                            axisData[5] = y;
                            break;
                        }
                        case 5: {
                            if (axisData[6] != x) {
                                UInputHelper.nativeInjectAbs(16, x + 128);
                            }
                            axisData[6] = x;
                            break;
                        }
                        case 6: {
                            if (axisData[7] != y) {
                                UInputHelper.nativeInjectAbs(17, y + 128);
                            }
                            axisData[7] = y;
                            break;
                        }
                        default: {
                            if (axisData[0] != x) {
                                UInputHelper.nativeInjectAbs(0, x + 128);
                            }
                            if (axisData[1] != y) {
                                UInputHelper.nativeInjectAbs(1, y + 128);
                            }
                            axisData[0] = x;
                            axisData[1] = y;
                            break;
                        }
                    }
                } else if (action == 0) {
                    UInputHelper.nativeInjectKey(id, 1);
                } else if (action == 1) {
                    UInputHelper.nativeInjectKey(id, 0);
                }
            } else if (type.equals("mousecreate")) {
                UInputHelper.nativeAddMouse(ClientHandler.getDeviceName(paramList, "locnet_mouse"));
            } else if (type.equals("mousedestroy")) {
                UInputHelper.nativeRemoveMouse(-1);
            } else if (type.equals("mouse")) {
                int i = 1;
                int action = Integer.parseInt(paramList[i++]);
                int code = Integer.parseInt(paramList[i++]);
                int value = Integer.parseInt(paramList[i++]);
                if (action == 2) {
                    UInputHelper.nativeInjectRel(code, value);
                } else if (action == 0) {
                    UInputHelper.nativeInjectKey(code, 1);
                } else if (action == 1) {
                    UInputHelper.nativeInjectKey(code, 0);
                }
            }
        }
        return false;
    }

    private static String getDeviceName(String[] args, String defValue) {
        String result = defValue;
        if (args.length > 1 && args[1].length() > 0) {
            result = args[1];
        }
        return result;
    }

    private static float getNormalisedValue(float axisValue) {
        int FLAT = 30;
        float result = 0.0f;
        if (axisValue > (float)FLAT) {
            result = 1.0f;
        } else if (axisValue < (float)(-FLAT)) {
            result = -1.0f;
        }
        return result;
    }

    private static MotionEvent getTouchScreenMotionEvent(String[] args, int[] inData, boolean[] usedPointer) {
        MotionEvent event = null;
        int i = 1;
        long downTime = Long.parseLong(args[i++]);
        long eventTime = Long.parseLong(args[i++]);
        int action = Integer.parseInt(args[i++]);
        int x = Integer.parseInt(args[i++]);
        int y = Integer.parseInt(args[i++]);
        int pointerCount_obs = Integer.parseInt(args[i++]);
        int metaState = Integer.parseInt(args[i++]);
        switch (action & 0xFF) {
            case 0: {
                ClientHandler.clearUsedPoint(usedPointer);
                usedPointer[0] = true;
                inData[0] = x;
                inData[1] = y;
                event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (float)x, (float)y, (int)metaState);
                break;
            }
            case 1: {
                int index = ClientHandler.getUsedPoint(0, usedPointer);
                if (index < 0) break;
                event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)metaState);
                if (Build.VERSION.SDK_INT <= 10) {
                    int[] pointerIdentifiers = (int[])ReflectionHelper.getPrivateField(event, "mPointerIdentifiers");
                    if (pointerIdentifiers != null && pointerIdentifiers.length > 0) {
                        pointerIdentifiers[0] = index;
                    }
                } else if (Build.VERSION.SDK_INT >= 14) {
                    MotionEvent tempEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)x, (float)y, (int)metaState);
                    Object[] gSharedTempPointerProperties = (Object[])ReflectionHelper.getPrivateField(tempEvent, "gSharedTempPointerProperties");
                    Object[] gSharedTempPointerCoords = (Object[])ReflectionHelper.getPrivateField(tempEvent, "gSharedTempPointerCoords");
                    if (gSharedTempPointerProperties != null && gSharedTempPointerCoords != null) {
                        ReflectionHelper.setPrivateFieldInt(gSharedTempPointerProperties[0], "id", index);
                        ReflectionHelper.setPrivateFieldFloat(gSharedTempPointerCoords[0], "x", x);
                        ReflectionHelper.setPrivateFieldFloat(gSharedTempPointerCoords[0], "y", y);
                        Object[] params = new Object[]{downTime, eventTime, 1, 1, gSharedTempPointerProperties, gSharedTempPointerCoords, metaState, 0, Float.valueOf(1.0f), Float.valueOf(1.0f), 0, 0, 4098, 0};
                        event = (MotionEvent)ReflectionHelper.invokePrivateMethod(tempEvent, "obtain", params);
                    }
                }
                ClientHandler.clearUsedPoint(usedPointer);
                break;
            }
            case 5: {
                int pointerCount = ClientHandler.numUsedPoint(usedPointer);
                if (pointerCount >= 5) break;
                ++pointerCount;
                int index = ClientHandler.findEmptyPointerIndex(1, usedPointer);
                usedPointer[index] = true;
                action = 5 | index << 8;
                if (Build.VERSION.SDK_INT <= 10) {
                    event = ClientHandler.fillTouchEvent_PreHC(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                    break;
                }
                if (Build.VERSION.SDK_INT < 14) break;
                event = ClientHandler.fillTouchEvent_ICS(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                break;
            }
            case 6: {
                int index;
                int pointerCount = ClientHandler.numUsedPoint(usedPointer);
                if (pointerCount <= 1 || (index = ClientHandler.detectPointerIndex(-1, x, y, inData, usedPointer)) < 0) break;
                action = 6 | index << 8;
                if (Build.VERSION.SDK_INT <= 10) {
                    event = ClientHandler.fillTouchEvent_PreHC(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                } else if (Build.VERSION.SDK_INT >= 14) {
                    event = ClientHandler.fillTouchEvent_ICS(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                }
                usedPointer[index] = false;
                break;
            }
            case 2: {
                int pointerCount = ClientHandler.numUsedPoint(usedPointer);
                int index = action >> 8 & 0xFF;
                action = 2;
                if (Build.VERSION.SDK_INT <= 10) {
                    event = ClientHandler.fillTouchEvent_PreHC(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                    break;
                }
                if (Build.VERSION.SDK_INT < 14) break;
                event = ClientHandler.fillTouchEvent_ICS(downTime, eventTime, action, pointerCount, x, y, metaState, index, inData, usedPointer);
                break;
            }
            default: {
                event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (float)x, (float)y, (int)metaState);
            }
        }
        return event;
    }

    private static void clearUsedPoint(boolean[] usedPointer) {
        int j = 0;
        while (j < 5) {
            usedPointer[j] = false;
            ++j;
        }
    }

    private static int numUsedPoint(boolean[] usedPointer) {
        int result = 0;
        int j = 0;
        while (j < 5) {
            if (usedPointer[j]) {
                ++result;
            }
            ++j;
        }
        return result;
    }

    private static int getUsedPoint(int start, boolean[] usedPointer) {
        int result = -1;
        int j = start;
        while (j < 5) {
            if (usedPointer[j]) {
                result = j;
                break;
            }
            ++j;
        }
        return result;
    }

    private static int findEmptyPointerIndex(int defValue, boolean[] usedPointer) {
        int result = defValue;
        int j = 0;
        while (j < 5) {
            if (!usedPointer[j]) {
                result = j;
                break;
            }
            ++j;
        }
        return result;
    }

    private static int detectPointerIndex(int defValue, int x, int y, int[] inData, boolean[] usedPointer) {
        int result = defValue;
        int j = 0;
        while (j < 5) {
            if (usedPointer[j] && inData[2 * j + 0] == x && inData[2 * j + 1] == y) {
                result = j;
                break;
            }
            ++j;
        }
        return result;
    }

    private static int getOutIndex(int pointerCount, int index, boolean[] usedPointer) {
        int id = 0;
        int out_index = 0;
        int j = 0;
        while (j < pointerCount) {
            if ((id = ClientHandler.getUsedPoint(id, usedPointer)) < 0) break;
            if (id == index) {
                out_index = j;
                break;
            }
            ++id;
            ++j;
        }
        return out_index;
    }

    private static MotionEvent fillTouchEvent_PreHC(long downTime, long eventTime, int action, int pointerCount, int x, int y, int metaState, int index, int[] inData, boolean[] usedPointer) {
        MotionEvent event = null;
        inData[2 * index + 0] = x;
        inData[2 * index + 1] = y;
        int out_index = ClientHandler.getOutIndex(pointerCount, index, usedPointer);
        if ((action & 0xFF) != 2) {
            action = action & 0xFF | out_index << 8;
        }
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (float)x, (float)y, (int)metaState);
        ReflectionHelper.setPrivateFieldInt(event, "mNumPointers", pointerCount);
        int[] pointerIdentifiers = (int[])ReflectionHelper.getPrivateField(event, "mPointerIdentifiers");
        Integer NUM_SAMPLE_DATA = (Integer)ReflectionHelper.getPrivateField(event, "NUM_SAMPLE_DATA");
        float[] dataSamples = (float[])ReflectionHelper.getPrivateField(event, "mDataSamples");
        int id = 0;
        int j = 0;
        while (j < pointerCount) {
            if ((id = ClientHandler.getUsedPoint(id, usedPointer)) < 0) break;
            if (pointerIdentifiers != null && pointerIdentifiers.length >= pointerCount) {
                pointerIdentifiers[j] = id;
            }
            if (dataSamples != null && dataSamples.length >= NUM_SAMPLE_DATA * pointerCount) {
                dataSamples[NUM_SAMPLE_DATA.intValue() * j + 0] = inData[2 * id + 0];
                dataSamples[NUM_SAMPLE_DATA.intValue() * j + 1] = inData[2 * id + 1];
                dataSamples[NUM_SAMPLE_DATA.intValue() * j + 2] = 1.0f;
                dataSamples[NUM_SAMPLE_DATA.intValue() * j + 3] = 1.0f;
            }
            ++id;
            ++j;
        }
        return event;
    }

    private static MotionEvent fillTouchEvent_ICS(long downTime, long eventTime, int action, int pointerCount, int x, int y, int metaState, int index, int[] inData, boolean[] usedPointer) {
        MotionEvent event = null;
        inData[2 * index + 0] = x;
        inData[2 * index + 1] = y;
        int out_index = ClientHandler.getOutIndex(pointerCount, index, usedPointer);
        if ((action & 0xFF) != 2) {
            action = action & 0xFF | out_index << 8;
        }
        MotionEvent tempEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (float)x, (float)y, (int)metaState);
        try {
            Object[] params = new Object[]{pointerCount};
            ReflectionHelper.invokePrivateMethod(tempEvent, "ensureSharedTempPointerCapacity", params);
        }
        catch (Exception params) {
            // empty catch block
        }
        Object[] gSharedTempPointerProperties = (Object[])ReflectionHelper.getPrivateField(tempEvent, "gSharedTempPointerProperties");
        Object[] gSharedTempPointerCoords = (Object[])ReflectionHelper.getPrivateField(tempEvent, "gSharedTempPointerCoords");
        if (gSharedTempPointerProperties != null && gSharedTempPointerProperties.length > pointerCount && gSharedTempPointerCoords != null && gSharedTempPointerCoords.length > pointerCount) {
            int id = 0;
            int j = 0;
            while (j < pointerCount) {
                if ((id = ClientHandler.getUsedPoint(id, usedPointer)) < 0) break;
                ReflectionHelper.setPrivateFieldInt(gSharedTempPointerProperties[j], "id", id);
                ReflectionHelper.setPrivateFieldFloat(gSharedTempPointerCoords[j], "x", inData[2 * id + 0]);
                ReflectionHelper.setPrivateFieldFloat(gSharedTempPointerCoords[j], "y", inData[2 * id + 1]);
                ++id;
                ++j;
            }
            Object[] params = new Object[]{downTime, eventTime, action, pointerCount, gSharedTempPointerProperties, gSharedTempPointerCoords, metaState, 0, Float.valueOf(1.0f), Float.valueOf(1.0f), 0, 0, 4098, 0};
            event = (MotionEvent)ReflectionHelper.invokePrivateMethod(tempEvent, "obtain", params);
        }
        return event;
    }

    private static KeyEvent getKeyEvent(String[] args) {
        int action = Integer.parseInt(args[1]);
        int code = Integer.parseInt(args[2]);
        if (ClientHandler.preJB()) {
            return new KeyEvent(action, code);
        }
        return InjectHelper16.getKeyEvent(action, code);
    }

    private static boolean preJB() {
        return Build.VERSION.SDK_INT < 16;
    }
}

