/*
 * Decompiled with CFR 0.152.
 */
package com.locnet.inject;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.util.Log;
import com.locnet.inject.ClientHandler;
import com.locnet.inject.UInputHelper;
import java.io.IOException;

public class Main {
    static boolean mDebug = false;
    private char mDeviceType;
    private String mSocketName;
    private int port;
    public LocalServerSocket ss = null;

    static {
        System.loadLibrary("uinputserver");
    }

    public Main(String socketName, char deviceType, boolean debug) {
        this.mSocketName = socketName;
        this.mDeviceType = deviceType;
        mDebug = debug;
    }

    public void execute() throws IOException {
        LocalSocket s;
        LocalServerSocket ss = new LocalServerSocket(this.mSocketName);
        if (this.mDeviceType != ' ') {
            UInputHelper.nativeStartServer(this.mDeviceType);
        }
        while ((s = ss.accept()) != null) {
            Log.d((String)"gamepad", (String)("LocnetService: connected " + this.mSocketName));
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        new ClientHandler(s);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        s.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            t.start();
        }
    }

    public static void main(String[] args) {
        Log.d((String)"gamepad", (String)"LocnetService: Starting ...");
        Main instance = null;
        try {
            if (args.length == 0) {
                throw new RuntimeException("Need >= 1 param");
            }
            String socketName = args[0];
            char deviceType = ' ';
            if (args.length >= 2 && args[1].length() == 1) {
                deviceType = args[1].charAt(0);
            }
            boolean debug = args.length >= 3 && args[2].equals("debug");
            instance = new Main(socketName, deviceType, debug);
            instance.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (instance != null && instance.ss != null) {
            try {
                instance.ss.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

