/*
 * Decompiled with CFR 0.152.
 */
package com.locnet.utility;

import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class ReflectionHelper {
    public static Object getPrivateField(Object o, String fieldName) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = o.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fieldName.equals(fields[i].getName())) {
                try {
                    fields[i].setAccessible(true);
                    return fields[i].get(o);
                }
                catch (IllegalAccessException ex) {
                    Assert.fail((String)("IllegalAccessException accessing " + fieldName));
                }
            }
            ++i;
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
        return null;
    }

    public static void setPrivateFieldInt(Object o, String fieldName, int value) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = o.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fieldName.equals(fields[i].getName())) {
                try {
                    fields[i].setAccessible(true);
                    fields[i].setInt(o, value);
                    return;
                }
                catch (IllegalAccessException ex) {
                    Assert.fail((String)("IllegalAccessException accessing " + fieldName));
                }
            }
            ++i;
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
    }

    public static void setPrivateFieldFloat(Object o, String fieldName, float value) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = o.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fieldName.equals(fields[i].getName())) {
                try {
                    fields[i].setAccessible(true);
                    fields[i].setFloat(o, value);
                    return;
                }
                catch (IllegalAccessException ex) {
                    Assert.fail((String)("IllegalAccessException accessing " + fieldName));
                }
            }
            ++i;
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
    }

    public static void listPrivateMethod(Object o) {
        Assert.assertNotNull((Object)o);
        Method[] methods = o.getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Log.d((String)"", (String)methods[i].getName());
            ++i;
        }
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) {
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)methodName);
        Assert.assertNotNull((Object)params);
        Method[] methods = o.getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName()) && methods[i].getGenericParameterTypes().length == params.length) {
                try {
                    methods[i].setAccessible(true);
                    return methods[i].invoke(o, params);
                }
                catch (IllegalAccessException ex) {
                    Assert.fail((String)("IllegalAccessException accessing " + methodName));
                }
                catch (InvocationTargetException ite) {
                    Assert.fail((String)("InvocationTargetException accessing " + methodName));
                }
            }
            ++i;
        }
        Assert.fail((String)("Method '" + methodName + "' not found"));
        return null;
    }
}

